/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelUpdateTripDetailsValidation
extends GenericValidation {
    protected DictionaryValidationService dictionaryValidationService;

    public boolean validate(AttributedDocumentEvent event) {
        TravelReimbursementDocument tr;
        TravelDocument doc = (TravelDocument)event.getDocument();
        Timestamp beginDate = doc.getTripBegin();
        Timestamp endDate = doc.getTripEnd();
        boolean valid = true;
        int preCount = GlobalVariables.getMessageMap().getErrorCount();
        MessageMap errors = GlobalVariables.getMessageMap();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        int postCount = GlobalVariables.getMessageMap().getErrorCount();
        if (postCount > preCount) {
            valid = false;
        }
        if (endDate == null || beginDate == null) {
            this.getDictionaryValidationService().validateDocument((Document)doc);
        }
        if (endDate != null && beginDate != null && ((Date)endDate).compareTo(beginDate) < 0) {
            valid = false;
            GlobalVariables.getMessageMap().putError("tripBegin", "error.document.tem.endDateBeforeBegin", new String[0]);
        }
        if (doc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("TR") && (tr = (TravelReimbursementDocument)doc).getDelinquentAction() != null) {
            if (tr.getDelinquentAction().equals("S") && !tr.getDelinquentTRException().booleanValue()) {
                GlobalVariables.getMessageMap().putError("tripEnd", "error.custom", new String[]{"Travel Reimbursement cannot be initiated because of delinquency."});
            }
            if (tr.getDocumentHeader().getExplanation() == null || tr.getDocumentHeader().getExplanation().trim().length() == 0) {
                GlobalVariables.getMessageMap().putError("document.documentHeader.documentDescription", "error.document.tem.delinquentMessageRequired", new String[0]);
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (doc.getTripType() != null && !doc.getTripType().getUsePerDiem() && doc.getPerDiemExpenses() != null && !doc.getPerDiemExpenses().isEmpty()) {
            GlobalVariables.getMessageMap().putError("document.perDiemExpenses", "error.custom", new String[]{"Per Diem entry is not allowed for this Trip Type [" + doc.getTripType().getCode() + "]."});
            valid = false;
        }
        if (doc.getPrimaryDestinationName() == null || doc.getPrimaryDestinationName().trim().length() == 0) {
            GlobalVariables.getMessageMap().putError("document.primaryDestinationName", "error.custom", new String[]{"Primary Destination is a required field."});
            valid = false;
        }
        return valid;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }
}

