/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report;

import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import org.kuali.kfs.module.tem.report.annotations.ColumnHeader;
import org.kuali.kfs.module.tem.report.annotations.Crosstab;
import org.kuali.kfs.module.tem.report.annotations.DetailSection;
import org.kuali.kfs.module.tem.report.annotations.JasperReport;
import org.kuali.kfs.module.tem.report.annotations.Measure;
import org.kuali.kfs.module.tem.report.annotations.ReportStyle;
import org.kuali.kfs.module.tem.report.annotations.RowHeader;
import org.kuali.kfs.module.tem.report.annotations.SubReport;
import org.kuali.kfs.module.tem.report.annotations.TitleStyle;
import org.kuali.kfs.sys.report.ReportInfoHolder;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.ui.jasperreports.JasperReportsUtils;

@JasperReport
@ReportStyle(value="standard")
@TitleStyle(value="standard")
public class NonEmployeeCertificationReport
extends ReportInfoHolder {
    private String documentId;
    private String eventId;
    private String eventName;
    private String eventType;
    private String traveler;
    private String approvingDepartment;
    private Date beginDate;
    private Date endDate;
    private KualiDecimal totalExpense;
    private String destination;
    private String purpose;
    private String tripId;
    private String institution;
    private BufferedImage barcodeImage;
    private String certificationDescription;
    List<Detail> expenseDetails;
    @Crosstab
    @DetailSection
    @SubReport
    private JRDataSource actualExpenses;

    public NonEmployeeCertificationReport() {
        this.setReportTemplateClassPath("org/kuali/kfs/module/tem/report/");
        this.setReportFileName("NonEmployeeCertification.pdf");
        this.setReportTitle("Non-Employee Certification #");
        this.setReportTemplateName("NonEmployeeCertification");
        this.setDestination("");
    }

    public void setDocumentId(String argDocumentId) {
        this.documentId = argDocumentId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setEventId(String argEventId) {
        this.eventId = argEventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventName(String argEventName) {
        this.eventName = argEventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventType(String argEventType) {
        this.eventType = argEventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setTraveler(String argTraveler) {
        this.traveler = argTraveler;
    }

    public String getTraveler() {
        return this.traveler;
    }

    public void setApprovingDepartment(String argApprovingDepartment) {
        this.approvingDepartment = argApprovingDepartment;
    }

    public String getApprovingDepartment() {
        return this.approvingDepartment;
    }

    public void setBeginDate(Date argBeginDate) {
        this.beginDate = argBeginDate;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setEndDate(Date argEndDate) {
        this.endDate = argEndDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setTotalExpense(KualiDecimal argTotalExpense) {
        this.totalExpense = argTotalExpense;
    }

    public KualiDecimal getTotalExpense() {
        return this.totalExpense;
    }

    public void setDestination(String argDestination) {
        this.destination = argDestination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String argTripId) {
        this.tripId = argTripId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String argPurpose) {
        this.purpose = argPurpose;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String argInstitution) {
        this.institution = argInstitution;
    }

    public JRDataSource getActualExpenses() {
        return this.actualExpenses;
    }

    public void setActualExpenses(Collection<Detail> argOther) {
        this.actualExpenses = JasperReportsUtils.convertReportData(argOther);
    }

    public BufferedImage getBarcodeImage() {
        return this.barcodeImage;
    }

    public void setBarcodeImage(BufferedImage barcodeImage) {
        this.barcodeImage = barcodeImage;
    }

    public String getCertificationDescription() {
        return this.certificationDescription;
    }

    public void setCertificationDescription(String certificationDescription) {
        this.certificationDescription = certificationDescription;
    }

    public List<Detail> getExpenseDetails() {
        return this.expenseDetails;
    }

    public void setExpenseDetails(List<Detail> expenseDetails) {
        this.expenseDetails = expenseDetails;
    }

    public static class Detail {
        @ColumnHeader
        private String name;
        @RowHeader
        private String date;
        @Measure
        private BigDecimal amount;

        public Detail(String name, KualiDecimal amount, String date) {
            this.name = name;
            if (amount != null) {
                this.amount = amount.bigDecimalValue();
            }
            this.date = date;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String argName) {
            this.name = argName;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal argAmount) {
            this.amount = argAmount;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String argDate) {
            this.date = argDate;
        }
    }
}

