/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.authorization.TemProfileAuthorizerAssistant;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileAuthorizer
implements MaintenanceDocumentAuthorizer,
DocumentAuthorizer {
    protected TemProfileAuthorizerAssistant rootDocumentAuthorizer;

    public boolean canCreate(Class boClass, Person user) {
        return this.getRootDocumentAuthorizer().canCreate(boClass, user);
    }

    public boolean canMaintain(Object dataObject, Person user) {
        boolean result = this.getRootDocumentAuthorizer().canMaintain(dataObject, user);
        TemProfile profile = null;
        if (dataObject instanceof TemProfile) {
            profile = (TemProfile)((Object)dataObject);
        } else if (dataObject instanceof MaintenanceDocument) {
            profile = (TemProfile)((MaintenanceDocument)dataObject).getNewMaintainableObject().getBusinessObject();
        }
        return result &= this.doesProfileMatchUser(profile, user) && this.canEditOwnProfile((BusinessObject)dataObject, user) || this.canEditAllProfiles((BusinessObject)dataObject, user);
    }

    public boolean canCreateOrMaintain(org.kuali.kfs.krad.maintenance.MaintenanceDocument maintenanceDocument, Person user) {
        boolean result = this.getRootDocumentAuthorizer().canCreateOrMaintain(maintenanceDocument, user);
        TemProfile profile = (TemProfile)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        return result &= this.doesProfileMatchUser(profile, user) && this.canEditOwnProfile((BusinessObject)maintenanceDocument, user) || this.canEditAllProfiles((BusinessObject)maintenanceDocument, user);
    }

    protected boolean doesProfileMatchUser(TemProfile profile, Person user) {
        if (profile != null && !StringUtils.isBlank((String)profile.getPrincipalId())) {
            String userPrincipalId = user == null ? null : user.getPrincipalId();
            return StringUtils.equals((String)profile.getPrincipalId(), (String)userPrincipalId);
        }
        return false;
    }

    public boolean canEditOwnProfile(BusinessObject profileOrDoc, Person user) {
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (profileOrDoc != null) {
            this.getRootDocumentAuthorizer().addRoleQualification(profileOrDoc, roleQualifications);
        }
        return this.isAuthorized(profileOrDoc, "KFS-TEM", "Edit My TEM Profile", user.getPrincipalId(), Collections.emptyMap(), (Map<String, String>)roleQualifications);
    }

    public boolean canEditAllProfiles(BusinessObject profileOrDoc, Person user) {
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (profileOrDoc != null) {
            this.getRootDocumentAuthorizer().addRoleQualification(profileOrDoc, roleQualifications);
        }
        return this.isAuthorized(profileOrDoc, "KFS-TEM", "Edit All TEM Profiles", user.getPrincipalId(), Collections.emptyMap(), (Map<String, String>)roleQualifications);
    }

    public boolean canCreateAnyProfile(BusinessObject profileOrDoc, Person user) {
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (profileOrDoc != null) {
            this.getRootDocumentAuthorizer().addRoleQualification(profileOrDoc, roleQualifications);
        }
        return this.isAuthorized(profileOrDoc, "KFS-TEM", "Create All TEM Profiles", user.getPrincipalId(), Collections.emptyMap(), (Map<String, String>)roleQualifications);
    }

    public boolean canCopy(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canCopy(document, user);
    }

    public boolean isAuthorized(Object dataObject, String namespaceCode, String permissionName, String principalId) {
        return this.getRootDocumentAuthorizer().isAuthorized(dataObject, namespaceCode, permissionName, principalId);
    }

    public boolean isAuthorizedByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName, String principalId) {
        return this.getRootDocumentAuthorizer().isAuthorizedByTemplate(dataObject, namespaceCode, permissionTemplateName, principalId);
    }

    public boolean isAuthorized(Object dataObject, String namespaceCode, String permissionName, String principalId, Map<String, String> additionalPermissionDetails, Map<String, String> additionalRoleQualifiers) {
        return this.getRootDocumentAuthorizer().isAuthorized(dataObject, namespaceCode, permissionName, principalId, additionalPermissionDetails, additionalRoleQualifiers);
    }

    public Set<String> getSecurePotentiallyHiddenSectionIds() {
        return this.getRootDocumentAuthorizer().getSecurePotentiallyHiddenSectionIds();
    }

    public boolean isAuthorized(BusinessObject businessObject, String namespaceCode, String permissionName, String principalId) {
        return this.getRootDocumentAuthorizer().isAuthorized(businessObject, namespaceCode, permissionName, principalId);
    }

    public boolean isAuthorizedByTemplate(BusinessObject businessObject, String namespaceCode, String permissionTemplateName, String principalId) {
        return this.getRootDocumentAuthorizer().isAuthorizedByTemplate(businessObject, namespaceCode, permissionTemplateName, principalId);
    }

    public boolean isAuthorized(BusinessObject businessObject, String namespaceCode, String permissionName, String principalId, Map<String, String> additionalPermissionDetails, Map<String, String> additionalRoleQualifiers) {
        return this.getRootDocumentAuthorizer().isAuthorized(businessObject, namespaceCode, permissionName, principalId, additionalPermissionDetails, additionalRoleQualifiers);
    }

    public boolean isAuthorizedByTemplate(Object dataObject, String namespaceCode, String permissionTemplateName, String principalId, Map<String, String> additionalPermissionDetails, Map<String, String> additionalRoleQualifiers) {
        return this.getRootDocumentAuthorizer().isAuthorizedByTemplate(dataObject, namespaceCode, permissionTemplateName, principalId, additionalPermissionDetails, additionalRoleQualifiers);
    }

    public Map<String, String> getCollectionItemRoleQualifications(BusinessObject collectionItemBusinessObject) {
        return this.getRootDocumentAuthorizer().getCollectionItemRoleQualifications(collectionItemBusinessObject);
    }

    public Map<String, String> getCollectionItemPermissionDetails(BusinessObject collectionItemBusinessObject) {
        return this.getRootDocumentAuthorizer().getCollectionItemPermissionDetails(collectionItemBusinessObject);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.getRootDocumentAuthorizer().canInitiate(documentTypeName, user);
    }

    public boolean canOpen(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canOpen(document, user);
    }

    public boolean canEdit(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canEdit(document, user);
    }

    public boolean canAnnotate(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canAnnotate(document, user);
    }

    public boolean canReload(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canReload(document, user);
    }

    public boolean canClose(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canClose(document, user);
    }

    public boolean canSave(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canSave(document, user);
    }

    public boolean canRoute(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canRoute(document, user);
    }

    public boolean canCancel(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canCancel(document, user);
    }

    public boolean canPerformRouteReport(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canPerformRouteReport(document, user);
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canBlanketApprove(document, user);
    }

    public boolean canApprove(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canApprove(document, user);
    }

    public boolean canDisapprove(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canDisapprove(document, user);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canSendNoteFyi(document, user);
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canEditDocumentOverview(document, user);
    }

    public boolean canFyi(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canFyi(document, user);
    }

    public boolean canAcknowledge(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canAcknowledge(document, user);
    }

    public boolean canReceiveAdHoc(Document document, Person user, String actionRequestCode) {
        return this.getRootDocumentAuthorizer().canReceiveAdHoc(document, user, actionRequestCode);
    }

    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.getRootDocumentAuthorizer().canAddNoteAttachment(document, attachmentTypeCode, user);
    }

    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.getRootDocumentAuthorizer().canDeleteNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier, user);
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        return this.getRootDocumentAuthorizer().canViewNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier, user);
    }

    public boolean canSendAdHocRequests(Document document, String actionRequestCd, Person user) {
        return this.getRootDocumentAuthorizer().canSendAdHocRequests(document, actionRequestCd, user);
    }

    public boolean canSendAnyTypeAdHocRequests(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canSendAnyTypeAdHocRequests(document, user);
    }

    public boolean canTakeRequestedAction(Document document, String actionRequestCode, Person user) {
        return this.getRootDocumentAuthorizer().canTakeRequestedAction(document, actionRequestCode, user);
    }

    public boolean canRecall(Document document, Person user) {
        return this.getRootDocumentAuthorizer().canRecall(document, user);
    }

    public Set<String> getSecurePotentiallyReadOnlySectionIds() {
        return this.getRootDocumentAuthorizer().getSecurePotentiallyReadOnlySectionIds();
    }

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        return this.getRootDocumentAuthorizer().getDocumentActions(document, user, documentActions);
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.getRootDocumentAuthorizer().canViewNoteAttachment(document, attachmentTypeCode, user);
    }

    protected TemProfileAuthorizerAssistant getRootDocumentAuthorizer() {
        try {
            if (this.rootDocumentAuthorizer == null) {
                this.rootDocumentAuthorizer = (TemProfileAuthorizerAssistant)((Object)TemProfileAuthorizerAssistant.class.newInstance());
            }
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Could not instantiate instance of " + FinancialSystemMaintenanceDocumentAuthorizerBase.class.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Access issues while instantiating instance of " + FinancialSystemMaintenanceDocumentAuthorizerBase.class.getName(), iae);
        }
        return this.rootDocumentAuthorizer;
    }
}

