/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.sys.context.SpringContext;

@Entity
@Table(name="TEM_GRP_TRVLR_T")
public class GroupTraveler
extends PersistableBusinessObjectBase {
    private Integer id;
    private String documentNumber;
    private Integer financialDocumentLineNumber;
    private String name;
    private String groupTravelerTypeCode;
    private String groupTravelerEmpId;

    @Id
    @GeneratedValue(generator="TEM_GRP_TRVLR_ID_SEQ")
    @SequenceGenerator(name="TEM_GRP_TRVLR_ID_SEQ", sequenceName="TEM_GRP_TRVLR_ID_SEQ", allocationSize=5)
    @Column(name="id", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="FDOC_NBR")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Column(name="FDOC_LINE_NBR")
    public Integer getFinancialDocumentLineNumber() {
        return this.financialDocumentLineNumber;
    }

    public void setFinancialDocumentLineNumber(Integer financialDocumentLineNumber) {
        this.financialDocumentLineNumber = financialDocumentLineNumber;
    }

    @Column(name="traveler_typ_cd", length=3, nullable=false)
    public String getGroupTravelerTypeCode() {
        return this.groupTravelerTypeCode;
    }

    public void setGroupTravelerTypeCode(String groupTravelerTypeCode) {
        this.groupTravelerTypeCode = groupTravelerTypeCode;
    }

    public void setGroupTravelerType(String groupTravelerType) {
        for (TemConstants.GroupTravelerType travelerType : TemConstants.GroupTravelerType.values()) {
            if (!travelerType.toString().equalsIgnoreCase(groupTravelerType)) continue;
            this.groupTravelerTypeCode = travelerType.getCode();
        }
    }

    @Column(name="name", length=100, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="trvl_emp_id")
    public String getGroupTravelerEmpId() {
        return this.groupTravelerEmpId;
    }

    public void setGroupTravelerEmpId(String groupTravelerEmpId) {
        this.groupTravelerEmpId = groupTravelerEmpId;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.id);
        map.put("groupTravelerTypeCode", this.groupTravelerTypeCode);
        map.put("name", this.name);
        return map;
    }

    public String getTravelerLabel() {
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "NON_EMPLOYEE_TRAVELER_TYPE_CODES").contains(this.groupTravelerTypeCode)) {
            return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeLabel(((AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class)).createCustomer().getClass(), "customerNumber");
        }
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeLabel(GroupTraveler.class, "groupTravelerEmpId");
    }
}

