/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromCustomer;
import org.kuali.kfs.module.tem.businessobject.datadictionary.TravelDetailLookupMappedFieldProxy;
import org.kuali.kfs.module.tem.dataaccess.TravelerDao;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileFromCustomerLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static Logger LOG = Logger.getLogger(TemProfileFromCustomerLookupableHelperServiceImpl.class);
    private TravelerService travelerService;
    private TravelerDao travelerDao;
    private TemProfileService temProfileService;
    private AccountsReceivableModuleService accountsReceivableModuleService;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        lookupForm.setSuppressActions(false);
        lookupForm.setSupplementalActionsEnabled(true);
        lookupForm.setHideReturnLink(false);
        lookupForm.setShowMaintenanceLinks(true);
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<TemProfileFromCustomer> searchResults = new ArrayList<TemProfileFromCustomer>();
        searchResults.addAll(this.getCustomers(fieldValues));
        CollectionIncomplete results = new CollectionIncomplete(searchResults, Long.valueOf(searchResults.size()));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return results;
    }

    protected Map<String, String> getCustomerFieldValues(Map<String, String> fieldValues) {
        HashMap<String, String> retval = new HashMap<String, String>();
        retval.putAll(this.convertFieldValues(this.getAccountsReceivableModuleService().createCustomer().getClass(), fieldValues, "", TemProfileFromCustomer.class.getName()));
        retval.putAll(this.convertFieldValues(this.getAccountsReceivableModuleService().createCustomerAddress().getClass(), fieldValues, "customerAddresses.", TemProfileFromCustomer.class.getName()));
        retval.put("customerAddresses.customerAddressTypeCode", "P");
        List customerTypes = this.getAccountsReceivableModuleService().findByCustomerTypeDescription("Traveler");
        retval.put("customerTypeCode", ((AccountsReceivableCustomerType)customerTypes.get(0)).getCustomerTypeCode());
        retval.remove("customerEmailAddress");
        return retval;
    }

    private Map<String, String> convertFieldValues(Class<? extends BusinessObject> boClass, Map<String, String> fieldValues, String prefix, String lookupClassName) {
        HashMap<String, String> retval = new HashMap<String, String>();
        LOG.debug((Object)("Converting field values " + fieldValues));
        for (FieldDefinition lookupField : this.getLookupFieldsFor(lookupClassName)) {
            String attrName = lookupField.getAttributeName();
            if (lookupField instanceof TravelDetailLookupMappedFieldProxy) {
                TravelDetailLookupMappedFieldProxy mappedField = (TravelDetailLookupMappedFieldProxy)lookupField;
                String key = mappedField.getAttributeMap().get(boClass.getSimpleName());
                String value = fieldValues.get(attrName);
                if (retval.containsKey(key)) {
                    value = (String)retval.get(key) + value;
                }
                if (key != null) {
                    retval.put(prefix + key, value);
                    continue;
                }
                LOG.warn((Object)("Got a null key for attribute name " + attrName));
                continue;
            }
            if (!this.containsAttribute(boClass, attrName)) continue;
            retval.put(prefix + attrName, fieldValues.get(attrName));
        }
        return retval;
    }

    protected List<TemProfileFromCustomer> getCustomers(Map<String, String> fieldValues) {
        ArrayList<TemProfileFromCustomer> profiles = new ArrayList<TemProfileFromCustomer>();
        Map<String, String> fieldsForLookup = this.getCustomerFieldValues(fieldValues);
        HashMap lookupFieldValues = new HashMap();
        LOG.debug((Object)("Using fieldsForLookup " + fieldsForLookup));
        Collection<AccountsReceivableCustomer> customers = this.getTravelerDao().findCustomersBy(fieldsForLookup);
        for (AccountsReceivableCustomer customer : customers) {
            profiles.add(this.getTravelerService().convertToTemProfileFromCustomer(customer));
        }
        return profiles;
    }

    protected boolean containsAttribute(Class boClass, String attributeName) {
        return this.getDataDictionaryService().isAttributeDefined(boClass, attributeName);
    }

    private Collection<FieldDefinition> getLookupFieldsFor(String className) {
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(className);
        return businessObjectEntry.getLookupDefinition().getLookupFields();
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        String customerNumber = ((TemProfileFromCustomer)businessObject).getCustomerNumber();
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", TemProfile.class.getName());
        parameters.put("overrideKeys", "customerNumber");
        parameters.put("refreshCaller", "customerNumber::" + customerNumber);
        parameters.put("customerNumber", customerNumber);
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("customerNumber", customerNumber);
        if (this.getTemProfileService().findTemProfile(criteria) == null) {
            parameters.put("methodToCall", "start");
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
            HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "create new profile");
            htmlDataList.add(anchorHtmlData);
        } else {
            parameters.put("methodToCall", "edit");
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
            HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "edit profile");
            htmlDataList.add(anchorHtmlData);
        }
        return htmlDataList;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public TravelerDao getTravelerDao() {
        return this.travelerDao;
    }

    public void setTravelerDao(TravelerDao travelerDao) {
        this.travelerDao = travelerDao;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }
}

