/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.kim.api.identity.Person;

public class ReimbursementEmployeeCertificationValidation
extends GenericValidation {
    private TravelerService travelerService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        TravelReimbursementDocument reimbursement = (TravelReimbursementDocument)event.getDocument();
        if (this.requiresCertification(reimbursement.getTraveler()) && !reimbursement.getEmployeeCertification().booleanValue()) {
            GlobalVariables.getMessageMap().addToErrorPath("document");
            GlobalVariables.getMessageMap().putError("employeeCertification", "error.document.tem.employeeCertification", new String[0]);
            GlobalVariables.getMessageMap().removeFromErrorPath("document");
            valid = false;
        }
        return valid;
    }

    protected boolean requiresCertification(TravelerDetail traveler) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return user.getPrincipalId().equals(traveler.getPrincipalId()) && this.isEmployee(traveler);
    }

    protected boolean isEmployee(TravelerDetail traveler) {
        if (traveler == null) {
            return false;
        }
        return this.getTravelerService().isEmployee(traveler);
    }

    public final TravelerService getTravelerService() {
        return this.travelerService;
    }

    public final void setTravelerService(TravelerService argTravelerService) {
        this.travelerService = argTravelerService;
    }
}

