/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TEMReimbursementRequiredAccountingLinesCountValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        boolean validated = true;
        TEMReimbursementDocument reimbursableDocument = (TEMReimbursementDocument)event.getDocument();
        if (reimbursableDocument.hasReimbursableExpenses() && !reimbursableDocument.hasOnlyPrepaidExpenses()) {
            if (reimbursableDocument.getSourceAccountingLines() == null || reimbursableDocument.getSourceAccountingLines().isEmpty()) {
                validated = false;
                GlobalVariables.getMessageMap().putError("document.sourceAccountingLines", "error.document.singleSectionAccountingLines.NoAccountingLines", new String[0]);
            }
        } else if (StringUtils.isBlank((String)reimbursableDocument.getTemProfile().getDefaultChartCode()) || StringUtils.isBlank((String)reimbursableDocument.getTemProfile().getDefaultAccount())) {
            validated = false;
            GlobalVariables.getMessageMap().putError("newSourceLine*", "error.document.tem.profileNotCompleteForNoReimbursement", new String[0]);
        }
        return validated;
    }
}

