/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.validation.event.AddEmergencyContactLineEvent;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelAuthEmergencyContactRequiredInfoValidation
extends GenericValidation {
    protected TravelService travelService;

    public boolean validate(AttributedDocumentEvent event) {
        TravelDocumentBase taDocument = (TravelDocumentBase)event.getDocument();
        boolean valid = true;
        TravelerDetailEmergencyContact emergencyContact = ((AddEmergencyContactLineEvent)event).getEmergencyContact();
        if (StringUtils.isBlank((String)emergencyContact.getContactName())) {
            GlobalVariables.getMessageMap().putError("contactName", "error.required", new String[]{"Contact Name"});
            valid &= false;
        }
        if (StringUtils.isBlank((String)emergencyContact.getPhoneNumber())) {
            GlobalVariables.getMessageMap().putError("phoneNumber", "error.required", new String[]{"Contact Phone Number"});
            valid &= false;
        } else {
            String errorMessage = this.getTravelService().validatePhoneNumber(emergencyContact.getPhoneNumber(), "error.document.tem.contact.phoneNumber");
            if (!StringUtils.isBlank((String)errorMessage)) {
                GlobalVariables.getMessageMap().putError("phoneNumber", errorMessage, new String[]{"Contact Phone Number"});
                valid &= false;
            }
        }
        if (ObjectUtils.isNull((Object)emergencyContact.getContactRelationTypeCode())) {
            GlobalVariables.getMessageMap().putError("contactRelationTypeCode", "error.required", new String[]{"Relationship"});
            valid &= false;
        }
        return valid;
    }

    public TravelService getTravelService() {
        return this.travelService;
    }

    public void setTravelService(TravelService travelService) {
        this.travelService = travelService;
    }
}

