/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.identity.OrganizationHierarchyAwareRoleTypeServiceBase;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.type.KimTypeAttribute;

public class ReimbursementOverageOrganizationHierarchyRoleTypeServiceImpl
extends OrganizationHierarchyAwareRoleTypeServiceBase {
    protected boolean performMatch(Map<String, String> inputAttributes, Map<String, String> storedAttributes) {
        if (this.isParentOrg(inputAttributes.get("chartOfAccountsCode"), inputAttributes.get("organizationCode"), storedAttributes.get("chartOfAccountsCode"), storedAttributes.get("organizationCode"), true)) {
            if (inputAttributes.containsKey("reimbursementAmount") && inputAttributes.containsKey("authorizationAmount")) {
                return this.reimbursementIsGreaterThanAuthorizationByOverage(inputAttributes.get("reimbursementAmount"), inputAttributes.get("authorizationAmount"), storedAttributes.get("reimbursementOveragePercentage"));
            }
            return true;
        }
        return false;
    }

    protected boolean reimbursementIsGreaterThanAuthorizationByOverage(String reimbursementAmountAsString, String authorizationAmountAsString, String reimbursementOveragePercentageAsString) {
        if (StringUtils.isBlank((String)reimbursementOveragePercentageAsString)) {
            return true;
        }
        KualiDecimal reimbursementOveragePercentage = new KualiDecimal(reimbursementOveragePercentageAsString);
        if (reimbursementOveragePercentage.isZero()) {
            return true;
        }
        try {
            KualiDecimal reimbursementAmount = new KualiDecimal(reimbursementAmountAsString);
            KualiDecimal authorizationAmount = new KualiDecimal(authorizationAmountAsString);
            if (KualiDecimal.ZERO.isGreaterEqual((AbstractKualiDecimal)reimbursementAmount) || KualiDecimal.ZERO.isGreaterEqual((AbstractKualiDecimal)authorizationAmount)) {
                return false;
            }
            if (authorizationAmount.isGreaterThan((AbstractKualiDecimal)reimbursementAmount)) {
                return false;
            }
            KualiDecimal oneHundred = new KualiDecimal(100);
            KualiDecimal diff = (KualiDecimal)((KualiDecimal)reimbursementAmount.subtract((AbstractKualiDecimal)authorizationAmount)).multiply((AbstractKualiDecimal)oneHundred);
            KualiDecimal diffPercentage = (KualiDecimal)((KualiDecimal)diff.divide(authorizationAmount.multiply((AbstractKualiDecimal)oneHundred))).multiply((AbstractKualiDecimal)oneHundred);
            return diffPercentage.isGreaterEqual((AbstractKualiDecimal)reimbursementOveragePercentage);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        errors.addAll(super.validateAttributes(kimTypeId, attributes));
        RemotableAttributeError overagePercentageError = this.validateReimbursementOveragePercentage(attributes.get("reimbursementOveragePercentage"));
        if (overagePercentageError != null) {
            errors.add(overagePercentageError);
        }
        return errors;
    }

    protected RemotableAttributeError validateReimbursementOveragePercentage(String reimbursementOveragePercentageAsString) {
        KualiDecimal reimbursementOveragePercentage;
        if (StringUtils.isBlank((String)reimbursementOveragePercentageAsString)) {
            return null;
        }
        RemotableAttributeError.Builder errorBuilder = RemotableAttributeError.Builder.create((String)"reimbursementOveragePercentage");
        try {
            reimbursementOveragePercentage = new KualiDecimal(reimbursementOveragePercentageAsString);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (reimbursementOveragePercentage.isNegative()) {
            errorBuilder.addErrors(new String[]{"error.reimbursement.overage.organization.hierarchy.role.negative"});
        }
        if (!errorBuilder.getErrors().isEmpty()) {
            return errorBuilder.build();
        }
        return null;
    }

    protected List<RemotableAttributeError> validateDataDictionaryAttribute(KimTypeAttribute attr, String key, String value) {
        if ("reimbursementOveragePercentage".equals(key) && !StringUtils.isBlank((String)value)) {
            RemotableAttributeError.Builder errorBuilder = RemotableAttributeError.Builder.create((String)"reimbursementOveragePercentage");
            try {
                new KualiDecimal(value);
            }
            catch (NumberFormatException nfe) {
                errorBuilder.addErrors(new String[]{"error.reimbursement.overage.organization.hierarchy.role.non.numeric"});
                ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
                errors.add(errorBuilder.build());
                return errors;
            }
        }
        return super.validateDataDictionaryAttribute(attr, key, value);
    }
}

