/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.service.NonEmployeeCertificationReportService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class NonEmployeeCertificationReportServiceImpl
implements NonEmployeeCertificationReportService {
    public static Logger LOG = Logger.getLogger(NonEmployeeCertificationReportServiceImpl.class);
    protected ParameterService parameterService;
    protected ReportInfo reportInfo;
    protected PersonService personService;
    protected OrganizationService organizationService;
    protected TravelDocumentService travelDocumentService;
    protected TemProfileService temProfileService;

    @Override
    public NonEmployeeCertificationReport buildReport(TravelDocument travelDocument) {
        NonEmployeeCertificationReport report = new NonEmployeeCertificationReport();
        report.setTripId(travelDocument.getTravelDocumentIdentifier().toString());
        report.setPurpose(travelDocument.getReportPurpose() == null ? "" : travelDocument.getReportPurpose());
        report.setInstitution(this.getParameterService().getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME"));
        report.setCertificationDescription(this.getTravelDocumentService().getMessageFrom("tem.non.employee.certification", report.getInstitution()));
        report.setDocumentId(travelDocument.getTravelDocumentIdentifier().toString());
        if (!ObjectUtils.isNull((Object)((Object)travelDocument.getTraveler()))) {
            report.setTraveler(travelDocument.getTraveler().getFirstName() + " " + travelDocument.getTraveler().getLastName());
        }
        report.setBeginDate(travelDocument.getTripBegin());
        report.setEndDate(travelDocument.getTripEnd());
        report.setEventId(travelDocument.getTravelDocumentIdentifier().toString());
        report.setEventName(travelDocument.getDocumentTitle());
        report.setTotalExpense(travelDocument.getDocumentGrandTotal());
        if (travelDocument instanceof TravelReimbursementDocument) {
            report.setDestination(travelDocument.getPrimaryDestination().getPrimaryDestinationName());
            report.setEventType("TravelReimbursement");
        } else if (travelDocument instanceof TravelRelocationDocument) {
            report.setDestination(this.getDestination((TravelRelocationDocument)travelDocument));
            report.setEventType("TravelRelocation");
        } else if (travelDocument instanceof TravelEntertainmentDocument) {
            report.setEventType(((TravelEntertainmentDocument)travelDocument).getPurpose().getPurposeName());
            report.setEventName(((TravelEntertainmentDocument)travelDocument).getEventTitle());
        }
        String initiatorId = travelDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Person initiator = this.getPersonService().getPerson(initiatorId);
        Organization organization = this.getOrganizationService().getByPrimaryId(StringUtils.substringBefore((String)initiator.getPrimaryDepartmentCode(), (String)"-"), StringUtils.substringAfter((String)initiator.getPrimaryDepartmentCode(), (String)"-"));
        if (ObjectUtils.isNotNull((Object)organization)) {
            report.setApprovingDepartment(organization.getOrganizationName());
        } else {
            report.setApprovingDepartment("N/A");
        }
        ArrayList<NonEmployeeCertificationReport.Detail> other = new ArrayList<NonEmployeeCertificationReport.Detail>();
        HashMap<String, KualiDecimal> summaryData = new HashMap<String, KualiDecimal>();
        if (travelDocument.getActualExpenses() != null) {
            for (ActualExpense expense : travelDocument.getActualExpenses()) {
                expense.refreshReferenceObject("expenseTypeObjectCode");
                String expenseDate = new SimpleDateFormat("MM/dd").format(expense.getExpenseDate());
                NonEmployeeCertificationReport.Detail detail = new NonEmployeeCertificationReport.Detail(expense.getExpenseTypeObjectCode().getExpenseType().getName() == null ? "" : expense.getExpenseTypeObjectCode().getExpenseType().getName(), new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())), expenseDate);
                other.add(detail);
                this.incrementSummary(summaryData, expense);
            }
        }
        if (other.size() == 0) {
            other.add(new NonEmployeeCertificationReport.Detail("", null, ""));
        }
        report.setExpenseDetails(other);
        return report;
    }

    public String getDestination(TravelRelocationDocument relocation) {
        StringBuffer destination = new StringBuffer();
        if (relocation.getToAddress1() != null) {
            destination.append(relocation.getToAddress1() + " ");
        }
        if (relocation.getToAddress2() != null) {
            destination.append(relocation.getToAddress2() + " ");
        }
        if (relocation.getToCity() != null) {
            destination.append(relocation.getToCity() + " ");
        }
        if (relocation.getToStateCode() != null) {
            destination.append(relocation.getToStateCode() + " ");
        }
        if (relocation.getToCountryCode() != null) {
            destination.append(relocation.getToCountryCode());
        }
        return destination.toString();
    }

    protected void incrementSummary(Map<String, KualiDecimal> summaryData, ActualExpense expense) {
        String expenseDate = new SimpleDateFormat("MM/dd").format(expense.getExpenseDate());
        KualiDecimal summaryAmount = summaryData.get(expenseDate);
        if (summaryAmount == null) {
            summaryAmount = KualiDecimal.ZERO;
        }
        summaryAmount = (KualiDecimal)summaryAmount.add((AbstractKualiDecimal)new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())));
        LOG.debug((Object)("Adding " + summaryAmount + " for " + expenseDate + " to summary data"));
        summaryData.put(expenseDate, summaryAmount);
    }

    @Override
    public File generateReport(NonEmployeeCertificationReport report) {
        String reportFileName = this.getReportInfo().getReportFileName();
        String reportDirectory = this.getReportInfo().getReportsDirectory();
        String reportTemplateClassPath = this.getReportInfo().getReportTemplateClassPath();
        String reportTemplateName = this.getReportInfo().getReportTemplateName();
        HashMap<String, Object> reportData = new HashMap<String, Object>();
        reportData.put("report", (Object)report);
        reportData.put("temFaxNumber", this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "FAX_NUMBER"));
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.getReportGenerationService().buildFullFileName(new Date(), reportDirectory, reportFileName, "");
        this.getReportGenerationService().generateReportToPdfFile(reportData, report.getExpenseDetails(), template, fullReportFileName);
        File reportFile = new File(fullReportFileName + ".pdf");
        return reportFile;
    }

    protected ReportGenerationService getReportGenerationService() {
        return (ReportGenerationService)SpringContext.getBean(ReportGenerationService.class);
    }

    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getApprovingDepartment(TravelerDetail traveler) {
        String approvingDepartment = "";
        if (ObjectUtils.isNotNull((Object)((Object)traveler)) && ObjectUtils.isNotNull((Object)traveler.getPrincipalId())) {
            TemProfile profile = this.getTemProfileService().findTemProfileByPrincipalId(traveler.getPrincipalId());
            if (ObjectUtils.isNotNull((Object)((Object)profile)) && ObjectUtils.isNotNull((Object)profile.getHomeDepartment())) {
                approvingDepartment = profile.getHomeDepartment();
            }
        } else if (ObjectUtils.isNotNull((Object)((Object)traveler))) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("firstName", traveler.getFirstName());
            criteria.put("lastName", traveler.getLastName());
            TemProfile profile = this.getTemProfileService().findTemProfile(criteria);
            if (ObjectUtils.isNotNull((Object)((Object)profile)) && ObjectUtils.isNotNull((Object)profile.getHomeDepartment())) {
                approvingDepartment = profile.getHomeDepartment();
            }
        }
        return approvingDepartment;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public OrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }
}

