/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.fp.businessobject.TravelExpenseTypeCode;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.CreditCardStagingData;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.OtherExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.dataaccess.ExpenseTypeObjectCodeDao;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelExpenseServiceImpl
implements TravelExpenseService {
    Logger LOG = Logger.getLogger(TravelExpenseServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected ExpenseTypeObjectCodeDao expenseTypeObjectCodeDao;
    protected DocumentHelperService documentHelperService;
    protected TravelService travelService;

    @Override
    public ExpenseTypeObjectCode getExpenseType(String expense, String documentType, String tripType, String travelerType) {
        if (StringUtils.isBlank((String)expense)) {
            throw new IllegalArgumentException("Expense Type Code cannot be blank");
        }
        Set<String> parentDocumentTypes = this.getTravelService().getParentDocumentTypeNames(documentType);
        List<ExpenseTypeObjectCode> expenseTypeObjectCodes = this.getExpenseTypeObjectCodeDao().findMatchingExpenseTypeObjectCodes(expense, parentDocumentTypes, tripType, travelerType);
        if (expenseTypeObjectCodes == null || expenseTypeObjectCodes.isEmpty()) {
            return null;
        }
        Collections.sort(expenseTypeObjectCodes, this.getExpenseTypeObjectCodeComparator());
        ExpenseTypeObjectCode chosenExpenseTypeObjectCode = expenseTypeObjectCodes.get(0);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("I choose you, " + chosenExpenseTypeObjectCode.toString()));
        }
        return chosenExpenseTypeObjectCode;
    }

    protected Comparator<ExpenseTypeObjectCode> getExpenseTypeObjectCodeComparator() {
        return new ExpenseTypeObjectCodeComparatorByHierarchyLogic();
    }

    @Override
    public ExpenseTypeObjectCode getExpenseTypeObjectCode(String travelExpenseCode, String documentNumber) {
        TravelDocument document = this.retrieveTravelDocument(documentNumber);
        if (document != null) {
            String documentType = document.getFinancialDocumentTypeCode();
            String tripType = document.getTripTypeCode();
            String travelerType = document.getTraveler().getTravelerTypeCode();
            return this.getExpenseType(travelExpenseCode, documentType, tripType, travelerType);
        }
        return null;
    }

    protected TravelDocument retrieveTravelDocument(String documentNumber) {
        TravelDocument document;
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form instanceof TravelFormBase && !StringUtils.isBlank((String)(document = ((TravelFormBase)form).getTravelDocument()).getDocumentNumber()) && document.getDocumentNumber().equals(documentNumber)) {
            return document;
        }
        try {
            document = (TravelDocument)this.getDocumentService().getByDocumentHeaderIdSessionless(documentNumber);
            return document;
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Could not retrieve document " + documentNumber, we);
        }
    }

    @Override
    public List<ExpenseType> getExpenseTypesForDocument(String documentTypeName, String tripType, String travelerType, boolean groupOnly) {
        Set<String> documentTypesForSearch = this.getTravelService().getParentDocumentTypeNames(documentTypeName);
        List<ExpenseTypeObjectCode> expenseTypeObjectCodes = this.getExpenseTypeObjectCodeDao().findMatchingExpenseTypesObjectCodes(documentTypesForSearch, tripType, travelerType);
        HashSet<String> expenseTypeCodes = new HashSet<String>();
        ArrayList<ExpenseType> expenseTypes = new ArrayList<ExpenseType>();
        for (ExpenseTypeObjectCode expenseTypeObjectCode : expenseTypeObjectCodes) {
            if (expenseTypeCodes.contains(expenseTypeObjectCode.getExpenseTypeCode()) || groupOnly && (!groupOnly || !expenseTypeObjectCode.getExpenseType().isGroupTravel())) continue;
            expenseTypeObjectCode.refreshReferenceObject("expenseType");
            expenseTypes.add(expenseTypeObjectCode.getExpenseType());
            expenseTypeCodes.add(expenseTypeObjectCode.getExpenseTypeCode());
        }
        return expenseTypes;
    }

    @Override
    public HistoricalTravelExpense createHistoricalTravelExpense(AgencyStagingData agency) {
        HistoricalTravelExpense expense = new HistoricalTravelExpense();
        try {
            expense.setImportDate(this.dateTimeService.convertToSqlDate(agency.getProcessingTimestamp()));
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to convert timestamp to date " + e.getMessage());
        }
        CreditCardAgency ccAgency = agency.getCreditCardAgency();
        expense.setCreditCardAgency(ccAgency);
        expense.setCreditCardOrAgencyCode(ccAgency.getCreditCardOrAgencyCode());
        ExpenseType expenseType = this.getDefaultExpenseTypeForCategory(agency.getExpenseTypeCategory());
        if (expenseType != null) {
            expense.setTravelExpenseTypeCode(expenseType.getCode());
        }
        expense.setTravelCompany(agency.getMerchantName());
        expense.setAmount(agency.getTripExpenseAmount());
        expense.setTransactionPostingDate(agency.getTransactionPostingDate());
        expense.setAgencyStagingDataId(agency.getId());
        expense.setTripId(agency.getTripId());
        expense.setProfileId(agency.getTemProfileId());
        expense.setReconciled("N");
        return expense;
    }

    protected TravelExpenseTypeCode getTravelExpenseTypeCode(String expenseType) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("code", expenseType);
        return (TravelExpenseTypeCode)this.getBusinessObjectService().findByPrimaryKey(TravelExpenseTypeCode.class, primaryKeys);
    }

    @Override
    public HistoricalTravelExpense createHistoricalTravelExpense(CreditCardStagingData creditCard) {
        HistoricalTravelExpense expense = new HistoricalTravelExpense();
        try {
            expense.setImportDate(this.dateTimeService.convertToSqlDate(creditCard.getProcessingTimestamp()));
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to convert timestamp to date " + e.getMessage());
        }
        CreditCardAgency ccAgency = creditCard.getCreditCardAgency();
        expense.setCreditCardOrAgencyCode(ccAgency.getCreditCardOrAgencyCode());
        expense.setTravelExpenseTypeCode(creditCard.getExpenseTypeCode());
        expense.setDescription(creditCard.getExpenseTypeCode());
        expense.setTravelCompany(creditCard.getMerchantName());
        expense.setAmount(creditCard.getTransactionAmount());
        expense.setTransactionPostingDate(creditCard.getTransactionDate());
        expense.setCreditCardStagingDataId(creditCard.getId());
        expense.setProfileId(creditCard.getTemProfileId());
        expense.setLocation(creditCard.getLocation());
        expense.setReconciled("N");
        return expense;
    }

    @Override
    public HistoricalTravelExpense createHistoricalTravelExpense(AgencyStagingData agency, CreditCardStagingData creditCard, ExpenseTypeObjectCode travelExpenseType) {
        HistoricalTravelExpense expense = this.createHistoricalTravelExpense(agency);
        expense.setLocation(creditCard.getLocation());
        expense.setCreditCardStagingDataId(creditCard.getId());
        expense.setReconciled("R");
        expense.setReconciliationDate(this.getDateTimeService().getCurrentSqlDate());
        return expense;
    }

    @Override
    public List<AgencyStagingData> retrieveValidAgencyData() {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("errorCode", "OK");
        criteria.put("active", "Y");
        List agencyData = (List)this.getBusinessObjectService().findMatching(AgencyStagingData.class, criteria);
        return agencyData;
    }

    @Override
    public List<AgencyStagingData> retrieveValidAgencyDataByImportType(String importBy) {
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("errorCode", "OK");
        criteria.put("importBy", importBy);
        List agencyData = (List)this.getBusinessObjectService().findMatching(AgencyStagingData.class, criteria);
        return agencyData;
    }

    @Override
    public List<CreditCardStagingData> retrieveValidCreditCardData() {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("errorCode", "OK");
        criteria.put("importBy", "TRV");
        List creditCardData = (List)this.getBusinessObjectService().findMatching(CreditCardStagingData.class, criteria);
        return creditCardData;
    }

    @Override
    public CreditCardStagingData findImportedCreditCardExpense(KualiDecimal amount, String itineraryNumber) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("transactionAmount", amount);
        criteria.put("itineraryNumber", itineraryNumber);
        criteria.put("errorCode", "OK");
        List creditCardData = (List)this.getBusinessObjectService().findMatching(CreditCardStagingData.class, criteria);
        if (ObjectUtils.isNotNull((Object)creditCardData) && creditCardData.size() > 0) {
            return (CreditCardStagingData)((Object)creditCardData.get(0));
        }
        return null;
    }

    @Override
    public CreditCardStagingData findImportedCreditCardExpense(KualiDecimal amount, String ticketNumber, String serviceFeeNumber) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("transactionAmount", amount);
        criteria.put("ticketNumber", ticketNumber);
        criteria.put("serviceFeeNumber", serviceFeeNumber);
        criteria.put("errorCode", "OK");
        List creditCardData = (List)this.getBusinessObjectService().findMatching(CreditCardStagingData.class, criteria);
        if (ObjectUtils.isNotNull((Object)creditCardData) && creditCardData.size() > 0) {
            return (CreditCardStagingData)((Object)creditCardData.get(0));
        }
        return null;
    }

    @Override
    public void updateTaxabilityOfActualExpense(ActualExpense actualExpense, TravelDocument document, Person currentUser) {
        if (!ObjectUtils.isNull((Object)((Object)actualExpense.getExpenseTypeObjectCode()))) {
            HashMap<String, String> permissionDetails = new HashMap<String, String>();
            permissionDetails.put("documentTypeName", document.getDocumentTypeName());
            permissionDetails.put("editMode", "expenseTaxableEntry");
            boolean canEditTaxable = this.getDocumentHelperService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-NS", "Use Transactional Document", currentUser.getPrincipalId(), permissionDetails, Collections.emptyMap());
            if (!canEditTaxable) {
                actualExpense.setTaxable(actualExpense.getExpenseTypeObjectCode().isTaxable());
            }
        }
    }

    @Override
    public ExpenseType getDefaultExpenseTypeForCategory(TemConstants.ExpenseTypeMetaCategory category) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("expenseTypeMetaCategoryCode", category.getCode());
        fieldValues.put("categoryDefault", Boolean.TRUE);
        fieldValues.put("active", Boolean.TRUE);
        Collection expenseTypes = this.getBusinessObjectService().findMatching(ExpenseType.class, fieldValues);
        if (expenseTypes == null || expenseTypes.isEmpty()) {
            return null;
        }
        Iterator expenseTypesIterator = expenseTypes.iterator();
        ExpenseType returnValue = (ExpenseType)((Object)expenseTypesIterator.next());
        while (expenseTypesIterator.hasNext()) {
            expenseTypesIterator.next();
        }
        return returnValue;
    }

    @Override
    public TemExpenseService getExpenseServiceByType(TemConstants.ExpenseType expenseType) {
        return (TemExpenseService)SpringContext.getBean(TemExpense.class, (String)expenseType.service);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    public ExpenseTypeObjectCodeDao getExpenseTypeObjectCodeDao() {
        return this.expenseTypeObjectCodeDao;
    }

    public void setExpenseTypeObjectCodeDao(ExpenseTypeObjectCodeDao expenseTypeObjectCodeDao) {
        this.expenseTypeObjectCodeDao = expenseTypeObjectCodeDao;
    }

    public DocumentHelperService getDocumentHelperService() {
        return this.documentHelperService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    public TravelService getTravelService() {
        return this.travelService;
    }

    public void setTravelService(TravelService travelService) {
        this.travelService = travelService;
    }

    @Override
    public boolean isTravelExpenseExceedReceiptRequirementThreshold(OtherExpense expense) {
        boolean isExceed = false;
        ExpenseTypeObjectCode expenseTypeCode = expense.getExpenseTypeObjectCode();
        if (expenseTypeCode.isReceiptRequired()) {
            if (expenseTypeCode.getReceiptRequirementThreshold() != null) {
                KualiDecimal threshold = expenseTypeCode.getReceiptRequirementThreshold();
                isExceed = threshold.isLessThan((AbstractKualiDecimal)expense.getExpenseAmount());
            } else {
                isExceed = true;
            }
        }
        return isExceed;
    }

    @Override
    public boolean isTripAccountingInformationEmpty(TripAccountingInformation accountingInformation) {
        return StringUtils.isEmpty((String)accountingInformation.getTripChartCode()) && StringUtils.isEmpty((String)accountingInformation.getTripAccountNumber()) && StringUtils.isEmpty((String)accountingInformation.getTripSubAccountNumber()) && StringUtils.isEmpty((String)accountingInformation.getObjectCode()) && StringUtils.isEmpty((String)accountingInformation.getSubObjectCode()) && StringUtils.isEmpty((String)accountingInformation.getProjectCode()) && StringUtils.isEmpty((String)accountingInformation.getOrganizationReference());
    }

    @Override
    public ActualExpense createNewDetailForActualExpense(ActualExpense parent) {
        ActualExpense newExpense = new ActualExpense();
        try {
            BeanUtils.copyProperties((Object)newExpense, (Object)parent);
            newExpense.setConvertedAmount(null);
            newExpense.setExpenseParentId(newExpense.getId());
            newExpense.setId(null);
            newExpense.setNotes(null);
            newExpense.setExpenseLineTypeCode(null);
        }
        catch (IllegalAccessException ex) {
            this.LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            this.LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return newExpense;
    }

    protected class ExpenseTypeComparatorByCode
    implements Comparator<ExpenseType> {
        protected ExpenseTypeComparatorByCode() {
        }

        @Override
        public int compare(ExpenseType lava, ExpenseType kusha) {
            if (StringUtils.equals((String)lava.getCode(), (String)kusha.getCode())) {
                return 0;
            }
            if (lava.getCode() == null && !StringUtils.isBlank((String)kusha.getCode())) {
                return 1;
            }
            return lava.getCode().compareTo(kusha.getCode());
        }
    }

    protected class ExpenseTypeObjectCodeComparatorByHierarchyLogic
    implements Comparator<ExpenseTypeObjectCode> {
        protected ExpenseTypeObjectCodeComparatorByHierarchyLogic() {
        }

        @Override
        public int compare(ExpenseTypeObjectCode dora, ExpenseTypeObjectCode nora) {
            if (!StringUtils.equals((String)dora.getExpenseTypeCode(), (String)nora.getExpenseTypeCode())) {
                return dora.getExpenseTypeCode().compareTo(nora.getExpenseTypeCode());
            }
            if (!StringUtils.equals((String)dora.getDocumentTypeName(), (String)nora.getDocumentTypeName())) {
                int doraDocLevel = this.getLevelForDocumentType(dora.getDocumentTypeName());
                int noraDocLevel = this.getLevelForDocumentType(nora.getDocumentTypeName());
                int delta = doraDocLevel - noraDocLevel;
                return delta;
            }
            if (!StringUtils.equals((String)dora.getTravelerTypeCode(), (String)nora.getTravelerTypeCode())) {
                if ("All".equals(dora.getTravelerTypeCode())) {
                    return 1;
                }
                if ("All".equals(nora.getTravelerTypeCode())) {
                    return -1;
                }
            }
            if (!StringUtils.equals((String)dora.getTripTypeCode(), (String)nora.getTripTypeCode())) {
                if ("All".equals(dora.getTripTypeCode())) {
                    return 1;
                }
                if ("All".equals(nora.getTripTypeCode())) {
                    return -1;
                }
                if (StringUtils.isBlank((String)dora.getTripTypeCode())) {
                    return 1;
                }
                return dora.getTripTypeCode().compareTo(nora.getTripTypeCode());
            }
            return 0;
        }

        protected int getLevelForDocumentType(String documentType) {
            if ("TT".equals(documentType)) {
                return 3;
            }
            if ("TRV".equals(documentType) || "ENT".equals(documentType) || "RELO".equals(documentType)) {
                return 2;
            }
            if ("TA".equals(documentType) || "TR".equals(documentType)) {
                return 1;
            }
            return 0;
        }
    }
}

