/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class TravelAuthorizationServiceTest
extends KualiTestBase {
    private TravelAuthorizationService taService;
    private static final int EXPENSE_AMOUNT = 100;
    private static final int MILEAGE = 2;
    private static final int MILEAGE_RATE = 10;
    private ParameterService parameterService;
    private TravelAuthorizationDocument ta = null;
    private TravelerDetail traveler = null;
    private FinancialSystemDocumentHeader documentHeader = null;
    private static final Logger LOG = Logger.getLogger(TravelAuthorizationServiceTest.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.taService = (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        this.ta = new TravelAuthorizationDocument();
        this.traveler = new TravelerDetail();
        this.traveler.setFirstName("firstName");
        this.traveler.setLastName("lastName");
        this.traveler.setStreetAddressLine1("streetAddressLine1");
        this.traveler.setStreetAddressLine2("streetAddressLine2");
        this.traveler.setCityName("city");
        this.traveler.setStateCode("AZ");
        this.traveler.setZipCode("85257");
        this.traveler.setTravelerTypeCode("EMP");
    }

    @After
    public void tearDown() throws Exception {
        this.taService = null;
        super.tearDown();
    }

    @Test
    public void testCreateCustomerInvoice() {
        boolean success = false;
        try {
            this.taService.createCustomerInvoice(this.ta);
            success = true;
        }
        catch (Exception e) {
            success = false;
            LOG.warn((Object)"NPE.", (Throwable)e);
        }
        TravelAuthorizationServiceTest.assertTrue((boolean)success);
    }

    @Test
    public void testGetTravelAuthorizationBy() {
        this.ta = this.taService.getTravelAuthorizationBy(null);
        TravelAuthorizationServiceTest.assertNull((Object)this.ta);
        try {
            this.ta = this.taService.getTravelAuthorizationBy("-1");
        }
        catch (UnknownDocumentIdException e) {
            TravelAuthorizationServiceTest.assertNull((Object)this.ta);
        }
    }

    @Test
    public void testFind() {
        List result = (List)this.taService.find(null);
        TravelAuthorizationServiceTest.assertNotNull((Object)result);
        result = (List)this.taService.find("-1");
        TravelAuthorizationServiceTest.assertNotNull((Object)result);
        TravelAuthorizationServiceTest.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFindAmendment() {
        List result = (List)this.taService.findAmendment(null);
        TravelAuthorizationServiceTest.assertNotNull((Object)result);
        result = (List)this.taService.findAmendment(Integer.valueOf(-1));
        TravelAuthorizationServiceTest.assertNotNull((Object)result);
        TravelAuthorizationServiceTest.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }
}

