/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.PaymentSourceWireTransfer;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class TravelReimbursementServiceTest
extends KualiTestBase {
    private static final int EXPENSE_AMOUNT = 100;
    private TravelReimbursementDocument tr = null;
    private TravelerDetail traveler = null;
    private TravelReimbursementService trService;
    private DocumentService documentService;
    private static final Logger LOG = Logger.getLogger(TravelReimbursementServiceTest.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.trService = (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.tr = (TravelReimbursementDocument)DocumentTestUtils.createDocument((DocumentService)this.documentService, TravelReimbursementDocument.class);
        Calendar d = Calendar.getInstance();
        d.add(5, 1);
        this.tr.setTripBegin(new Timestamp(d.getTimeInMillis()));
        d.add(5, 2);
        this.tr.setTripEnd(new Timestamp(d.getTimeInMillis()));
        this.documentService.prepareWorkflowDocument((Document)this.tr);
        this.traveler = new TravelerDetail(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        this.traveler.setTravelerTypeCode("EMP");
        this.traveler.setCustomer((AccountsReceivableCustomer)new Customer());
        this.tr.setTraveler(this.traveler);
        TravelPayment travelPayment = new TravelPayment();
        travelPayment.setDocumentationLocationCode("T");
        travelPayment.setPaymentMethodCode("W");
        this.tr.setTravelPayment(travelPayment);
        PaymentSourceWireTransfer wireTransfer = new PaymentSourceWireTransfer();
        wireTransfer.setWireTransferFeeWaiverIndicator(false);
        this.tr.setWireTransfer(wireTransfer);
    }

    @After
    public void tearDown() throws Exception {
        this.trService = null;
        super.tearDown();
    }

    @Test
    public void testFindByTravelDocumentIdentifier() throws WorkflowException {
        this.documentService.saveDocument((Document)this.tr, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        List result = this.trService.findByTravelId("-1");
        TravelReimbursementServiceTest.assertNotNull((Object)result);
        TravelReimbursementServiceTest.assertTrue((boolean)result.isEmpty());
        result = this.trService.findByTravelId(this.tr.getTravelDocumentIdentifier());
        TravelReimbursementServiceTest.assertNotNull((Object)result);
        TravelReimbursementServiceTest.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testFindByDocumentNumber() throws WorkflowException {
        TravelReimbursementServiceTest.assertNull((Object)this.trService.find(this.tr.getDocumentHeader().getDocumentNumber()));
        this.documentService.saveDocument((Document)this.tr, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        TravelReimbursementServiceTest.assertNotNull((Object)this.trService.find(this.tr.getDocumentHeader().getDocumentNumber()));
    }

    @Test
    public void testAddListenersTo() {
        boolean success = false;
        try {
            this.trService.addListenersTo(this.tr);
            success = true;
        }
        catch (NullPointerException e) {
            success = false;
            LOG.warn((Object)"NPE.", (Throwable)e);
        }
        TravelReimbursementServiceTest.assertTrue((boolean)success);
    }

    @Test
    public void testGenerateCoversheetFor() throws Exception {
        Coversheet cover = null;
        try {
            cover = this.trService.generateCoversheetFor(new TravelReimbursementDocument());
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"Workflow doc is null.", (Throwable)e);
        }
        TravelReimbursementServiceTest.assertNull((Object)cover);
        this.tr.setTripBegin(new Timestamp(new Date().getTime()));
        this.tr.setTripEnd(new Timestamp(new Date().getTime()));
        cover = this.trService.generateCoversheetFor(this.tr);
        TravelReimbursementServiceTest.assertNotNull((Object)cover);
    }
}

