/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.kuali.kfs.fp.businessobject.TravelCompanyCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Entity
@Table(name="tem_trvl_exp_t")
public abstract class AbstractExpense
extends PersistableBusinessObjectBase
implements TemExpense {
    public static Logger LOG = Logger.getLogger(AbstractExpense.class);
    @GeneratedValue(generator="tem_trvl_exp_id_seq")
    @SequenceGenerator(name="tem_trvl_exp_id_seq", sequenceName="tem_trvl_exp_id_seq", allocationSize=5)
    private Long id;
    private String documentNumber;
    private Integer documentLineNumber;
    private Date expenseDate;
    private KualiDecimal expenseAmount = new KualiDecimal(0.0);
    private Boolean nonReimbursable = Boolean.FALSE;
    private Long expenseTypeObjectCodeId;
    private ExpenseTypeObjectCode expenseTypeObjectCode;
    private ExpenseType expenseType;
    private Long expenseParentId;
    private String description;
    private BigDecimal currencyRate = new BigDecimal(1.0);
    private String travelCompanyCodeName;
    private TravelCompanyCode travelCompanyCode;
    private String expenseTypeCode;
    private Boolean taxable = Boolean.FALSE;
    private Boolean missingReceipt = Boolean.FALSE;
    private KualiDecimal convertedAmount;
    private List<TemExpense> expenseDetails = new ArrayList<TemExpense>();

    @Override
    @Id
    @Column(name="id", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="fdoc_nbr", length=14, nullable=false)
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    @Column(name="fdoc_line_nbr", nullable=false)
    public Integer getDocumentLineNumber() {
        return this.documentLineNumber;
    }

    @Override
    public void setDocumentLineNumber(Integer documentLineNumber) {
        this.documentLineNumber = documentLineNumber;
    }

    @Override
    @Column(name="exp_parent_id", nullable=true)
    public Long getExpenseParentId() {
        return this.expenseParentId;
    }

    @Override
    public void setExpenseParentId(Long expenseParentId) {
        this.expenseParentId = expenseParentId;
    }

    @Override
    @Column(name="exp_dt", nullable=true)
    public Date getExpenseDate() {
        return this.expenseDate;
    }

    @Override
    public void setExpenseDate(Date expenseDate) {
        this.expenseDate = expenseDate;
    }

    @Override
    @Column(name="NON_REIM_IND", nullable=true, length=1)
    public Boolean getNonReimbursable() {
        return this.nonReimbursable != null ? this.nonReimbursable : false;
    }

    @Override
    public void setNonReimbursable(Boolean nonReimbursable) {
        this.nonReimbursable = nonReimbursable;
    }

    @Override
    @Column(name="TAXABLE_IND", nullable=true, length=1)
    public Boolean getTaxable() {
        return this.taxable;
    }

    @Override
    public void setTaxable(Boolean argTaxable) {
        this.taxable = argTaxable;
    }

    @Override
    @Column(name="MISG_RCPT_IND", nullable=true, length=1)
    public Boolean getMissingReceipt() {
        return this.missingReceipt;
    }

    @Override
    public void setMissingReceipt(Boolean argMissingReceipt) {
        this.missingReceipt = argMissingReceipt;
    }

    @Override
    @Column(name="EXP_AMT", precision=19, scale=2, nullable=false)
    public KualiDecimal getExpenseAmount() {
        return this.expenseAmount;
    }

    @Override
    public void setExpenseAmount(KualiDecimal expenseAmount) {
        this.expenseAmount = expenseAmount;
    }

    @Override
    public Long getExpenseTypeObjectCodeId() {
        return this.expenseTypeObjectCodeId;
    }

    @Override
    public void setExpenseTypeObjectCodeId(Long expenseTypeObjectCodeId) {
        this.expenseTypeObjectCodeId = expenseTypeObjectCodeId;
    }

    @Override
    public ExpenseTypeObjectCode getExpenseTypeObjectCode() {
        return this.expenseTypeObjectCode;
    }

    @Override
    public void setExpenseTypeObjectCode(ExpenseTypeObjectCode expenseTypeObjectCode) {
        this.expenseTypeObjectCode = expenseTypeObjectCode;
    }

    public void setTravelExpenseTypeCode(ExpenseTypeObjectCode argTravelExpenseTypeCode) {
        this.expenseTypeObjectCode = argTravelExpenseTypeCode;
    }

    @Override
    @Column(name="EXP_DESC", length=255, nullable=true)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String argDescription) {
        this.description = argDescription;
    }

    @Override
    public String getNotes() {
        return this.description;
    }

    @Override
    public void setNotes(String argDescription) {
        this.description = argDescription;
    }

    @Override
    @Column(name="CUR_RT", precision=4, scale=3, nullable=false)
    public BigDecimal getCurrencyRate() {
        if (this.currencyRate == null) {
            this.currencyRate = new BigDecimal(1.0);
        }
        return this.currencyRate;
    }

    @Override
    public void setCurrencyRate(BigDecimal argCurrencyRate) {
        this.currencyRate = argCurrencyRate;
    }

    @Override
    public void setConvertedAmount(KualiDecimal convertedAmount) {
        this.convertedAmount = convertedAmount;
    }

    @Override
    @Column(name="CONVERTED_AMT", precision=7, scale=2, nullable=true)
    public KualiDecimal getConvertedAmount() {
        KualiDecimal calc = KualiDecimal.ZERO;
        if (this.getExpenseAmount() != null && this.getCurrencyRate() != null) {
            calc = new KualiDecimal(this.getExpenseAmount().bigDecimalValue().multiply(this.getCurrencyRate()));
        }
        if (!calc.equals((Object)this.convertedAmount)) {
            this.convertedAmount = calc;
        }
        return this.convertedAmount;
    }

    @Override
    @Column(name="DV_EXP_CO_NM", nullable=false)
    public String getTravelCompanyCodeName() {
        return this.travelCompanyCodeName;
    }

    @Override
    public void setTravelCompanyCodeName(String argTravelCompanyCodeName) {
        this.travelCompanyCodeName = argTravelCompanyCodeName;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="DV_EXP_CO_NM", nullable=false)
    public TravelCompanyCode getTravelCompanyCode() {
        return this.travelCompanyCode;
    }

    @Override
    public void setTravelCompanyCode(TravelCompanyCode argTravelCompanyCode) {
        this.travelCompanyCode = argTravelCompanyCode;
    }

    @Override
    public String getExpenseTypeCode() {
        return this.expenseTypeCode;
    }

    public void setExpenseTypeCode(String travelCompanyCodeCode) {
        this.expenseTypeCode = travelCompanyCodeCode;
    }

    @Override
    public void refreshExpenseTypeObjectCode(String documentTypeName, String travelerTypeCode, String tripTypeCode) {
        ExpenseTypeObjectCode expenseTypeObjectCode = ((TravelExpenseService)SpringContext.getBean(TravelExpenseService.class)).getExpenseType(this.expenseTypeCode, documentTypeName, tripTypeCode, travelerTypeCode);
        if (expenseTypeObjectCode != null) {
            this.expenseTypeObjectCodeId = expenseTypeObjectCode.getExpenseTypeObjectCodeId();
            this.expenseTypeObjectCode = expenseTypeObjectCode;
            for (TemExpense temExpense : this.getExpenseDetails()) {
                temExpense.setExpenseTypeObjectCodeId(expenseTypeObjectCode.getExpenseTypeObjectCodeId());
                temExpense.setExpenseTypeObjectCode(expenseTypeObjectCode);
            }
        }
    }

    @Override
    public List<? extends TemExpense> getExpenseDetails() {
        if (this.expenseDetails == null) {
            this.expenseDetails = new ArrayList<TemExpense>();
        }
        return this.expenseDetails;
    }

    @Override
    public void addExpenseDetails(TemExpense expense) {
        this.expenseDetails.add(expense);
    }

    @Override
    public void setExpenseDetails(List<TemExpense> expenseDetails) {
        this.expenseDetails = expenseDetails;
    }

    public ExpenseType getExpenseType() {
        return this.expenseType;
    }

    @Override
    public String getSequenceName() {
        String retval;
        block7: {
            Class<?> boClass = this.getClass();
            retval = "";
            try {
                boolean rethrow = true;
                Exception e = null;
                while (rethrow) {
                    LOG.debug((Object)("Looking for id in " + boClass.getName()));
                    try {
                        Field idField = boClass.getDeclaredField("id");
                        SequenceGenerator sequenceInfo = idField.getAnnotation(SequenceGenerator.class);
                        return sequenceInfo.sequenceName();
                    }
                    catch (Exception ee) {
                        LOG.debug((Object)("Could not find id in " + boClass.getName()));
                        if (Object.class.equals(boClass)) {
                            rethrow = false;
                        }
                        boClass = boClass.getSuperclass();
                        e = ee;
                    }
                }
                if (e != null) {
                    throw e;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not get the sequence name for business object " + this.getClass().getSimpleName()));
                LOG.error((Object)e.getMessage());
                if (!LOG.isDebugEnabled()) break block7;
                e.printStackTrace();
            }
        }
        return retval;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    @Override
    public KualiDecimal getTotalDetailExpenseAmount() {
        KualiDecimal totalDetailExpenseAmount = KualiDecimal.ZERO;
        for (TemExpense temExpense : this.getExpenseDetails()) {
            totalDetailExpenseAmount = (KualiDecimal)totalDetailExpenseAmount.add((AbstractKualiDecimal)temExpense.getExpenseAmount());
        }
        return totalDetailExpenseAmount;
    }
}

