/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.kfs.kns.web.struts.action.KualiTableRenderAction;
import org.kuali.kfs.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.comparator.NumericValueComparator;
import org.kuali.kfs.krad.comparator.TemporalValueComparator;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.businessobject.AgencyCorrectionChangeGroup;
import org.kuali.kfs.module.tem.businessobject.AgencyEntryFull;
import org.kuali.kfs.module.tem.document.TemCorrectionProcessDocument;
import org.kuali.kfs.module.tem.document.service.TemCorrectionDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TemCorrectionForm;
import org.kuali.kfs.module.tem.service.AgencyEntryGroupService;
import org.kuali.kfs.module.tem.service.AgencyEntryService;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TemCorrectionAction
extends KualiDocumentActionBase
implements KualiTableRenderAction {
    protected static Logger LOG = Logger.getLogger(TemCorrectionAction.class);
    public static final int DEFAULT_RECORD_COUNT_FUNCTIONALITY_LIMIT = 1000;
    public static final int DEFAULT_RECORDS_PER_PAGE = 10;
    protected static AgencyEntryGroupService agencyEntryGroupService;
    protected static AgencyEntryService agencyEntryService;
    protected static DateTimeService dateTimeService;
    protected static ConfigurationService ConfigurationService;
    protected static ExpenseImportByTripService expenseImportByTripService;
    public static final String SYSTEM_AND_EDIT_METHOD_ERROR_KEY = "systemAndEditMethod";
    private static final int MAX_ROWS = 25;

    public ActionForward switchToPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        int maxRowsPerPage = 25;
        KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
        agencyEntrySearchResultTableMetadata.jumpToPage(agencyEntrySearchResultTableMetadata.getSwitchToPageNumber(), correctionForm.getDisplayEntries().size(), maxRowsPerPage);
        agencyEntrySearchResultTableMetadata.setColumnToSortIndex(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex());
        return mapping.findForward("basic");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        int maxRowsPerPage = 25;
        KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
        List<Column> columns = ((TemCorrectionDocumentService)SpringContext.getBean(TemCorrectionDocumentService.class)).getTableRenderColumnMetadata(correctionForm.getDocument().getDocumentNumber());
        String propertyToSortName = columns.get(agencyEntrySearchResultTableMetadata.getColumnToSortIndex()).getPropertyName();
        Comparator valueComparator = columns.get(agencyEntrySearchResultTableMetadata.getColumnToSortIndex()).getValueComparator();
        boolean sortDescending = false;
        if (agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() == agencyEntrySearchResultTableMetadata.getColumnToSortIndex()) {
            sortDescending = !agencyEntrySearchResultTableMetadata.isSortDescending();
            agencyEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        }
        agencyEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        this.sortList(correctionForm.getDisplayEntries(), propertyToSortName, valueComparator, sortDescending);
        agencyEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
        return mapping.findForward("basic");
    }

    public ActionForward selectSystemEditMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"selectSystemEditMethod() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        if (this.checkMainDropdown(correctionForm)) {
            document.setCorrectionInputFileName(null);
            document.setCorrectionOutputFileName(null);
            document.setCorrectionTripTotalAmount(null);
            document.setCorrectionRowCount(null);
            document.getCorrectionChangeGroup().clear();
            correctionForm.setDataLoadedFlag(false);
            correctionForm.setDeleteFileFlag(false);
            correctionForm.setEditableFlag(false);
            correctionForm.setManualEditFlag(false);
            correctionForm.setShowOutputFlag(false);
            correctionForm.setAllEntries(new ArrayList<AgencyEntryFull>());
            correctionForm.setRestrictedFunctionalityMode(false);
            correctionForm.setProcessInBatch(true);
            String newestAgencyMatchingErrorFileName = agencyEntryGroupService.getNewestAgencyMatchingErrorFileName();
            if (newestAgencyMatchingErrorFileName != null) {
                document.setCorrectionInputFileName(newestAgencyMatchingErrorFileName);
            }
        } else {
            correctionForm.setEditMethod("");
        }
        correctionForm.setPreviousEditMethod(correctionForm.getEditMethod());
        correctionForm.setPreviousInputGroupId(null);
        return mapping.findForward("basic");
    }

    protected boolean checkMainDropdown(TemCorrectionForm errorCorrectionForm) {
        LOG.debug((Object)"checkMainDropdown() started");
        boolean ret = true;
        if (StringUtils.isEmpty((String)errorCorrectionForm.getEditMethod())) {
            GlobalVariables.getMessageMap().putError(SYSTEM_AND_EDIT_METHOD_ERROR_KEY, "error.tem.correction.editmethodfield.required", new String[0]);
            ret = false;
        }
        if (ret && "R".equals(errorCorrectionForm.getEditMethod()) && !"D".equals(errorCorrectionForm.getChooseSystem())) {
            GlobalVariables.getMessageMap().putError(SYSTEM_AND_EDIT_METHOD_ERROR_KEY, "error.tem.correction.remove.group.requires.database", new String[0]);
            ret = false;
        }
        return ret;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"execute() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        if (agencyEntryGroupService == null) {
            agencyEntryGroupService = (AgencyEntryGroupService)SpringContext.getBean(AgencyEntryGroupService.class);
            agencyEntryService = (AgencyEntryService)SpringContext.getBean(AgencyEntryService.class);
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            ConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            expenseImportByTripService = (ExpenseImportByTripService)SpringContext.getBean(ExpenseImportByTripService.class);
        }
        TemCorrectionForm rForm = (TemCorrectionForm)form;
        LOG.debug((Object)("execute() methodToCall: " + rForm.getMethodToCall()));
        Object persistedAgencyEntries = null;
        if (!"docHandler".equals(rForm.getMethodToCall()) && !"reload".equals(rForm.getMethodToCall())) {
            this.restoreSystemAndEditMethod(rForm);
            if (!rForm.isRestrictedFunctionalityMode()) {
                this.loadAllEntries(correctionForm.getInputGroupId(), rForm);
                rForm.setDisplayEntries(new ArrayList<AgencyEntryFull>(rForm.getAllEntries()));
                if (!"sort".equals(rForm.getMethodToCall())) {
                    KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = rForm.getAgencyEntrySearchResultTableMetadata();
                    if (agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
                        List<Column> columns = ((TemCorrectionDocumentService)SpringContext.getBean(TemCorrectionDocumentService.class)).getTableRenderColumnMetadata(rForm.getDocument().getDocumentNumber());
                        String propertyToSortName = columns.get(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
                        Comparator valueComparator = columns.get(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
                        this.sortList(rForm.getDisplayEntries(), propertyToSortName, valueComparator, agencyEntrySearchResultTableMetadata.isSortDescending());
                    }
                    if (rForm.getAllEntries() != null) {
                        int maxRowsPerPage = 25;
                        agencyEntrySearchResultTableMetadata.jumpToPage(agencyEntrySearchResultTableMetadata.getViewedPageNumber(), rForm.getDisplayEntries().size(), maxRowsPerPage);
                        agencyEntrySearchResultTableMetadata.setColumnToSortIndex(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex());
                    }
                }
            }
        }
        ActionForward af = super.execute(mapping, form, request, response);
        return af;
    }

    public ActionForward editManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"editManualEdit() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        int entryId = Integer.parseInt(this.getImageContext(request, "entryId"));
        correctionForm.setEntryForManualEdit(correctionForm.getAllEntries().get(entryId - 1));
        correctionForm.setShowSummaryOutputFlag(true);
        return mapping.findForward("basic");
    }

    public ActionForward addManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"addManualEdit() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        if (this.validAgencyEntry(correctionForm.getEntryForManualEdit())) {
            int newEntryId = correctionForm.getAllEntries().size() + 1;
            correctionForm.getEntryForManualEdit().setEntryId(new Integer(newEntryId));
            correctionForm.getAllEntries().add(correctionForm.getEntryForManualEdit());
            correctionForm.clearEntryForManualEdit();
        }
        this.updateDocumentSummary(document, correctionForm.getAllEntries(), correctionForm.isRestrictedFunctionalityMode());
        correctionForm.setShowSummaryOutputFlag(true);
        correctionForm.setDisplayEntries(new ArrayList<AgencyEntryFull>(correctionForm.getAllEntries()));
        this.applyPagingAndSortingFromPreviousPageView(correctionForm);
        return mapping.findForward("basic");
    }

    public ActionForward deleteManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"deleteManualEdit() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        int entryId = Integer.parseInt(this.getImageContext(request, "entryId"));
        Iterator<AgencyEntryFull> iter = correctionForm.getAllEntries().iterator();
        while (iter.hasNext()) {
            AgencyEntryFull element = iter.next();
            if (element.getEntryId() != entryId) continue;
            iter.remove();
            break;
        }
        this.updateDocumentSummary(document, correctionForm.getAllEntries(), correctionForm.isRestrictedFunctionalityMode());
        correctionForm.setShowSummaryOutputFlag(true);
        correctionForm.setDisplayEntries(new ArrayList<AgencyEntryFull>(correctionForm.getAllEntries()));
        this.applyPagingAndSortingFromPreviousPageView(correctionForm);
        return mapping.findForward("basic");
    }

    public ActionForward saveManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"saveManualEdit() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        if (this.validAgencyEntry(correctionForm.getEntryForManualEdit())) {
            int entryId = correctionForm.getEntryForManualEdit().getEntryId();
            Iterator<AgencyEntryFull> iter = correctionForm.getAllEntries().iterator();
            while (iter.hasNext()) {
                AgencyEntryFull element = iter.next();
                if (element.getEntryId() != entryId) continue;
                iter.remove();
            }
            correctionForm.getAllEntries().add(correctionForm.getEntryForManualEdit());
            correctionForm.setDisplayEntries(new ArrayList<AgencyEntryFull>(correctionForm.getAllEntries()));
            correctionForm.clearEntryForManualEdit();
        }
        this.updateDocumentSummary(document, correctionForm.getAllEntries(), correctionForm.isRestrictedFunctionalityMode());
        this.applyPagingAndSortingFromPreviousPageView(correctionForm);
        return mapping.findForward("basic");
    }

    private boolean validAgencyEntry(AgencyEntryFull entryForManualEdit) {
        List<ErrorMessage> errors = expenseImportByTripService.validateMandatoryFieldsPresent(entryForManualEdit);
        for (ErrorMessage error : errors) {
            GlobalVariables.getMessageMap().putError("searchResults", error.toString(), new String[0]);
        }
        return errors.isEmpty();
    }

    public ActionForward loadGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"loadGroup() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        String batchDirectory = ((TemCorrectionDocumentService)SpringContext.getBean(TemCorrectionDocumentService.class)).getBatchFileDirectoryName();
        if (this.checkAgencyEntryGroupSelection(correctionForm)) {
            TemCorrectionProcessDocument doc = (TemCorrectionProcessDocument)correctionForm.getDocument();
            doc.setCorrectionInputFileName(correctionForm.getInputGroupId());
            int inputGroupSize = agencyEntryService.getGroupCount(correctionForm.getInputGroupId());
            int recordCountFunctionalityLimit = 1000;
            correctionForm.setPersistedOriginEntriesMissing(false);
            correctionForm.setRestrictedFunctionalityMode(false);
            this.loadAllEntries(correctionForm.getInputGroupId(), correctionForm);
            if (correctionForm.getAllEntries().size() > 0) {
                if ("M".equals(correctionForm.getEditMethod())) {
                    correctionForm.setManualEditFlag(true);
                    correctionForm.setEditableFlag(false);
                    correctionForm.setDeleteFileFlag(false);
                }
                correctionForm.setDataLoadedFlag(true);
            } else {
                GlobalVariables.getMessageMap().putError("documentsInSystem", "error.tem.correction.norecords", new String[0]);
            }
            TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
            if (document.getCorrectionChangeGroup().isEmpty()) {
                document.addCorrectionChangeGroup(new AgencyCorrectionChangeGroup());
            }
            correctionForm.setPreviousInputGroupId(correctionForm.getInputGroupId());
        }
        correctionForm.setShowOutputFlag(false);
        return mapping.findForward("basic");
    }

    protected boolean checkAgencyEntryGroupSelection(TemCorrectionForm correctionForm) {
        LOG.debug((Object)"checkOriginEntryGroupSelection() started");
        if (correctionForm.getInputGroupId() == null) {
            GlobalVariables.getMessageMap().putError("documentLoadError", "error.tem.correction.AGENCYgroup.required.for.route", new String[0]);
            return false;
        }
        return true;
    }

    protected void updateDocumentSummary(TemCorrectionProcessDocument document, List<AgencyEntryFull> entries, boolean clearOutSummary) {
        if (clearOutSummary) {
            document.setCorrectionTripTotalAmount(null);
            document.setCorrectionRowCount(null);
        } else {
            document.setCorrectionRowCount(entries.size());
            KualiDecimal tripTotal = KualiDecimal.ZERO;
            for (AgencyEntryFull agency : entries) {
                if (null == agency.getTripExpenseAmount()) continue;
                tripTotal = (KualiDecimal)tripTotal.add((AbstractKualiDecimal)agency.getTripExpenseAmount());
            }
            document.setCorrectionTripTotalAmount(tripTotal);
        }
    }

    protected void loadAllEntries(String fileNameWithPath, TemCorrectionForm correctionForm) {
        block6: {
            LOG.debug((Object)"loadAllEntries() started");
            TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
            if (correctionForm.isRestrictedFunctionalityMode()) break block6;
            ArrayList<AgencyEntryFull> searchResults = new ArrayList<AgencyEntryFull>();
            Map loadErrorMap = agencyEntryService.getEntriesByGroupIdWithPath(fileNameWithPath, searchResults);
            correctionForm.setAllEntries(searchResults);
            int maxRowsPerPage = 25;
            KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
            agencyEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getAllEntries().size(), maxRowsPerPage);
            if (loadErrorMap != null && loadErrorMap.size() > 0) {
                for (Integer lineNumber : loadErrorMap.keySet()) {
                    List messageList = (List)loadErrorMap.get(lineNumber);
                    for (Message errorMmessage : messageList) {
                        GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.InvalidFormatOriginEntryFromTextFile", new String[]{lineNumber.toString(), errorMmessage.toString()});
                    }
                }
            } else {
                try {
                    this.loadAllEntries(searchResults, correctionForm);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void loadAllEntries(List<AgencyEntryFull> searchResults, TemCorrectionForm correctionForm) throws Exception {
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        correctionForm.setAllEntries(searchResults);
        correctionForm.setDisplayEntries(new ArrayList<AgencyEntryFull>(searchResults));
        this.updateDocumentSummary(document, correctionForm.getAllEntries(), correctionForm.isRestrictedFunctionalityMode());
        int maxRowsPerPage = 25;
        KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
        agencyEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
        agencyEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
    }

    public ActionForward manualEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LOG.debug((Object)"manualEdit() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        correctionForm.clearEntryForManualEdit();
        correctionForm.setEditableFlag(true);
        correctionForm.setManualEditFlag(false);
        int maxRowsPerPage = 25;
        KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
        agencyEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getAllEntries().size(), maxRowsPerPage);
        agencyEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
        return mapping.findForward("basic");
    }

    protected void applyPagingAndSortingFromPreviousPageView(TemCorrectionForm correctionForm) {
        KualiTableRenderFormMetadata agencyEntrySearchResultTableMetadata = correctionForm.getAgencyEntrySearchResultTableMetadata();
        if (agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
            List<Column> columns = ((TemCorrectionDocumentService)SpringContext.getBean(TemCorrectionDocumentService.class)).getTableRenderColumnMetadata(correctionForm.getDocument().getDocumentNumber());
            String propertyToSortName = columns.get(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
            Comparator valueComparator = columns.get(agencyEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
            this.sortList(correctionForm.getDisplayEntries(), propertyToSortName, valueComparator, agencyEntrySearchResultTableMetadata.isSortDescending());
        }
        int maxRowsPerPage = 25;
        agencyEntrySearchResultTableMetadata.jumpToPage(agencyEntrySearchResultTableMetadata.getViewedPageNumber(), correctionForm.getDisplayEntries().size(), maxRowsPerPage);
    }

    protected void sortList(List<AgencyEntryFull> list, String propertyToSortName, Comparator valueComparator, boolean sortDescending) {
        if (list != null) {
            if (valueComparator instanceof NumericValueComparator || valueComparator instanceof TemporalValueComparator) {
                valueComparator = new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        if (obj1 == null) {
                            return -1;
                        }
                        if (obj2 == null) {
                            return 1;
                        }
                        return ((Comparable)obj1).compareTo(obj2);
                    }
                };
            }
            if (sortDescending) {
                valueComparator = new ReverseComparator(valueComparator);
            }
            Collections.sort(list, new BeanComparator(propertyToSortName, valueComparator));
        }
    }

    protected boolean restoreSystemAndEditMethod(TemCorrectionForm correctionForm) {
        boolean readOnly;
        boolean bl = readOnly = correctionForm.getEditingMode().get("fullEntry") != null;
        if (!("selectSystemEditMethod".equals(correctionForm.getMethodToCall()) || readOnly || StringUtils.equals((String)correctionForm.getPreviousEditMethod(), (String)correctionForm.getEditMethod()) && StringUtils.equals((String)correctionForm.getPreviousChooseSystem(), (String)correctionForm.getChooseSystem()))) {
            correctionForm.setChooseSystem(correctionForm.getPreviousChooseSystem());
            correctionForm.setEditMethod(correctionForm.getPreviousEditMethod());
            return true;
        }
        return false;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"blanketApprove() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        if (this.prepareForRoute(correctionForm)) {
            if (correctionForm.isDataLoadedFlag() && !correctionForm.isRestrictedFunctionalityMode()) {
                int maxRowsPerPage = 25;
                correctionForm.getDisplayEntries().clear();
                correctionForm.getDisplayEntries().addAll(correctionForm.getAllEntries());
                correctionForm.getAgencyEntrySearchResultTableMetadata().jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
            }
            return super.blanketApprove(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"blanketApprove() started");
        TemCorrectionForm correctionForm = (TemCorrectionForm)form;
        if (this.prepareForRoute(correctionForm)) {
            if (correctionForm.isDataLoadedFlag() && !correctionForm.isRestrictedFunctionalityMode()) {
                int maxRowsPerPage = 25;
                correctionForm.getDisplayEntries().clear();
                correctionForm.getDisplayEntries().addAll(correctionForm.getAllEntries());
                correctionForm.getAgencyEntrySearchResultTableMetadata().jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
            }
            return super.blanketApprove(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected boolean prepareForRoute(TemCorrectionForm correctionForm) {
        TemCorrectionProcessDocument document = correctionForm.getCorrectionDocument();
        if (StringUtils.isEmpty((String)document.getDocumentHeader().getDocumentDescription())) {
            GlobalVariables.getMessageMap().putError("document.documentHeader.documentDescription", "error.document.noDescription", new String[0]);
            return false;
        }
        if (!this.checkMainDropdown(correctionForm)) {
            return false;
        }
        document.setCorrectionInputFileName(correctionForm.getInputGroupId());
        if (!this.checkAgencyEntryGroupSelectionBeforeRouting(document)) {
            return false;
        }
        if (!this.validGroupsItemsForDocumentSave(correctionForm)) {
            return false;
        }
        document.setCorrectionTypeCode(correctionForm.getEditMethod());
        document.setCorrectionInputFileName(correctionForm.getInputGroupId());
        document.setCorrectionOutputFileName(null);
        ((TemCorrectionDocumentService)SpringContext.getBean(TemCorrectionDocumentService.class)).persistAgencyEntryGroupsForDocumentSave(document, correctionForm);
        return true;
    }

    protected boolean validChangeGroups(TemCorrectionForm correctionForm) {
        return false;
    }

    protected boolean validGroupsItemsForDocumentSave(TemCorrectionForm correctionForm) {
        return false;
    }

    protected boolean checkAgencyEntryGroupSelectionBeforeRouting(TemCorrectionProcessDocument document) {
        if (document.getCorrectionInputFileName() == null) {
            GlobalVariables.getMessageMap().putError(SYSTEM_AND_EDIT_METHOD_ERROR_KEY, "error.tem.correction.AGENCYgroup.required.for.route", new String[0]);
            return false;
        }
        return true;
    }
}

