/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.pdf.PdfStream;
import org.kuali.kfs.module.tem.report.util.BarcodeHelper;
import org.kuali.kfs.sys.context.SpringContext;

public class Coversheet
implements PdfStream {
    private static final int ALIGNMENT_MARK_HEIGHT = 8;
    private static final int ALIGNMENT_MARK_WIDTH = 10;
    private static final int ALIGNMENT_MARGIN = 5;
    private static final int TOP_MARGIN = 50;
    private String initiatorName;
    private String initiatorPrincipalName;
    private String initiatorPhone;
    private String initiatorEmail;
    private String travelerName;
    private String travelerPrincipalName;
    private String travelerPhone;
    private String travelerEmail;
    private String instructions;
    private String mailTo;
    private String date;
    private String tripId;
    private String destination;
    private String documentNumber;
    private Collection<Map<String, String>> expenses;

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public String getInitiatorName() {
        if (this.initiatorName == null) {
            return "";
        }
        return this.initiatorName;
    }

    public void setInitiatorPrincipalName(String initiatorPrincipalName) {
        this.initiatorPrincipalName = initiatorPrincipalName;
    }

    public String getInitiatorPrincipalName() {
        if (this.initiatorPrincipalName == null) {
            return "";
        }
        return this.initiatorPrincipalName;
    }

    public void setInitiatorPhone(String initiatorPhone) {
        this.initiatorPhone = initiatorPhone;
    }

    public String getInitiatorPhone() {
        if (this.initiatorPhone == null) {
            return "";
        }
        return this.initiatorPhone;
    }

    public void setInitiatorEmail(String initiatorEmail) {
        this.initiatorEmail = initiatorEmail;
    }

    public String getInitiatorEmail() {
        if (this.initiatorEmail == null) {
            return "";
        }
        return this.initiatorEmail;
    }

    public void setTravelerName(String travelerName) {
        this.travelerName = travelerName;
    }

    public String getTravelerName() {
        if (this.travelerName == null) {
            return "";
        }
        return this.travelerName;
    }

    public void setTravelerPrincipalName(String travelerPrincipalName) {
        this.travelerPrincipalName = travelerPrincipalName;
    }

    public String getTravelerPrincipalName() {
        if (this.travelerPrincipalName == null) {
            return "";
        }
        return this.travelerPrincipalName;
    }

    public void setTravelerPhone(String travelerPhone) {
        this.travelerPhone = travelerPhone;
    }

    public String getTravelerPhone() {
        if (this.travelerPhone == null) {
            return "";
        }
        return this.travelerPhone;
    }

    public void setTravelerEmail(String travelerEmail) {
        this.travelerEmail = travelerEmail;
    }

    public String getTravelerEmail() {
        if (this.travelerEmail == null) {
            return "";
        }
        return this.travelerEmail;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getInstructions() {
        if (this.instructions == null) {
            return "";
        }
        return this.instructions;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate() {
        if (this.date == null) {
            return "";
        }
        return this.date;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String getMailTo() {
        if (this.mailTo == null) {
            return "";
        }
        return this.mailTo;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        if (this.destination == null) {
            return "";
        }
        return this.destination;
    }

    public void setTripId(String tripId) {
        this.tripId = tripId;
    }

    public String getTripId() {
        if (this.tripId == null) {
            return "";
        }
        return this.tripId;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    protected Paragraph getInstructionsParagraph() {
        Font headerFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
        Paragraph retval = new Paragraph();
        retval.add((Object)new Chunk("Instructions", headerFont));
        retval.add((Object)Chunk.NEWLINE);
        retval.add((Object)new Phrase(this.getInstructions(), normalFont));
        return retval;
    }

    protected Paragraph getMailtoParagraph() {
        Font headerFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
        Paragraph retval = new Paragraph();
        retval.add((Object)new Chunk("Mail coversheet to:", headerFont));
        retval.add((Object)Chunk.NEWLINE);
        retval.add((Object)new Phrase(this.getMailTo(), normalFont));
        return retval;
    }

    protected Cell getInitiatorInfo() throws BadElementException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.getInitiatorName()).append("\n").append(this.getInitiatorPrincipalName()).append("\n").append(this.getInitiatorPhone()).append("\n").append(this.getInitiatorEmail()).append("\n");
        Cell retval = this.getBorderlessCell(strBuilder.toString());
        return retval;
    }

    protected Cell getTravelerInfo() throws BadElementException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.getTravelerName()).append("\n").append(this.getTravelerPrincipalName()).append("\n").append(this.getTravelerPhone()).append("\n").append(this.getTravelerEmail()).append("\n");
        Cell retval = this.getBorderlessCell(strBuilder.toString());
        return retval;
    }

    protected Table getTripInfo() throws BadElementException {
        Table retval = new Table(3);
        retval.setWidth(100.0f);
        retval.setBorder(0);
        retval.addCell(this.getHeaderCell("Trip/Event ID"));
        Cell dateHeaderCell = this.getHeaderCell("Date");
        retval.addCell(dateHeaderCell);
        retval.addCell(this.getHeaderCell("Destination/Event Name"));
        retval.endHeaders();
        retval.addCell(this.getBorderlessCell(this.getTripId()));
        Cell dateCell = this.getBorderlessCell(this.getDate());
        retval.addCell(dateCell);
        retval.addCell(this.getBorderlessCell(this.getDestination()));
        return retval;
    }

    protected Table getPersonalInfo() throws BadElementException {
        Table retval = new Table(2);
        retval.setWidth(100.0f);
        retval.setBorder(0);
        retval.addCell(this.getHeaderCell("Traveler"));
        Cell initiatorHeaderCell = this.getHeaderCell("Request Submitted By");
        retval.addCell(initiatorHeaderCell);
        retval.endHeaders();
        retval.addCell(this.getTravelerInfo());
        Cell initiatorCell = this.getInitiatorInfo();
        retval.addCell(initiatorCell);
        return retval;
    }

    public void setExpenses(Collection<Map<String, String>> expenses) {
        this.expenses = expenses;
    }

    public Table getExpenses() throws BadElementException {
        Table retval = new Table(3);
        retval.setWidth(100.0f);
        retval.setBorder(0);
        retval.addCell(this.getHeaderCell("Expenses"));
        retval.addCell(this.getHeaderCell("Amount"));
        retval.addCell(this.getHeaderCell("Receipt Required?"));
        retval.endHeaders();
        for (Map<String, String> expense : this.expenses) {
            retval.addCell(this.getBorderlessCell(expense.get("expenseType")));
            retval.addCell(this.getBorderlessCell(expense.get("amount")));
            retval.addCell(this.getBorderlessCell(expense.get("receipt")));
        }
        return retval;
    }

    protected Cell getBorderlessCell(String text) throws BadElementException {
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
        Cell retval = new Cell((Element)new Chunk(text, normalFont));
        retval.setBorder(0);
        return retval;
    }

    protected Cell getHeaderCell(String text) throws BadElementException {
        Font headerFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
        Cell retval = new Cell((Element)new Chunk(text, headerFont));
        retval.setBorder(0);
        retval.setHeader(true);
        return retval;
    }

    protected void upperLeftAlignmentMark(PdfContentByte cb) {
        cb.saveState();
        cb.rectangle(5.0f, PageSize.LETTER.height() + 50.0f - 8.0f - 5.0f, 10.0f, 8.0f);
        cb.setColorFill(Color.BLACK);
        cb.fill();
        cb.restoreState();
    }

    protected void lowerLeftAlignmentMark(PdfContentByte cb) {
        cb.saveState();
        cb.rectangle(5.0f, 5.0f, 10.0f, 8.0f);
        cb.setColorFill(Color.BLACK);
        cb.fill();
        cb.restoreState();
    }

    protected void lowerRightAlignmentMark(PdfContentByte cb) {
        cb.saveState();
        cb.rectangle(PageSize.LETTER.width() - 20.0f - 10.0f, 5.0f, 10.0f, 8.0f);
        cb.setColorFill(Color.BLACK);
        cb.fill();
        cb.restoreState();
    }

    protected void upperRightAlignmentMark(PdfContentByte cb) {
        cb.saveState();
        cb.rectangle(PageSize.LETTER.width() - 20.0f - 10.0f, PageSize.LETTER.height() + 50.0f - 5.0f - 8.0f, 10.0f, 8.0f);
        cb.setColorFill(Color.BLACK);
        cb.fill();
        cb.restoreState();
    }

    protected void drawAlignmentMarks(PdfContentByte cb) {
        this.upperLeftAlignmentMark(cb);
        this.lowerLeftAlignmentMark(cb);
        this.upperRightAlignmentMark(cb);
        this.lowerRightAlignmentMark(cb);
    }

    @Override
    public void print(OutputStream stream) throws Exception {
        Font titleFont = FontFactory.getFont((String)"Helvetica", (float)20.0f, (int)1);
        Font headerFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
        Document doc = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)stream);
        doc.open();
        if (this.getDocumentNumber() != null) {
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)new BarcodeHelper().generateBarcodeImage(this.getDocumentNumber()), null);
            doc.add((Element)image);
        }
        Paragraph title = new Paragraph("TEM Coversheet", titleFont);
        doc.add((Element)title);
        Paragraph faxNumber = new Paragraph("Fax this page to " + ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(TravelReimbursementDocument.class, "FAX_NUMBER"), normalFont);
        doc.add((Element)faxNumber);
        Paragraph header = new Paragraph("", headerFont);
        header.setAlignment(2);
        header.add((Object)("Document Number: " + this.getDocumentNumber()));
        doc.add((Element)header);
        doc.add((Element)this.getInstructionsParagraph());
        doc.add((Element)this.getMailtoParagraph());
        doc.add((Element)Chunk.NEWLINE);
        doc.add((Element)this.getTripInfo());
        doc.add((Element)Chunk.NEWLINE);
        doc.add((Element)this.getPersonalInfo());
        doc.add((Element)Chunk.NEWLINE);
        doc.add((Element)this.getExpenses());
        this.drawAlignmentMarks(writer.getDirectContent());
        doc.close();
        writer.close();
    }
}

