/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.BalanceTypeService;
import org.kuali.kfs.gl.batch.service.EncumbranceCalculator;
import org.kuali.kfs.gl.businessobject.Encumbrance;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.gl.service.EncumbranceService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.HeldEncumbranceEntry;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationCloseDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TravelEncumbranceService;
import org.kuali.kfs.pdp.PdpConstants;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.service.PaymentMaintenanceService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

public class TravelEncumbranceServiceImpl
implements TravelEncumbranceService {
    protected static Logger LOG = Logger.getLogger(TravelEncumbranceServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected TravelDocumentService travelDocumentService;
    protected DocumentService documentService;
    protected EncumbranceService encumbranceService;
    protected EncumbranceCalculator encumbranceCalculator;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected volatile AccountsReceivableModuleService accountsReceivableModuleService;
    protected PaymentMaintenanceService paymentMaintenanceService;
    protected PersonService personService;
    protected ConfigurationService configurationService;
    protected BalanceTypeService balanceTypeService;
    protected DateTimeService dateTimeService;
    protected UniversityDateService universityDateService;
    protected AccountingPeriodService accountingPeriodService;
    protected OptionsService optionsService;

    @Override
    public void liquidateEncumbranceForCancelTA(TravelAuthorizationDocument travelAuthDocument) {
        if (travelAuthDocument.getTripType().isGenerateEncumbrance()) {
            this.deleteHeldEncumbranceEntriesForTrip(travelAuthDocument.getTravelDocumentIdentifier());
            travelAuthDocument.refreshReferenceObject("generalLedgerPendingEntries");
            GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper(travelAuthDocument.getGeneralLedgerPendingEntries().size() + 1);
            this.deletePendingEntriesForTripCancellation(travelAuthDocument.getTravelDocumentIdentifier());
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("documentNumber", travelAuthDocument.getTravelDocumentIdentifier());
            Iterator encumbranceIterator = this.encumbranceService.findOpenEncumbrance(criteria, false);
            while (encumbranceIterator.hasNext()) {
                this.liquidateEncumbrance((Encumbrance)encumbranceIterator.next(), sequenceHelper, travelAuthDocument, true);
            }
        }
    }

    @Override
    public void updateEncumbranceObjectCode(TravelAuthorizationDocument travelAuthDocument, SourceAccountingLine line) {
        TripType tripType = travelAuthDocument.getTripType();
        line.setFinancialObjectCode(ObjectUtils.isNotNull((Object)((Object)tripType)) ? tripType.getEncumbranceObjCode() : "");
    }

    @Override
    public String getEncumbranceBalanceTypeByTripType(TravelDocument document) {
        document.refreshReferenceObject("tripType");
        TripType tripType = document.getTripType();
        return ObjectUtils.isNotNull((Object)((Object)tripType)) ? StringUtils.defaultString((String)tripType.getEncumbranceBalanceType()) : "";
    }

    @Override
    public void liquidateEncumbrance(Encumbrance encumbrance, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, TravelDocument document, boolean approveImmediately) {
        if (encumbrance.getAccountLineEncumbranceOutstandingAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            GeneralLedgerPendingEntry pendingEntry = this.setupPendingEntry(encumbrance, sequenceHelper, document);
            if (approveImmediately) {
                pendingEntry.setFinancialDocumentApprovedCode("A");
            }
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetEntry = this.setupOffsetEntry(encumbrance, sequenceHelper, document, pendingEntry);
            if (approveImmediately) {
                offsetEntry.setFinancialDocumentApprovedCode("A");
            }
            sequenceHelper.increment();
            KualiDecimal amount = encumbrance.getAccountLineEncumbranceOutstandingAmount();
            pendingEntry.setTransactionLedgerEntryAmount(amount);
            offsetEntry.setTransactionLedgerEntryAmount(amount);
            document.addPendingEntry(pendingEntry);
            document.addPendingEntry(offsetEntry);
        }
    }

    @Override
    public GeneralLedgerPendingEntry setupPendingEntry(Encumbrance encumbrance, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, TravelDocument document) {
        GeneralLedgerPendingEntrySourceDetail sourceDetail = this.convertTo(document, encumbrance);
        GeneralLedgerPendingEntry pendingEntry = new GeneralLedgerPendingEntry();
        this.generalLedgerPendingEntryService.populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)document, sourceDetail, sequenceHelper, pendingEntry);
        this.updateEncumbranceEntry(encumbrance, document, pendingEntry);
        return pendingEntry;
    }

    @Override
    public GeneralLedgerPendingEntry setupOffsetEntry(Encumbrance encumbrance, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, TravelDocument document, GeneralLedgerPendingEntry pendingEntry) {
        GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(pendingEntry);
        this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(pendingEntry.getUniversityFiscalYear(), pendingEntry, sequenceHelper, offsetEntry);
        this.updateEncumbranceEntry(encumbrance, document, offsetEntry);
        return offsetEntry;
    }

    private void updateEncumbranceEntry(Encumbrance encumbrance, TravelDocument document, GeneralLedgerPendingEntry entry) {
        String balanceType = this.getEncumbranceBalanceTypeByTripType(document);
        entry.setTransactionEncumbranceUpdateCode("R");
        entry.setFinancialBalanceTypeCode(balanceType);
        entry.setFinancialDocumentApprovedCode("N");
        entry.setReferenceFinancialDocumentTypeCode(encumbrance.getDocumentTypeCode());
        entry.setReferenceFinancialSystemOriginationCode(encumbrance.getOriginCode());
    }

    @Override
    public void disencumberTravelAuthorizationClose(TravelAuthorizationCloseDocument document, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, List<GeneralLedgerPendingEntry> reimbursementPendingEntries) {
        this.clearAuthorizationEncumbranceGLPE(document);
        this.deleteHeldEncumbranceEntriesForTrip(document.getTravelDocumentIdentifier());
        List<Encumbrance> encumbrances = this.getEncumbrancesForTrip(document.getTravelDocumentIdentifier(), null);
        this.applyReimbursementEntriesToEncumbrances(encumbrances, reimbursementPendingEntries);
        int counter = document.getGeneralLedgerPendingEntries().size() + 1;
        for (Encumbrance encumbrance : encumbrances) {
            this.liquidateEncumbrance(encumbrance, sequenceHelper, document, false);
        }
    }

    @Override
    @Transactional
    public List<Encumbrance> getEncumbrancesForTrip(String travelDocumentIdentifier, String skipDocumentNumber) {
        if (StringUtils.isBlank((String)travelDocumentIdentifier)) {
            return new ArrayList<Encumbrance>();
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("documentNumber", travelDocumentIdentifier);
        Iterator encumbranceIterator = this.encumbranceService.findOpenEncumbrance(criteria, false);
        ArrayList<Encumbrance> allEncumbrances = new ArrayList<Encumbrance>();
        while (encumbranceIterator.hasNext()) {
            allEncumbrances.add((Encumbrance)encumbranceIterator.next());
        }
        Iterator<GeneralLedgerPendingEntry> pendingEntriesIterator = this.getPendingEntriesForTrip(travelDocumentIdentifier);
        while (pendingEntriesIterator.hasNext()) {
            GeneralLedgerPendingEntry pendingEntry = pendingEntriesIterator.next();
            if (StringUtils.equals((String)skipDocumentNumber, (String)pendingEntry.getDocumentNumber())) continue;
            this.applyEntryToEncumbrances(allEncumbrances, pendingEntry);
        }
        List<GeneralLedgerPendingEntry> heldEncumbranceEntries = this.findHeldEncumbranceEntriesForTrip(travelDocumentIdentifier);
        for (GeneralLedgerPendingEntry heldEntry : heldEncumbranceEntries) {
            if (StringUtils.equals((String)skipDocumentNumber, (String)heldEntry.getDocumentNumber())) continue;
            this.applyEntryToEncumbrances(allEncumbrances, heldEntry);
        }
        return allEncumbrances;
    }

    protected Iterator<GeneralLedgerPendingEntry> getPendingEntriesForTrip(String travelDocumentIdentifier) {
        HashMap<String, String> glpeCriteria = new HashMap<String, String>();
        glpeCriteria.put("documentNumber", travelDocumentIdentifier);
        Iterator pendingEntriesIterator = this.generalLedgerPendingEntryService.findPendingLedgerEntriesForEncumbrance(glpeCriteria, true);
        return pendingEntriesIterator;
    }

    protected List<GeneralLedgerPendingEntry> findHeldEncumbranceEntriesForTrip(String tripId) {
        HashMap<String, String> heeCriteria = new HashMap<String, String>();
        heeCriteria.put("travelDocumentIdentifier", tripId);
        ArrayList<GeneralLedgerPendingEntry> entries = new ArrayList<GeneralLedgerPendingEntry>();
        Collection retrievedEntries = this.businessObjectService.findMatching(HeldEncumbranceEntry.class, heeCriteria);
        for (HeldEncumbranceEntry heeEntry : retrievedEntries) {
            GeneralLedgerPendingEntry glpe = this.convertHeldEncumbranceEntryToPendingEntry(heeEntry);
            entries.add(glpe);
        }
        return entries;
    }

    protected void applyEntryToEncumbrances(List<Encumbrance> allEncumbrances, GeneralLedgerPendingEntry pendingEntry) {
        Encumbrance encumbrance = this.getEncumbranceCalculator().findEncumbrance(allEncumbrances, (Transaction)pendingEntry);
        if (encumbrance != null) {
            this.getEncumbranceCalculator().updateEncumbrance((Transaction)pendingEntry, encumbrance);
        }
    }

    protected void applyReimbursementEntriesToEncumbrances(List<Encumbrance> encumbrances, List<GeneralLedgerPendingEntry> reimbursementPendingEntries) {
        Set<String> processedPendingEntryKeys = this.buildPendingEntryKeys(this.retrieveAllPendingEntriesForTravelDocumentIds(this.getUniqueTravelDocumentIds(reimbursementPendingEntries)));
        if (reimbursementPendingEntries != null && !reimbursementPendingEntries.isEmpty()) {
            for (GeneralLedgerPendingEntry pendingEntry : reimbursementPendingEntries) {
                String pendingEntryKey;
                if (pendingEntry.isTransactionEntryOffsetIndicator() || processedPendingEntryKeys.contains(pendingEntryKey = this.buildPendingEntryKey(pendingEntry))) continue;
                this.applyEntryToEncumbrances(encumbrances, pendingEntry);
            }
        }
    }

    protected Set<String> getUniqueTravelDocumentIds(List<GeneralLedgerPendingEntry> pendingEntries) {
        HashSet<String> travelDocIds = new HashSet<String>();
        if (!CollectionUtils.isEmpty(pendingEntries)) {
            for (GeneralLedgerPendingEntry pendingEntry : pendingEntries) {
                if (StringUtils.isBlank((String)pendingEntry.getReferenceFinancialDocumentNumber())) continue;
                travelDocIds.add(pendingEntry.getReferenceFinancialDocumentNumber());
            }
        }
        return travelDocIds;
    }

    protected Iterator<GeneralLedgerPendingEntry> retrieveAllPendingEntriesForTravelDocumentIds(Set<String> travelDocumentIds) {
        ArrayList<GeneralLedgerPendingEntry> allPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        for (String travelDocumentId : travelDocumentIds) {
            Iterator<GeneralLedgerPendingEntry> currentPendingEntries = this.getPendingEntriesForTrip(travelDocumentId);
            while (currentPendingEntries.hasNext()) {
                allPendingEntries.add(currentPendingEntries.next());
            }
        }
        return allPendingEntries.iterator();
    }

    protected Set<String> buildPendingEntryKeys(Iterator<GeneralLedgerPendingEntry> pendingEntries) {
        HashSet<String> pendingEntryKeys = new HashSet<String>();
        while (pendingEntries.hasNext()) {
            GeneralLedgerPendingEntry pendingEntry = pendingEntries.next();
            pendingEntryKeys.add(this.buildPendingEntryKey(pendingEntry));
        }
        return pendingEntryKeys;
    }

    protected String buildPendingEntryKey(GeneralLedgerPendingEntry pendingEntry) {
        StringBuilder key = new StringBuilder();
        key.append(pendingEntry.getFinancialSystemOriginationCode());
        key.append('-');
        key.append(pendingEntry.getDocumentNumber());
        key.append('-');
        key.append(pendingEntry.getTransactionLedgerEntrySequenceNumber());
        return key.toString();
    }

    @Override
    public void adjustEncumbranceForAmendment(TravelAuthorizationAmendmentDocument document, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        if (document.getTripType().isGenerateEncumbrance()) {
            String key;
            HashMap<String, Encumbrance> encumbranceMap = new HashMap<String, Encumbrance>();
            List<Encumbrance> encumbrances = this.getEncumbrancesForTrip(document.getTravelDocumentIdentifier(), document.getDocumentNumber());
            for (Encumbrance encumbrance : encumbrances) {
                key = this.buildEncumbranceKey(encumbrance);
                encumbranceMap.put(key, encumbrance);
            }
            Iterator pendingEntriesIterator = document.getGeneralLedgerPendingEntries().iterator();
            while (pendingEntriesIterator.hasNext()) {
                GeneralLedgerPendingEntry offset;
                Encumbrance encumbrance;
                GeneralLedgerPendingEntry pendingEntry = (GeneralLedgerPendingEntry)pendingEntriesIterator.next();
                if (StringUtils.defaultString((String)pendingEntry.getOrganizationReferenceId()).contains("-IMP") || (encumbrance = (Encumbrance)encumbranceMap.get(key = this.buildEncumbranceKey(pendingEntry))) == null) continue;
                KualiDecimal difference = (KualiDecimal)encumbrance.getAccountLineEncumbranceOutstandingAmount().subtract((AbstractKualiDecimal)pendingEntry.getTransactionLedgerEntryAmount());
                if (difference.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    if (!pendingEntry.isTransactionEntryOffsetIndicator()) {
                        pendingEntry.setTransactionDebitCreditCode("C");
                    } else {
                        pendingEntry.setTransactionDebitCreditCode("D");
                    }
                    pendingEntry.setTransactionLedgerEntryAmount(difference);
                    offset = (GeneralLedgerPendingEntry)pendingEntriesIterator.next();
                    offset.setTransactionLedgerEntryAmount(difference);
                    continue;
                }
                if (!difference.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
                difference = (KualiDecimal)difference.negated();
                pendingEntry.setTransactionLedgerEntryAmount(difference);
                offset = (GeneralLedgerPendingEntry)pendingEntriesIterator.next();
                offset.setTransactionLedgerEntryAmount(difference);
            }
            ArrayList<GeneralLedgerPendingEntry> continuingPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
            for (GeneralLedgerPendingEntry pendingEntry : document.getGeneralLedgerPendingEntries()) {
                if (!StringUtils.defaultString((String)pendingEntry.getOrganizationReferenceId()).contains("-IMP") && !pendingEntry.isTransactionEntryOffsetIndicator()) {
                    String key2 = this.buildEncumbranceKey(pendingEntry);
                    encumbranceMap.remove(key2);
                }
                if (pendingEntry.getTransactionLedgerEntryAmount().equals((Object)KualiDecimal.ZERO)) continue;
                continuingPendingEntries.add(pendingEntry);
            }
            document.setGeneralLedgerPendingEntries(continuingPendingEntries);
            if (!encumbranceMap.isEmpty()) {
                for (Encumbrance encumbrance : encumbranceMap.values()) {
                    this.liquidateEncumbrance(encumbrance, sequenceHelper, document, false);
                }
            }
        }
    }

    protected String buildEncumbranceKey(Encumbrance e) {
        StringBuilder key = new StringBuilder();
        key.append(e.getAccountNumber());
        key.append(e.getSubAccountNumber());
        key.append(e.getObjectCode());
        key.append(e.getSubObjectCode());
        key.append(e.getDocumentNumber());
        return key.toString();
    }

    protected String buildEncumbranceKey(GeneralLedgerPendingEntry pendingEntry) {
        StringBuilder key = new StringBuilder();
        key.append(pendingEntry.getAccountNumber());
        key.append(pendingEntry.getSubAccountNumber());
        key.append(pendingEntry.getFinancialObjectCode());
        key.append(pendingEntry.getFinancialSubObjectCode());
        key.append(pendingEntry.getReferenceFinancialDocumentNumber());
        return key.toString();
    }

    @Override
    public void processRelatedDocuments(TravelAuthorizationDocument travelAuthDocument) {
        List<Document> relatedDocs = this.travelDocumentService.getDocumentsRelatedTo(travelAuthDocument, "TA", "TAA");
        for (Document tempDocument : relatedDocs) {
            if (travelAuthDocument.getDocumentNumber().equals(tempDocument.getDocumentNumber())) continue;
            for (GeneralLedgerPendingEntry glpe : travelAuthDocument.getGeneralLedgerPendingEntries()) {
                if (glpe == null || glpe.getOrganizationReferenceId() == null || glpe.getOrganizationReferenceId().contains("-IMP")) continue;
                this.businessObjectService.delete((PersistableBusinessObject)glpe);
            }
        }
    }

    public void clearAuthorizationEncumbranceGLPE(TravelAuthorizationCloseDocument travelAuthCloseDocument) {
        List<String> encumbranceBalanceTypes = this.harvestCodesFromEncumbranceBalanceTypes();
        List<Document> relatedDocs = this.travelDocumentService.getDocumentsRelatedTo(travelAuthCloseDocument, "TA", "TAA");
        for (Document document : relatedDocs) {
            TravelAuthorizationDocument authorizationDocument = (TravelAuthorizationDocument)document;
            String docType = document instanceof TravelAuthorizationDocument ? "TA" : "TAA";
            boolean hasRemovedGLPE = false;
            String note = String.format("TA Close Document # %s has cleared encumbrance GLPEs in %s # %s", travelAuthCloseDocument.getDocumentNumber(), docType, document.getDocumentNumber());
            if (!this.travelDocumentService.isTravelAuthorizationProcessed(authorizationDocument)) continue;
            for (GeneralLedgerPendingEntry glpe : authorizationDocument.getGeneralLedgerPendingEntries()) {
                if (!encumbranceBalanceTypes.contains(glpe.getFinancialBalanceTypeCode())) continue;
                this.businessObjectService.delete((PersistableBusinessObject)glpe);
                hasRemovedGLPE = true;
            }
            if (!hasRemovedGLPE) continue;
            try {
                Note clearedGLPENote = this.documentService.createNoteFromDocument((Document)authorizationDocument, note);
                authorizationDocument.addNote(clearedGLPENote);
                this.businessObjectService.save((PersistableBusinessObject)authorizationDocument);
            }
            catch (Exception ex) {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected List<String> harvestCodesFromEncumbranceBalanceTypes() {
        ArrayList<String> balanceTypeCodes = new ArrayList<String>();
        Collection encumbranceBalanceTypes = this.getBalanceTypeService().getAllEncumbranceBalanceTypes();
        for (BalanceType encumbranceBalanceType : encumbranceBalanceTypes) {
            balanceTypeCodes.add(encumbranceBalanceType.getCode());
        }
        return balanceTypeCodes;
    }

    @Override
    public void disencumberTravelReimbursementFunds(TravelReimbursementDocument travelReimbursementDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        List<Encumbrance> tripEncumbrances = this.getEncumbrancesForTrip(travelReimbursementDocument.getTravelDocumentIdentifier(), null);
        List travelReimbursementLines = travelReimbursementDocument.getSourceAccountingLines();
        List<TemSourceAccountingLine> smooshedReimbursementLines = this.travelDocumentService.smooshAccountingLinesToSubAccount(travelReimbursementLines);
        for (TemSourceAccountingLine accountingLine : smooshedReimbursementLines) {
            Encumbrance encumbrance = this.findMatchingEncumbrance(accountingLine, tripEncumbrances);
            if (encumbrance == null || !encumbrance.getAccountLineEncumbranceOutstandingAmount().isPositive()) continue;
            GeneralLedgerPendingEntry pendingEntry = this.setupPendingEntry(encumbrance, sequenceHelper, (TravelDocument)travelReimbursementDocument);
            pendingEntry.setTransactionDebitCreditCode("C");
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetEntry = this.setupOffsetEntry(encumbrance, sequenceHelper, travelReimbursementDocument, pendingEntry);
            sequenceHelper.increment();
            KualiDecimal disencumbranceAmount = encumbrance.getAccountLineEncumbranceOutstandingAmount().isLessThan((AbstractKualiDecimal)accountingLine.getAmount()) ? encumbrance.getAccountLineEncumbranceOutstandingAmount() : accountingLine.getAmount();
            pendingEntry.setTransactionLedgerEntryAmount(disencumbranceAmount);
            offsetEntry.setTransactionLedgerEntryAmount(disencumbranceAmount);
            travelReimbursementDocument.addPendingEntry(pendingEntry);
            travelReimbursementDocument.addPendingEntry(offsetEntry);
            encumbrance.setAccountLineEncumbranceClosedAmount((KualiDecimal)encumbrance.getAccountLineEncumbranceClosedAmount().add((AbstractKualiDecimal)disencumbranceAmount));
        }
    }

    protected Encumbrance findMatchingEncumbrance(TemSourceAccountingLine accountingLine, List<Encumbrance> encumbrances) {
        for (Encumbrance encumbrance : encumbrances) {
            if (!StringUtils.equals((String)accountingLine.getChartOfAccountsCode(), (String)encumbrance.getChartOfAccountsCode()) || !StringUtils.equals((String)accountingLine.getAccountNumber(), (String)encumbrance.getAccountNumber()) || !StringUtils.equals((String)accountingLine.getSubAccountNumber(), (String)encumbrance.getSubAccountNumber()) && !StringUtils.equals((String)KFSConstants.getDashSubAccountNumber(), (String)encumbrance.getSubAccountNumber())) continue;
            return encumbrance;
        }
        return null;
    }

    @Override
    public GeneralLedgerPendingEntry setupPendingEntry(GeneralLedgerPendingEntrySourceDetail line, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, TravelDocument document) {
        GeneralLedgerPendingEntry pendingEntry = new GeneralLedgerPendingEntry();
        String balanceType = "";
        document.refreshReferenceObject("tripType");
        TripType tripType = document.getTripType();
        if (ObjectUtils.isNotNull((Object)((Object)tripType))) {
            balanceType = tripType.getEncumbranceBalanceType();
        }
        this.generalLedgerPendingEntryService.populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)document, line, sequenceHelper, pendingEntry);
        pendingEntry.setTransactionEncumbranceUpdateCode("R");
        pendingEntry.setReferenceFinancialDocumentNumber(document.getTravelDocumentIdentifier());
        pendingEntry.setReferenceFinancialDocumentTypeCode(document.getFinancialDocumentTypeCode());
        pendingEntry.setFinancialBalanceTypeCode(balanceType);
        pendingEntry.setFinancialDocumentApprovedCode("A");
        pendingEntry.setTransactionDebitCreditCode("C");
        pendingEntry.setReferenceFinancialSystemOriginationCode("01");
        return pendingEntry;
    }

    @Override
    public GeneralLedgerPendingEntry setupOffsetEntry(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, TravelDocument document, GeneralLedgerPendingEntry pendingEntry) {
        String balanceType = "";
        document.refreshReferenceObject("tripType");
        TripType tripType = document.getTripType();
        if (ObjectUtils.isNotNull((Object)((Object)tripType))) {
            balanceType = tripType.getEncumbranceBalanceType();
        }
        GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(pendingEntry);
        this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(pendingEntry.getUniversityFiscalYear(), pendingEntry, sequenceHelper, offsetEntry);
        offsetEntry.setTransactionEncumbranceUpdateCode("R");
        offsetEntry.setReferenceFinancialDocumentTypeCode(document.getFinancialDocumentTypeCode());
        offsetEntry.setFinancialDocumentApprovedCode("A");
        offsetEntry.setFinancialBalanceTypeCode(balanceType);
        offsetEntry.setTransactionDebitCreditCode("D");
        offsetEntry.setReferenceFinancialSystemOriginationCode(pendingEntry.getReferenceFinancialSystemOriginationCode());
        return offsetEntry;
    }

    @Override
    public GeneralLedgerPendingEntrySourceDetail convertTo(TravelDocument document, Encumbrance encumbrance) {
        SourceAccountingLine accountLine = new SourceAccountingLine();
        accountLine.setChartOfAccountsCode(encumbrance.getChartOfAccountsCode());
        accountLine.setAccountNumber(encumbrance.getAccountNumber());
        accountLine.setAccount(encumbrance.getAccount());
        accountLine.setDocumentNumber(document.getDocumentNumber());
        accountLine.setFinancialObjectCode(encumbrance.getObjectCode());
        accountLine.setObjectCode(encumbrance.getFinancialObject());
        accountLine.setReferenceNumber(encumbrance.getDocumentNumber());
        accountLine.setSubAccountNumber(encumbrance.getSubAccountNumber());
        accountLine.setFinancialSubObjectCode(encumbrance.getSubObjectCode());
        accountLine.setFinancialDocumentLineDescription(encumbrance.getTransactionEncumbranceDescription());
        accountLine.setAmount(encumbrance.getAccountLineEncumbranceOutstandingAmount());
        accountLine.setPostingYear(encumbrance.getUniversityFiscalYear());
        accountLine.setBalanceTypeCode(encumbrance.getBalanceTypeCode());
        return accountLine;
    }

    @Override
    public void deletePendingEntriesForTripCancellation(String travelDocumentIdentifier) {
        Person kfsSystemUser = this.getPersonService().getPersonByPrincipalName("kfs");
        List<String> tripDocumentNumbers = this.travelDocumentService.findAuthorizationDocumentNumbers(travelDocumentIdentifier);
        for (String documentNumber : tripDocumentNumbers) {
            this.generalLedgerPendingEntryService.delete(documentNumber);
            this.cancelPaymentDetailForDocument(documentNumber, kfsSystemUser);
        }
        this.getAccountsReceivableModuleService().cancelInvoicesForTrip(travelDocumentIdentifier, this.travelDocumentService.getOrgOptions());
    }

    protected void cancelPaymentDetailForDocument(String documentNumber, Person kfsSystemUser) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("custPaymentDocNbr", documentNumber);
        keyMap.put("paymentGroup.paymentStatusCode", PdpConstants.PaymentStatusCodes.OPEN);
        Collection paymentDetails = this.businessObjectService.findMatching(PaymentDetail.class, keyMap);
        if (paymentDetails != null && !paymentDetails.isEmpty()) {
            for (PaymentDetail paymentDetail : paymentDetails) {
                this.getPaymentMaintenanceService().cancelPendingPayment(Integer.valueOf(paymentDetail.getPaymentGroupId().intValue()), Integer.valueOf(paymentDetail.getId().intValue()), this.getConfigurationService().getPropertyValueAsString("travelAuthorization.message.advance.paymentCanceled"), kfsSystemUser);
            }
        }
    }

    @Override
    public HeldEncumbranceEntry convertPendingEntryToHeldEncumbranceEntry(GeneralLedgerPendingEntry glpe) {
        HeldEncumbranceEntry hee = new HeldEncumbranceEntry();
        hee.setDocumentNumber(glpe.getDocumentNumber());
        hee.setTransactionLedgerEntrySequenceNumber(glpe.getTransactionLedgerEntrySequenceNumber());
        hee.setTravelDocumentIdentifier(glpe.getReferenceFinancialDocumentNumber());
        hee.setChartOfAccountsCode(glpe.getChartOfAccountsCode());
        hee.setAccountNumber(glpe.getAccountNumber());
        hee.setSubAccountNumber(glpe.getSubAccountNumber());
        hee.setFinancialObjectCode(glpe.getFinancialObjectCode());
        hee.setFinancialSubObjectCode(glpe.getFinancialSubObjectCode());
        hee.setFinancialBalanceTypeCode(glpe.getFinancialBalanceTypeCode());
        hee.setTransactionLedgerEntryDescription(glpe.getTransactionLedgerEntryDescription());
        hee.setTransactionLedgerEntryAmount(glpe.getTransactionLedgerEntryAmount());
        hee.setTransactionDebitCreditCode(glpe.getTransactionDebitCreditCode());
        hee.setProjectCode(glpe.getProjectCode());
        hee.setFinancialDocumentTypeCode(glpe.getFinancialDocumentTypeCode());
        hee.setOrganizationReferenceId(glpe.getOrganizationReferenceId());
        hee.setAcctSufficientFundsFinObjCd(glpe.getAcctSufficientFundsFinObjCd());
        hee.setTransactionEntryOffsetIndicator(glpe.isTransactionEntryOffsetIndicator());
        hee.setTransactionEntryProcessedTs(glpe.getTransactionEntryProcessedTs());
        return hee;
    }

    @Override
    public GeneralLedgerPendingEntry convertHeldEncumbranceEntryToPendingEntry(HeldEncumbranceEntry hee) {
        AccountingPeriod postingAccountingPeriod = this.getPostingAccountingPeriodForHeldEncumbrance(hee);
        if (postingAccountingPeriod == null) {
            return null;
        }
        GeneralLedgerPendingEntry glpe = new GeneralLedgerPendingEntry();
        glpe.setFinancialSystemOriginationCode("01");
        glpe.setDocumentNumber(hee.getDocumentNumber());
        glpe.setTransactionLedgerEntrySequenceNumber(hee.getTransactionLedgerEntrySequenceNumber());
        glpe.setChartOfAccountsCode(hee.getChartOfAccountsCode());
        glpe.setAccountNumber(hee.getAccountNumber());
        glpe.setSubAccountNumber(hee.getSubAccountNumber());
        glpe.setFinancialObjectCode(hee.getFinancialObjectCode());
        glpe.setFinancialSubObjectCode(hee.getFinancialSubObjectCode());
        glpe.setFinancialBalanceTypeCode(hee.getFinancialBalanceTypeCode());
        if (ObjectUtils.isNull((Object)hee.getFinancialObject())) {
            hee.refreshReferenceObject("financialObject");
        }
        if (!ObjectUtils.isNull((Object)hee.getFinancialObject())) {
            glpe.setFinancialObjectTypeCode(hee.getFinancialObject().getFinancialObjectTypeCode());
        }
        glpe.setUniversityFiscalYear(postingAccountingPeriod.getUniversityFiscalYear());
        glpe.setUniversityFiscalPeriodCode(postingAccountingPeriod.getUniversityFiscalPeriodCode());
        glpe.setTransactionDate(this.getDateTimeService().getCurrentSqlDate());
        glpe.setFinancialDocumentTypeCode("TA");
        glpe.setOrganizationDocumentNumber(hee.getTravelDocumentIdentifier());
        glpe.setTransactionLedgerEntryDescription(hee.getTransactionLedgerEntryDescription());
        glpe.setTransactionLedgerEntryAmount(hee.getTransactionLedgerEntryAmount());
        glpe.setReferenceFinancialDocumentNumber(hee.getTravelDocumentIdentifier());
        glpe.setReferenceFinancialDocumentTypeCode("TA");
        glpe.setReferenceFinancialSystemOriginationCode("01");
        glpe.setTransactionEncumbranceUpdateCode("R");
        glpe.setFinancialDocumentApprovedCode("A");
        glpe.setTransactionDebitCreditCode(hee.getTransactionDebitCreditCode());
        glpe.setProjectCode(hee.getProjectCode());
        glpe.setFinancialDocumentTypeCode(hee.getFinancialDocumentTypeCode());
        glpe.setOrganizationReferenceId(hee.getOrganizationReferenceId());
        glpe.setAcctSufficientFundsFinObjCd(hee.getAcctSufficientFundsFinObjCd());
        glpe.setTransactionEntryOffsetIndicator(hee.isTransactionEntryOffsetIndicator());
        glpe.setTransactionEntryProcessedTs(hee.getTransactionEntryProcessedTs());
        return glpe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccountingPeriod getPostingAccountingPeriodForHeldEncumbrance(HeldEncumbranceEntry hee) {
        if (this.doesHeldEncumbranceRepresentAuthorization(hee)) {
            TravelAuthorizationDocument originalTravelAuthorization = this.getTravelAuthForTripId(hee.getTravelDocumentIdentifier());
            if (originalTravelAuthorization == null) {
                LOG.warn((Object)("Could not find travel authorization for trip id " + hee.getTravelDocumentIdentifier() + " which is strange because we're looking for the travel authorization which created a TEM held encumbrance entry"));
                return null;
            } else {
                TravelAuthorizationDocument currentTravelAuthorization = this.travelDocumentService.findCurrentTravelAuthorization(originalTravelAuthorization);
                Date tripEnd = new Date(currentTravelAuthorization.getTripEnd().getTime());
                Integer tripEndFiscalYear = this.getUniversityDateService().getFiscalYear((java.util.Date)tripEnd);
                if (tripEndFiscalYear != null) return this.getFirstAccountingPeriodOfFiscalYear(tripEndFiscalYear);
                LOG.info((Object)("Could not yet release TEM held encumbrance entry " + hee.getDocumentNumber() + " sequence: " + hee.getTransactionLedgerEntrySequenceNumber() + " because the fiscal year for the trip end does not yet exist."));
            }
            return null;
        } else {
            if (!this.doesHeldEncumbranceRepresentAdvance(hee)) return null;
            TravelAdvance advance = this.getTravelAdvanceForDocumentNumber(hee.getDocumentNumber());
            if (advance == null) return null;
            Integer dueDateFiscalYear = this.getUniversityDateService().getFiscalYear((java.util.Date)advance.getDueDate());
            return this.getFirstAccountingPeriodOfFiscalYear(dueDateFiscalYear);
        }
    }

    protected AccountingPeriod getFirstAccountingPeriodOfFiscalYear(Integer fiscalYear) {
        java.util.Date firstDateOfFiscalYear = this.getUniversityDateService().getFirstDateOfFiscalYear(fiscalYear);
        AccountingPeriod firstAccountingPeriodOfFiscalYear = this.getAccountingPeriodService().getByDate(new Date(firstDateOfFiscalYear.getTime()));
        return firstAccountingPeriodOfFiscalYear;
    }

    protected TravelAuthorizationDocument getTravelAuthForTripId(String tripId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("travelDocumentIdentifier", tripId);
        Collection travelAuthDocs = this.businessObjectService.findMatching(TravelAuthorizationDocument.class, fieldValues);
        TravelAuthorizationDocument travelAuth = null;
        Iterator iterator = travelAuthDocs.iterator();
        while (iterator.hasNext()) {
            TravelAuthorizationDocument currAuth;
            travelAuth = currAuth = (TravelAuthorizationDocument)iterator.next();
        }
        return travelAuth;
    }

    @Override
    public void releaseHeldEncumbrances() {
        HashMap<String, Boolean> releaseCache = new HashMap<String, Boolean>();
        HashMap documentCache = new HashMap();
        Collection allHeldEntries = this.businessObjectService.findAll(HeldEncumbranceEntry.class);
        ArrayList<HeldEncumbranceEntry> entriesToDelete = new ArrayList<HeldEncumbranceEntry>();
        ArrayList<GeneralLedgerPendingEntry> entriesToSave = new ArrayList<GeneralLedgerPendingEntry>();
        for (HeldEncumbranceEntry heldEntry : allHeldEntries) {
            GeneralLedgerPendingEntry glpe;
            if (!this.shouldReleaseEntry(heldEntry, releaseCache) || (glpe = this.convertHeldEncumbranceEntryToPendingEntry(heldEntry)) == null) continue;
            GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(glpe);
            GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper(glpe.getTransactionLedgerEntrySequenceNumber() + 1);
            Integer fiscalYear = this.universityDateService.getFiscalYear((java.util.Date)this.getDateForEntry(heldEntry));
            this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(fiscalYear, glpe, sequenceHelper, offsetEntry);
            glpe.setFinancialDocumentApprovedCode("A");
            offsetEntry.setFinancialDocumentApprovedCode("A");
            entriesToSave.add(glpe);
            entriesToSave.add(offsetEntry);
            entriesToDelete.add(heldEntry);
        }
        this.businessObjectService.save(entriesToSave);
        this.businessObjectService.delete(entriesToDelete);
    }

    protected boolean shouldReleaseEntry(HeldEncumbranceEntry heldEntry, Map<String, Boolean> releaseCache) {
        String cacheKey = this.buildReleaseCacheKey(heldEntry);
        Boolean cacheResults = releaseCache.get(cacheKey);
        if (cacheResults != null) {
            return cacheResults;
        }
        Date releaseDate = this.getDateForEntry(heldEntry);
        if (releaseDate == null) {
            LOG.warn((Object)("Could not determine release date for held entry " + heldEntry.getDocumentNumber()));
            releaseCache.put(cacheKey, Boolean.FALSE);
            return false;
        }
        boolean shouldReleaseEntry = !this.shouldHoldEntries(releaseDate);
        releaseCache.put(cacheKey, shouldReleaseEntry);
        return shouldReleaseEntry;
    }

    protected Date getDateForEntry(HeldEncumbranceEntry heldEntry) {
        if (this.doesHeldEncumbranceRepresentAuthorization(heldEntry)) {
            return this.getDateForEntryFromDocument(heldEntry.getDocumentNumber());
        }
        if (this.doesHeldEncumbranceRepresentAdvance(heldEntry)) {
            return this.getDateForEntryFromAdvance(heldEntry.getDocumentNumber());
        }
        return null;
    }

    protected boolean doesHeldEncumbranceRepresentAuthorization(HeldEncumbranceEntry heldEntry) {
        return StringUtils.equals((String)heldEntry.getFinancialDocumentTypeCode(), (String)"TA") || StringUtils.equals((String)heldEntry.getFinancialDocumentTypeCode(), (String)"TAA");
    }

    protected boolean doesHeldEncumbranceRepresentAdvance(HeldEncumbranceEntry heldEntry) {
        return StringUtils.equals((String)heldEntry.getFinancialDocumentTypeCode(), (String)"TAWF") || StringUtils.equals((String)heldEntry.getFinancialDocumentTypeCode(), (String)"TACA");
    }

    protected Date getDateForEntryFromDocument(String documentNumber) {
        TravelAuthorizationDocument travelAuth = (TravelAuthorizationDocument)this.getBusinessObjectService().findBySinglePrimaryKey(TravelAuthorizationDocument.class, (Object)documentNumber);
        if (travelAuth != null && travelAuth.getTripEnd() != null) {
            return new Date(travelAuth.getTripEnd().getTime());
        }
        return null;
    }

    protected Date getDateForEntryFromAdvance(String documentNumber) {
        TravelAdvance advance = this.getTravelAdvanceForDocumentNumber(documentNumber);
        if (advance != null) {
            return advance.getDueDate();
        }
        return null;
    }

    protected TravelAdvance getTravelAdvanceForDocumentNumber(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        Collection advances = this.getBusinessObjectService().findMatching(TravelAdvance.class, fieldValues);
        if (advances != null && !advances.isEmpty()) {
            TravelAdvance advance = (TravelAdvance)((Object)advances.iterator().next());
            return advance;
        }
        return null;
    }

    protected String buildReleaseCacheKey(HeldEncumbranceEntry heldEntry) {
        StringBuilder key = new StringBuilder();
        key.append(heldEntry.getDocumentNumber());
        key.append("-");
        key.append(heldEntry.getFinancialDocumentTypeCode());
        return key.toString();
    }

    @Override
    public void deleteHeldEncumbranceEntriesForTrip(String tripId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("travelDocumentIdentifier", tripId);
        this.businessObjectService.deleteMatching(HeldEncumbranceEntry.class, fieldValues);
    }

    @Override
    public boolean shouldHoldEntries(Date tripDate) {
        Integer currentFiscalYear = this.getUniversityDateService().getCurrentFiscalYear();
        Integer tripEndFiscalYear = this.getUniversityDateService().getFiscalYear((java.util.Date)tripDate);
        if (tripEndFiscalYear == null) {
            return true;
        }
        AccountingPeriod accountingPeriod = null;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", tripEndFiscalYear);
        fieldValues.put("financialDocumentTypeCode", "TA");
        Integer heldEncumbranceFiscalYear = this.getUniversityDateService().getFiscalYear((java.util.Date)tripDate);
        SystemOptions options = this.getOptionsService().getOptions(tripEndFiscalYear);
        int matchingCount = this.getBusinessObjectService().countMatching(OffsetDefinition.class, fieldValues);
        try {
            if (currentFiscalYear.equals(tripEndFiscalYear)) {
                accountingPeriod = this.getAccountingPeriodService().getByDate(tripDate);
            } else {
                String firstDateOfEncumbranceFiscalYear = this.getDateTimeService().toDateString(this.getUniversityDateService().getFirstDateOfFiscalYear(tripEndFiscalYear));
                accountingPeriod = this.getAccountingPeriodService().getByDate(this.getDateTimeService().convertToSqlDate(firstDateOfEncumbranceFiscalYear));
            }
        }
        catch (ParseException pe) {
            LOG.error((Object)("error while parsing date " + pe));
        }
        boolean holdEncumbrance = tripEndFiscalYear == null || options == null || accountingPeriod == null || matchingCount == 0;
        return holdEncumbrance;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public void setEncumbranceService(EncumbranceService encumbranceService) {
        this.encumbranceService = encumbranceService;
    }

    public EncumbranceCalculator getEncumbranceCalculator() {
        return this.encumbranceCalculator;
    }

    public void setEncumbranceCalculator(EncumbranceCalculator encumbranceCalculator) {
        this.encumbranceCalculator = encumbranceCalculator;
    }

    public AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public PaymentMaintenanceService getPaymentMaintenanceService() {
        return this.paymentMaintenanceService;
    }

    public void setPaymentMaintenanceService(PaymentMaintenanceService paymentMaintenanceService) {
        this.paymentMaintenanceService = paymentMaintenanceService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public BalanceTypeService getBalanceTypeService() {
        return this.balanceTypeService;
    }

    public void setBalanceTypeService(BalanceTypeService balanceTypeService) {
        this.balanceTypeService = balanceTypeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AccountingPeriodService getAccountingPeriodService() {
        return this.accountingPeriodService;
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }
}

