/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.ProjectCodeService;
import org.kuali.kfs.coa.service.SubAccountService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.AgencyDataImportStep;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTravelerService;
import org.kuali.kfs.module.tem.batch.service.ImportedExpensePendingEntryService;
import org.kuali.kfs.module.tem.batch.service.impl.ExpenseImportServiceBase;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ExpenseImportByTravelerServiceImpl
extends ExpenseImportServiceBase
implements ExpenseImportByTravelerService {
    public static Logger LOG = Logger.getLogger(ExpenseImportByTravelerServiceImpl.class);
    private TemProfileService temProfileService;
    private AccountService accountService;
    private SubAccountService subAccountService;
    private ProjectCodeService projectCodeService;
    private ParameterService parameterService;
    private ObjectCodeService objectCodeService;
    private SubObjectCodeService subObjectCodeService;
    private BusinessObjectService businessObjectService;
    private ImportedExpensePendingEntryService importedExpensePendingEntryService;
    private DateTimeService dateTimeService;
    private TravelExpenseService travelExpenseService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private UniversityDateService universityDateService;

    @Override
    public List<ErrorMessage> validateMandatoryFieldsPresent(AgencyStagingData agencyData) {
        ErrorMessage error;
        boolean requiredFieldsValid = true;
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        if (StringUtils.isEmpty((String)agencyData.getTravelerId())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"travelerId"});
            errorMessages.add(error);
        }
        if (this.isAmountEmpty(agencyData.getTripExpenseAmount())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"tripExpenseAmount"});
            errorMessages.add(error);
        }
        if (StringUtils.isEmpty((String)agencyData.getTripInvoiceNumber())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"tripInvoiceNumber"});
            errorMessages.add(error);
        }
        if (ObjectUtils.isNull((Object)agencyData.getTransactionPostingDate())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"transactionPostingDate"});
            errorMessages.add(error);
        }
        if (StringUtils.isEmpty((String)agencyData.getCreditCardOrAgencyCode())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"creditCardOrAgencyCode"});
            errorMessages.add(error);
        }
        if (this.isTripDataMissing(agencyData)) {
            error = new ErrorMessage("message.batch.tem.agencyDataAirLodgingRentalMissing", new String[0]);
            errorMessages.add(error);
        }
        if (!errorMessages.isEmpty()) {
            LOG.error((Object)"Missing one or more required fields.");
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateAgencyData(AgencyStagingData agencyData) {
        LOG.info((Object)"Validating agency data.");
        List<ErrorMessage> errorMessages = this.validateMandatoryFieldsPresent(agencyData);
        if (!errorMessages.isEmpty()) {
            agencyData.setErrorCode("REQ");
            return errorMessages;
        }
        errorMessages = this.validateDuplicateData(agencyData);
        if (!errorMessages.isEmpty()) {
            agencyData.setErrorCode("DUP");
            return errorMessages;
        }
        agencyData.setErrorCode("OK");
        errorMessages = this.validateTraveler(agencyData);
        errorMessages.addAll(this.validateAccountingInfo(agencyData));
        errorMessages.addAll(this.validateCreditCardAgency(agencyData));
        LOG.info((Object)"Finished validating agency data.");
        agencyData.setProcessingTimestamp(this.dateTimeService.getCurrentTimestamp());
        if (ObjectUtils.isNull((Object)agencyData.getCreationTimestamp())) {
            agencyData.setCreationTimestamp(this.dateTimeService.getCurrentTimestamp());
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateTraveler(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        TemProfile profile = this.getTraveler(agencyData);
        if (ObjectUtils.isNotNull((Object)((Object)profile))) {
            agencyData.setTemProfileId(profile.getProfileId());
        } else {
            LOG.error((Object)("Invalid Traveler in Agency Data record. travelerId: " + agencyData.getTravelerId()));
            errorMessages.add(new ErrorMessage("message.batch.tem.agencyDataInvalidTraveler", new String[]{agencyData.getTravelerId()}));
            this.setErrorCode(agencyData, "TRAV");
        }
        return errorMessages;
    }

    @Override
    public TemProfile getTraveler(AgencyStagingData agencyData) {
        TemProfile profile = this.temProfileService.findTemProfileByEmployeeId(agencyData.getTravelerId());
        if (ObjectUtils.isNotNull((Object)((Object)profile))) {
            LOG.info((Object)("Traveler is an Employee: " + agencyData.getTravelerId()));
            agencyData.setTemProfileId(profile.getProfileId());
            return profile;
        }
        profile = this.temProfileService.findTemProfileByCustomerNumber(agencyData.getTravelerId());
        if (ObjectUtils.isNotNull((Object)((Object)profile))) {
            LOG.info((Object)("Traveler is a Customer: " + agencyData.getTravelerId()));
            agencyData.setTemProfileId(profile.getProfileId());
            return profile;
        }
        LOG.error((Object)("Invalid Traveler in Agency Data record. travelerId: " + agencyData.getTravelerId()));
        return null;
    }

    @Override
    public List<ErrorMessage> validateAccountingInfo(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        ArrayList<TripAccountingInformation> accountingInfos = agencyData.getTripAccountingInformation();
        Collection validationParameters = this.getParameterService().getParameterValuesAsString(AgencyDataImportStep.class, "ACCOUNTING_LINE_VALIDATION");
        if (ObjectUtils.isNull((Object)validationParameters)) {
            return errorMessages;
        }
        for (TripAccountingInformation account : accountingInfos) {
            errorMessages.addAll(this.validateAccountingInfoLine(agencyData, account, validationParameters).values());
        }
        return errorMessages;
    }

    @Override
    public Map<String, ErrorMessage> validateAccountingInfoLine(TripAccountingInformation accountingLine) {
        return this.validateAccountingInfoLine(null, accountingLine, null);
    }

    protected Map<String, ErrorMessage> validateAccountingInfoLine(AgencyStagingData agencyData, TripAccountingInformation accountingLine, Collection<String> validationParameters) {
        HashMap<String, ErrorMessage> errorMap = new HashMap<String, ErrorMessage>();
        if (ObjectUtils.isNull(validationParameters) && ObjectUtils.isNull((Object)(validationParameters = this.getParameterService().getParameterValuesAsString(AgencyDataImportStep.class, "ACCOUNTING_LINE_VALIDATION")))) {
            return errorMap;
        }
        boolean setAgencyDataErrorCode = false;
        Integer profileId = null;
        String travelerId = "";
        if (ObjectUtils.isNotNull((Object)((Object)agencyData))) {
            setAgencyDataErrorCode = true;
            travelerId = agencyData.getTravelerId();
            profileId = agencyData.getTemProfileId();
        }
        if (validationParameters.contains("Account") && !this.isAccountNumberValid(accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid Account in Tem Profile or Agency Data record. travelerId: " + travelerId + " temProfileId: " + profileId + " chart code: " + accountingLine.getTripChartCode() + " account: " + accountingLine.getTripAccountNumber()));
                this.setErrorCode(agencyData, "ACT");
            }
            errorMap.put("tripAccountNumber", new ErrorMessage("message.batch.tem.agencyDataInvalidAccountNum", new String[]{accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber()}));
        }
        if (validationParameters.contains("Sub-Account") && StringUtils.isNotEmpty((String)accountingLine.getTripSubAccountNumber()) && !this.isSubAccountNumberValid(accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber(), accountingLine.getTripSubAccountNumber())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid SubAccount in Tem Profile or Agency Data record. travelerId: " + travelerId + " temProfileId: " + profileId + " chart code: " + accountingLine.getTripChartCode() + " account: " + accountingLine.getTripAccountNumber() + " subaccount: " + accountingLine.getTripSubAccountNumber()));
                this.setErrorCode(agencyData, "SACT");
            }
            errorMap.put("tripSubAccountNumber", new ErrorMessage("message.batch.tem.agencyDataInvalidSubAccount", new String[]{accountingLine.getTripSubAccountNumber()}));
        }
        if (StringUtils.isNotEmpty((String)accountingLine.getProjectCode()) && !this.isProjectCodeValid(accountingLine.getProjectCode())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid Project in Tem Profile or Agency Data record. travelerId: " + travelerId + " temProfileId: " + profileId + " project code: " + accountingLine.getProjectCode()));
                this.setErrorCode(agencyData, "PROJ");
            }
            errorMap.put("projectCode", new ErrorMessage("message.batch.tem.agencyDataInvalidProjectCode", new String[]{accountingLine.getProjectCode()}));
        }
        return errorMap;
    }

    @Override
    public List<ErrorMessage> validateDuplicateData(AgencyStagingData agencyData) {
        List<ErrorMessage> errorMessages = this.validateMandatoryFieldsPresent(agencyData);
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        List<AgencyStagingData> agencyDataList = this.checkDuplicateData(agencyData);
        if (ObjectUtils.isNotNull(agencyDataList) || agencyDataList.size() != 0) {
            boolean isDuplicate = false;
            String errorMessage = "Found a duplicate entry for Agency Staging Data: Duplicate Ids ";
            for (AgencyStagingData duplicate : agencyDataList) {
                Integer duplicateId = duplicate.getId();
                if (!ObjectUtils.isNotNull((Object)agencyData.getId()) || duplicateId.intValue() == agencyData.getId().intValue()) continue;
                errorMessage = errorMessage + duplicate.getId() + " ";
                isDuplicate = true;
            }
            if (isDuplicate) {
                LOG.error((Object)errorMessage);
                ErrorMessage error = new ErrorMessage("message.batch.tem.agencyData.traveler.DuplicateRecord", new String[]{agencyData.getTravelerId(), agencyData.getItineraryDataString(), agencyData.getCreditCardOrAgencyCode(), agencyData.getTransactionPostingDate().toString(), agencyData.getTripExpenseAmount().toString(), agencyData.getTripInvoiceNumber()});
                errorMessages.add(error);
            }
        }
        return errorMessages;
    }

    protected List<AgencyStagingData> checkDuplicateData(AgencyStagingData agencyStagingData) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)agencyStagingData.getTravelerId())) {
            fieldValues.put("travelerId", agencyStagingData.getTravelerId());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getAirTicketNumber())) {
            fieldValues.put("airTicketNumber", agencyStagingData.getAirTicketNumber());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getLodgingItineraryNumber())) {
            fieldValues.put("lodgingItineraryNumber", agencyStagingData.getLodgingItineraryNumber());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getRentalCarItineraryNumber())) {
            fieldValues.put("rentalCarItineraryNumber", agencyStagingData.getRentalCarItineraryNumber());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getCreditCardOrAgencyCode())) {
            fieldValues.put("creditCardOrAgencyCode", agencyStagingData.getCreditCardOrAgencyCode());
        }
        if (ObjectUtils.isNotNull((Object)agencyStagingData.getTransactionPostingDate())) {
            fieldValues.put("transactionPostingDate", agencyStagingData.getTransactionPostingDate());
        }
        if (ObjectUtils.isNotNull((Object)agencyStagingData.getTripExpenseAmount())) {
            fieldValues.put("tripExpenseAmount", agencyStagingData.getTripExpenseAmount());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getTripInvoiceNumber())) {
            fieldValues.put("tripInvoiceNumber", agencyStagingData.getTripInvoiceNumber());
        }
        List agencyDataList = (List)this.businessObjectService.findMatching(AgencyStagingData.class, fieldValues);
        return agencyDataList;
    }

    @Override
    public List<ErrorMessage> validateCreditCardAgency(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        if (!this.isCreditCardAgencyValid(agencyData)) {
            errorMessages.add(new ErrorMessage("message.batch.tem.agency.creditcard.data.InvalidCreditCardAgency", new String[]{agencyData.getCreditCardOrAgencyCode()}));
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> distributeExpense(AgencyStagingData agencyData) {
        LOG.info((Object)("Distributing expense for agency data: " + agencyData.getId()));
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        if (agencyData.isActive()) {
            if ("OK".equals(agencyData.getErrorCode())) {
                HistoricalTravelExpense expense = this.travelExpenseService.createHistoricalTravelExpense(agencyData);
                this.businessObjectService.save((PersistableBusinessObject)expense);
                agencyData.setMoveToHistoryIndicator(true);
                agencyData.setErrorCode("HIS");
            } else {
                LOG.info((Object)("Agency Data: " + agencyData.getId() + "; expected errorCode=" + "OK" + ", received errorCode=" + agencyData.getErrorCode() + ". Will not attempt to distribute expense."));
                errors.add(new ErrorMessage("message.batch.tem.agencydatadistribution.errorCode", new String[]{"OK", agencyData.getErrorCode()}));
            }
        } else {
            LOG.info((Object)("Agency Data: " + agencyData.getId() + ", is not active. Will not distribute."));
            errors.add(new ErrorMessage("message.batch.tem.agencydatadistribution.active", new String[0]));
        }
        LOG.info((Object)("Finished distributing expense for agency data: " + agencyData.getId() + ". Agency data " + (errors.isEmpty() ? "was" : "was not") + " distributed."));
        return errors;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    @Override
    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    public SubAccountService getSubAccountService() {
        return this.subAccountService;
    }

    public void setSubAccountService(SubAccountService subAccountService) {
        this.subAccountService = subAccountService;
    }

    @Override
    public ProjectCodeService getProjectCodeService() {
        return this.projectCodeService;
    }

    public void setProjectCodeService(ProjectCodeService projectCodeService) {
        this.projectCodeService = projectCodeService;
    }

    @Override
    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    @Override
    public SubObjectCodeService getSubObjectCodeService() {
        return this.subObjectCodeService;
    }

    public void setSubObjectCodeService(SubObjectCodeService subObjectCodeService) {
        this.subObjectCodeService = subObjectCodeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    public GeneralLedgerPendingEntryService getGeneralLedgerPendingEntryService() {
        return this.generalLedgerPendingEntryService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setImportedExpensePendingEntryService(ImportedExpensePendingEntryService importedExpensePendingEntryService) {
        this.importedExpensePendingEntryService = importedExpensePendingEntryService;
    }
}

