/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.AgencyServiceFee;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Entity
@Table(name="TEM_AGENCY_STAGING_T")
public class AgencyStagingData
extends PersistableBusinessObjectBase
implements MutableInactivatable {
    private Integer id;
    private String errorCode;
    private Integer duplicateRecordId;
    private Integer temProfileId;
    private TemProfile profile;
    private String importBy;
    private Integer agencyDataId;
    private String creditCardOrAgencyCode;
    private String agency;
    private String otherCompanyName;
    private String agencyFileName;
    private String stagingFileName;
    private String merchantName;
    private Date billingCycleDate;
    private CreditCardAgency creditCardAgency;
    private String tripId;
    private String tripInvoiceNumber;
    private String tripTravelerTypeId;
    private KualiDecimal otherAmount;
    private String travelerName;
    private String travelerId;
    private String travelerNetworkId;
    private KualiDecimal tripExpenseAmount;
    private String alternateTripId;
    private String tripArrangerName;
    private ArrayList<TripAccountingInformation> tripAccountingInformation;
    private String groupObjectCode;
    private String distributionCode;
    private AgencyServiceFee agencyServiceFee;
    private String searchChartOfAccountsCode;
    private String searchAccountNumber;
    private String searchSubAccountNumber;
    private Chart searchChart;
    private Account searchAccount;
    private SubAccount searchSubAccount;
    private Date tripDepartureDate;
    private Date tripReturnDate;
    private String fareSaverCode;
    private Date airBookDate;
    private String airCarrierCode;
    private String airTicketNumber;
    private String pnrNumber;
    private String airTicketClass;
    private KualiDecimal airTransactionAmount;
    private KualiDecimal airBaseFareAmount;
    private KualiDecimal airTaxAmount;
    private KualiDecimal airLowFareAmount;
    private String airReasonCode;
    private String airSegmentId;
    private String airDestinationCode;
    private String airServiceFeeNumber;
    private KualiDecimal airServiceFeeAmount;
    private String transactionUniqueId;
    private String lodgingItineraryNumber;
    private Date lodgingPrepayDate;
    private KualiDecimal lodgingAmount;
    private String lodgingPrepayDaysNumber;
    private String lodgingPropertyName;
    private Date tripLodgingArrivalDate;
    private Date lodgingDepartureDate;
    private Date lodgingBookingDate;
    private String lodgingPropertyCityName;
    private String lodgingPropertyStateCode;
    private String lodgingCountryName;
    private String rentalCarItineraryNumber;
    private KualiDecimal rentalCarAmount;
    private String rentalCarNumberOfDays;
    private String rentalCarCompanyName;
    private Date rentalCarOpenDate;
    private Date rentalCarCloseDate;
    private KualiDecimal rentalCarFuelAmount;
    private KualiDecimal rentalCarAdditionalAmount;
    private KualiDecimal rentalCarTaxAmount;
    private KualiDecimal rentalCarSurchargeAmount;
    private KualiDecimal rentalCarGovernmentSurchargeAmount;
    private KualiDecimal rentalCarBillAmount;
    private String rentalCarDetailText;
    private String registrationCompanyName;
    private KualiDecimal registrationAmount;
    private Date transactionPostingDate;
    private String objectVerNumber;
    private Timestamp creationTimestamp;
    private Timestamp processingTimestamp;
    private boolean moveToHistoryIndicator;
    private Boolean active = Boolean.TRUE;
    private Boolean manualCreated = Boolean.FALSE;
    private Integer copiedFromId;

    public AgencyStagingData() {
        this.tripAccountingInformation = new ArrayList();
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    @Id
    @GeneratedValue(generator="TEM_AGENCY_STAGING_ID_SEQ")
    @SequenceGenerator(name="TEM_AGENCY_STAGING_ID_SEQ", sequenceName="TEM_AGENCY_STAGING_ID_SEQ", allocationSize=5)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="ERROR_CD", length=40, nullable=true)
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Column(name="DUP_REC_ID", nullable=false)
    public Integer getDuplicateRecordId() {
        return this.duplicateRecordId;
    }

    public void setDuplicateRecordId(Integer duplicateRecordId) {
        this.duplicateRecordId = duplicateRecordId;
    }

    @Column(name="PROFILE_ID", length=19, nullable=true)
    public Integer getTemProfileId() {
        return this.temProfileId;
    }

    public void setTemProfileId(Integer temProfileId) {
        this.temProfileId = temProfileId;
    }

    @Column(name="AGENCY_DATA_ID", length=10, nullable=true)
    public Integer getAgencyDataId() {
        return this.agencyDataId;
    }

    public void setAgencyDataId(Integer agencyDataId) {
        this.agencyDataId = agencyDataId;
    }

    @Column(name="CREDIT_AGENCY_CD", length=4, nullable=true)
    public String getCreditCardOrAgencyCode() {
        return this.creditCardOrAgencyCode;
    }

    public void setCreditCardOrAgencyCode(String creditCardOrAgencyCode) {
        this.creditCardOrAgencyCode = creditCardOrAgencyCode;
    }

    @Column(name="AGENCY", length=20, nullable=true)
    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agency) {
        this.agency = agency;
    }

    @Column(name="OTHER_CO_NM", length=30, nullable=true)
    public String getOtherCompanyName() {
        return this.otherCompanyName;
    }

    public void setOtherCompanyName(String otherCompanyName) {
        this.otherCompanyName = otherCompanyName;
    }

    @Column(name="AGENCY_FL_NM", length=50, nullable=true)
    public String getAgencyFileName() {
        return this.agencyFileName;
    }

    public void setAgencyFileName(String agencyFileName) {
        this.agencyFileName = agencyFileName;
    }

    @Column(name="MERCH_NM", length=40, nullable=true)
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    @Column(name="BILLING_CYCLE_DT", nullable=true)
    public Date getBillingCycleDate() {
        return this.billingCycleDate;
    }

    public void setBillingCycleDate(Date billingCycleDate) {
        this.billingCycleDate = billingCycleDate;
    }

    @Column(name="TRIP_ID", length=19, nullable=true)
    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String tripId) {
        this.tripId = tripId;
    }

    @Column(name="TRIP_INV_NBR", length=20, nullable=true)
    public String getTripInvoiceNumber() {
        return this.tripInvoiceNumber;
    }

    public void setTripInvoiceNumber(String tripInvoiceNumber) {
        this.tripInvoiceNumber = tripInvoiceNumber;
    }

    @Column(name="TRIP_TRV_TYP_ID", length=1, nullable=true)
    public String getTripTravelerTypeId() {
        return this.tripTravelerTypeId;
    }

    public void setTripTravelerTypeId(String tripTravelerTypeId) {
        this.tripTravelerTypeId = tripTravelerTypeId;
    }

    @Column(name="OTHER_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getOtherAmount() {
        return this.otherAmount;
    }

    public void setOtherAmount(KualiDecimal otherAmount) {
        this.otherAmount = otherAmount;
    }

    public void setOtherAmount(String otherAmount) {
        this.otherAmount = new KualiDecimal(otherAmount);
    }

    @Column(name="TRAVELER_NM", length=50, nullable=false)
    public String getTravelerName() {
        return this.travelerName;
    }

    public void setTravelerName(String travelerName) {
        this.travelerName = travelerName;
    }

    @Column(name="TRAVELER_ID", length=40, nullable=true)
    public String getTravelerId() {
        return this.travelerId;
    }

    public void setTravelerId(String travelerId) {
        this.travelerId = travelerId;
    }

    @Column(name="TRAVELER_NTWK_ID", length=9, nullable=true)
    public String getTravelerNetworkId() {
        return this.travelerNetworkId;
    }

    public void setTravelerNetworkId(String travelerNetworkId) {
        this.travelerNetworkId = travelerNetworkId;
    }

    @Column(name="TRP_EXP_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getTripExpenseAmount() {
        return this.tripExpenseAmount;
    }

    public void setTripExpenseAmount(KualiDecimal tripExpenseAmount) {
        this.tripExpenseAmount = tripExpenseAmount;
    }

    public void setTripExpenseAmount(String tripExpenseAmount) {
        this.tripExpenseAmount = new KualiDecimal(tripExpenseAmount);
    }

    @Column(name="ALT_TRP_ID", length=20, nullable=true)
    public String getAlternateTripId() {
        return this.alternateTripId;
    }

    public void setAlternateTripId(String alternateTripId) {
        this.alternateTripId = alternateTripId;
    }

    @Column(name="TRP_ARR_NM", length=50, nullable=true)
    public String getTripArrangerName() {
        return this.tripArrangerName;
    }

    public void setTripArrangerName(String tripArrangerName) {
        this.tripArrangerName = tripArrangerName;
    }

    public ArrayList<TripAccountingInformation> getTripAccountingInformation() {
        return this.tripAccountingInformation;
    }

    public void setTripAccountingInformation(ArrayList<TripAccountingInformation> tripAccountingInformation) {
        this.tripAccountingInformation = tripAccountingInformation;
    }

    public void addTripAccountingInformation(TripAccountingInformation accountingInfo) {
        TravelExpenseService travelExpenseService = (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
        if (!travelExpenseService.isTripAccountingInformationEmpty(accountingInfo)) {
            this.getTripAccountingInformation().add(accountingInfo);
        }
    }

    @Column(name="GRP_OBJ_CD", length=20, nullable=true)
    public String getGroupObjectCode() {
        return this.groupObjectCode;
    }

    public void setGroupObjectCode(String groupObjectCode) {
        this.groupObjectCode = groupObjectCode;
    }

    @Column(name="DIST_CD", length=4, nullable=true)
    public String getDistributionCode() {
        return this.distributionCode;
    }

    public void setDistributionCode(String distributionCode) {
        this.distributionCode = distributionCode;
    }

    @Column(name="TRP_DPT_DT", nullable=true)
    public Date getTripDepartureDate() {
        return this.tripDepartureDate;
    }

    public void setTripDepartureDate(Date tripDepartureDate) {
        this.tripDepartureDate = tripDepartureDate;
    }

    @Column(name="TRP_RTRN_DT", nullable=true)
    public Date getTripReturnDate() {
        return this.tripReturnDate;
    }

    public void setTripReturnDate(Date tripReturnDate) {
        this.tripReturnDate = tripReturnDate;
    }

    @Column(name="FARE_SVR_CD", length=1, nullable=true)
    public String getFareSaverCode() {
        return this.fareSaverCode;
    }

    public void setFareSaverCode(String fareSaverCode) {
        this.fareSaverCode = fareSaverCode;
    }

    @Column(name="AIR_BK_DT", nullable=true)
    public Date getAirBookDate() {
        return this.airBookDate;
    }

    public void setAirBookDate(Date airBookDate) {
        this.airBookDate = airBookDate;
    }

    @Column(name="AIR_CARR_CD", length=3, nullable=true)
    public String getAirCarrierCode() {
        return this.airCarrierCode;
    }

    public void setAirCarrierCode(String airCarrierCode) {
        this.airCarrierCode = airCarrierCode;
    }

    @Column(name="AIR_TKT_NBR", length=20, nullable=true)
    public String getAirTicketNumber() {
        return this.airTicketNumber;
    }

    public void setAirTicketNumber(String airTicketNumber) {
        this.airTicketNumber = airTicketNumber;
    }

    @Column(name="PNR_NBR", length=20, nullable=true)
    public String getPnrNumber() {
        return this.pnrNumber;
    }

    public void setPnrNumber(String pnrNumber) {
        this.pnrNumber = pnrNumber;
    }

    @Column(name="AIR_TKT_CLASS", length=20, nullable=true)
    public String getAirTicketClass() {
        return this.airTicketClass;
    }

    public void setAirTicketClass(String airTicketClass) {
        this.airTicketClass = airTicketClass;
    }

    @Column(name="AIR_TRANS_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getAirTransactionAmount() {
        return this.airTransactionAmount;
    }

    public void setAirTransactionAmount(KualiDecimal airTransactionAmount) {
        this.airTransactionAmount = airTransactionAmount;
    }

    public void setAirTransactionAmount(String airTransactionAmount) {
        this.airTransactionAmount = new KualiDecimal(airTransactionAmount);
    }

    @Column(name="AIR_BASE_FARE_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getAirBaseFareAmount() {
        return this.airBaseFareAmount;
    }

    public void setAirBaseFareAmount(KualiDecimal airBaseFareAmount) {
        this.airBaseFareAmount = airBaseFareAmount;
    }

    public void setAirBaseFareAmount(String airBaseFareAmount) {
        this.airBaseFareAmount = new KualiDecimal(airBaseFareAmount);
    }

    @Column(name="AIR_TX_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getAirTaxAmount() {
        return this.airTaxAmount;
    }

    public void setAirTaxAmount(KualiDecimal airTaxAmount) {
        this.airTaxAmount = airTaxAmount;
    }

    public void setAirTaxAmount(String airTaxAmount) {
        this.airTaxAmount = new KualiDecimal(airTaxAmount);
    }

    @Column(name="AIR_LOW_FARE_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getAirLowFareAmount() {
        return this.airLowFareAmount;
    }

    public void setAirLowFareAmount(KualiDecimal airLowFareAmount) {
        this.airLowFareAmount = airLowFareAmount;
    }

    public void setAirLowFareAmount(String airLowFareAmount) {
        this.airLowFareAmount = new KualiDecimal(airLowFareAmount);
    }

    @Column(name="AIR_RSN_CD", length=1, nullable=true)
    public String getAirReasonCode() {
        return this.airReasonCode;
    }

    public void setAirReasonCode(String airReasonCode) {
        this.airReasonCode = airReasonCode;
    }

    @Column(name="AIR_SEG_ID", length=100, nullable=true)
    public String getAirSegmentId() {
        return this.airSegmentId;
    }

    public void setAirSegmentId(String airSegmentId) {
        this.airSegmentId = airSegmentId;
    }

    @Column(name="AIR_DEST_CD", length=3, nullable=true)
    public String getAirDestinationCode() {
        return this.airDestinationCode;
    }

    public void setAirDestinationCode(String airDestinationCode) {
        this.airDestinationCode = airDestinationCode;
    }

    @Column(name="AIR_SRVC_FEE_NBR", length=20, nullable=true)
    public String getAirServiceFeeNumber() {
        return this.airServiceFeeNumber;
    }

    public void setAirServiceFeeNumber(String airServiceFeeNumber) {
        this.airServiceFeeNumber = airServiceFeeNumber;
    }

    @Column(name="AIR_SRVC_FEE_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getAirServiceFeeAmount() {
        return this.airServiceFeeAmount;
    }

    public void setAirServiceFeeAmount(KualiDecimal airServiceFeeAmount) {
        this.airServiceFeeAmount = airServiceFeeAmount;
    }

    public void setAirServiceFeeAmount(String airServiceFeeAmount) {
        this.airServiceFeeAmount = new KualiDecimal(airServiceFeeAmount);
    }

    @Column(name="TRANS_ID", length=40, nullable=true)
    public String getTransactionUniqueId() {
        return this.transactionUniqueId;
    }

    public void setTransactionUniqueId(String transactionUniqueId) {
        this.transactionUniqueId = transactionUniqueId;
    }

    @Column(name="LDG_ITN_NBR", length=20, nullable=true)
    public String getLodgingItineraryNumber() {
        return this.lodgingItineraryNumber;
    }

    public void setLodgingItineraryNumber(String lodgingItineraryNumber) {
        this.lodgingItineraryNumber = lodgingItineraryNumber;
    }

    @Column(name="LDG_PRPY_DT", nullable=true)
    public Date getLodgingPrepayDate() {
        return this.lodgingPrepayDate;
    }

    public void setLodgingPrepayDate(Date lodgingPrepayDate) {
        this.lodgingPrepayDate = lodgingPrepayDate;
    }

    @Column(name="LDG_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getLodgingAmount() {
        return this.lodgingAmount;
    }

    public void setLodgingAmount(KualiDecimal lodgingAmount) {
        this.lodgingAmount = lodgingAmount;
    }

    public void setLodgingAmount(String lodgingAmount) {
        this.lodgingAmount = new KualiDecimal(lodgingAmount);
    }

    @Column(name="LDG_PRPY_NBR", length=3, nullable=true)
    public String getLodgingPrepayDaysNumber() {
        return this.lodgingPrepayDaysNumber;
    }

    public void setLodgingPrepayDaysNumber(String lodgingPrepayDaysNumber) {
        this.lodgingPrepayDaysNumber = lodgingPrepayDaysNumber;
    }

    @Column(name="LDG_PRP_NM", length=30, nullable=true)
    public String getLodgingPropertyName() {
        return this.lodgingPropertyName;
    }

    public void setLodgingPropertyName(String lodgingPropertyName) {
        this.lodgingPropertyName = lodgingPropertyName;
    }

    @Column(name="TRP_LDG_ARRV_DT", nullable=true)
    public Date getTripLodgingArrivalDate() {
        return this.tripLodgingArrivalDate;
    }

    public void setTripLodgingArrivalDate(Date tripLodgingArrivalDate) {
        this.tripLodgingArrivalDate = tripLodgingArrivalDate;
    }

    @Column(name="LDG_DEPT_DT", nullable=true)
    public Date getLodgingDepartureDate() {
        return this.lodgingDepartureDate;
    }

    public void setLodgingDepartureDate(Date lodgingDepartureDate) {
        this.lodgingDepartureDate = lodgingDepartureDate;
    }

    @Column(name="LDG_BK_DT", nullable=true)
    public Date getLodgingBookingDate() {
        return this.lodgingBookingDate;
    }

    public void setLodgingBookingDate(Date lodgingBookingDate) {
        this.lodgingBookingDate = lodgingBookingDate;
    }

    @Column(name="LDG_PRP_CITY_NM", length=30, nullable=true)
    public String getLodgingPropertyCityName() {
        return this.lodgingPropertyCityName;
    }

    public void setLodgingPropertyCityName(String lodgingPropertyCityName) {
        this.lodgingPropertyCityName = lodgingPropertyCityName;
    }

    @Column(name="LDG_PRP_STATE_CD", length=40, nullable=true)
    public String getLodgingPropertyStateCode() {
        return this.lodgingPropertyStateCode;
    }

    public void setLodgingPropertyStateCode(String lodgingPropertyStateCode) {
        this.lodgingPropertyStateCode = lodgingPropertyStateCode;
    }

    @Column(name="LDG_PRP_COUNTRY_NM", length=2, nullable=true)
    public String getLodgingCountryName() {
        return this.lodgingCountryName;
    }

    public void setLodgingCountryName(String lodgingCountryName) {
        this.lodgingCountryName = lodgingCountryName;
    }

    @Column(name="RNT_CAR_ITN_NBR", nullable=true)
    public String getRentalCarItineraryNumber() {
        return this.rentalCarItineraryNumber;
    }

    public void setRentalCarItineraryNumber(String rentalCarItineraryNumber) {
        this.rentalCarItineraryNumber = rentalCarItineraryNumber;
    }

    @Column(name="RNT_CAR_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarAmount() {
        return this.rentalCarAmount;
    }

    public void setRentalCarAmount(KualiDecimal rentalCarAmount) {
        this.rentalCarAmount = rentalCarAmount;
    }

    public void setRentalCarAmount(String rentalCarAmount) {
        this.rentalCarAmount = new KualiDecimal(rentalCarAmount);
    }

    @Column(name="RNT_CAR_NMR_DAYS", length=3, nullable=true)
    public String getRentalCarNumberOfDays() {
        return this.rentalCarNumberOfDays;
    }

    public void setRentalCarNumberOfDays(String rentalCarNumberOfDays) {
        this.rentalCarNumberOfDays = rentalCarNumberOfDays;
    }

    @Column(name="RNT_CAR_CO_NM", length=30, nullable=true)
    public String getRentalCarCompanyName() {
        return this.rentalCarCompanyName;
    }

    public void setRentalCarCompanyName(String rentalCarCompanyName) {
        this.rentalCarCompanyName = rentalCarCompanyName;
    }

    @Column(name="RNT_CAR_OPN_DT", nullable=true)
    public Date getRentalCarOpenDate() {
        return this.rentalCarOpenDate;
    }

    public void setRentalCarOpenDate(Date rentalCarOpenDate) {
        this.rentalCarOpenDate = rentalCarOpenDate;
    }

    @Column(name="RNT_CAR_CLOSE_DT", nullable=true)
    public Date getRentalCarCloseDate() {
        return this.rentalCarCloseDate;
    }

    public void setRentalCarCloseDate(Date rentalCarCloseDate) {
        this.rentalCarCloseDate = rentalCarCloseDate;
    }

    @Column(name="RNT_CAR_FUEL_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarFuelAmount() {
        return this.rentalCarFuelAmount;
    }

    public void setRentalCarFuelAmount(KualiDecimal rentalCarFuelAmount) {
        this.rentalCarFuelAmount = rentalCarFuelAmount;
    }

    public void setRentalCarFuelAmount(String rentalCarFuelAmount) {
        this.rentalCarFuelAmount = new KualiDecimal(rentalCarFuelAmount);
    }

    @Column(name="RNT_CAR_ADD_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarAdditionalAmount() {
        return this.rentalCarAdditionalAmount;
    }

    public void setRentalCarAdditionalAmount(KualiDecimal rentalCarAdditionalAmount) {
        this.rentalCarAdditionalAmount = rentalCarAdditionalAmount;
    }

    public void setRentalCarAdditionalAmount(String rentalCarAdditionalAmount) {
        this.rentalCarAdditionalAmount = new KualiDecimal(rentalCarAdditionalAmount);
    }

    @Column(name="RNT_CAR_TX_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarTaxAmount() {
        return this.rentalCarTaxAmount;
    }

    public void setRentalCarTaxAmount(KualiDecimal rentalCarTaxAmount) {
        this.rentalCarTaxAmount = rentalCarTaxAmount;
    }

    public void setRentalCarTaxAmount(String rentalCarTaxAmount) {
        this.rentalCarTaxAmount = new KualiDecimal(rentalCarTaxAmount);
    }

    @Column(name="RNT_CAR_SRCHRG_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarSurchargeAmount() {
        return this.rentalCarSurchargeAmount;
    }

    public void setRentalCarSurchargeAmount(KualiDecimal rentalCarSurchargeAmount) {
        this.rentalCarSurchargeAmount = rentalCarSurchargeAmount;
    }

    public void setRentalCarSurchargeAmount(String rentalCarSurchargeAmount) {
        this.rentalCarSurchargeAmount = new KualiDecimal(rentalCarSurchargeAmount);
    }

    @Column(name="RNT_CAR_GOVR_SRCHRG_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarGovernmentSurchargeAmount() {
        return this.rentalCarGovernmentSurchargeAmount;
    }

    public void setRentalCarGovernmentSurchargeAmount(KualiDecimal rentalCarGovernmentSurchargeAmount) {
        this.rentalCarGovernmentSurchargeAmount = rentalCarGovernmentSurchargeAmount;
    }

    public void setRentalCarGovernmentSurchargeAmount(String rentalCarGovernmentSurchargeAmount) {
        this.rentalCarGovernmentSurchargeAmount = new KualiDecimal(rentalCarGovernmentSurchargeAmount);
    }

    @Column(name="RNT_CAR_BILL_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRentalCarBillAmount() {
        return this.rentalCarBillAmount;
    }

    public void setRentalCarBillAmount(KualiDecimal rentalCarBillAmount) {
        this.rentalCarBillAmount = rentalCarBillAmount;
    }

    public void setRentalCarBillAmount(String rentalCarBillAmount) {
        this.rentalCarBillAmount = new KualiDecimal(rentalCarBillAmount);
    }

    @Column(name="RNT_CAR_DTL", length=100, nullable=true)
    public String getRentalCarDetailText() {
        return this.rentalCarDetailText;
    }

    public void setRentalCarDetailText(String rentalCarDetailText) {
        this.rentalCarDetailText = rentalCarDetailText;
    }

    @Column(name="REG_CO_NM", length=50, nullable=true)
    public String getRegistrationCompanyName() {
        return this.registrationCompanyName;
    }

    public void setRegistrationCompanyName(String registrationCompanyName) {
        this.registrationCompanyName = registrationCompanyName;
    }

    @Column(name="REG_AMT", precision=8, scale=2, nullable=true)
    public KualiDecimal getRegistrationAmount() {
        return this.registrationAmount;
    }

    public void setRegistrationAmount(KualiDecimal registrationAmount) {
        this.registrationAmount = registrationAmount;
    }

    public void setRegistrationAmount(String registrationAmount) {
        this.registrationAmount = new KualiDecimal(registrationAmount);
    }

    @Column(name="TRANS_POST_DT", nullable=true)
    public Date getTransactionPostingDate() {
        return this.transactionPostingDate;
    }

    public void setTransactionPostingDate(Date transactionPostingDate) {
        this.transactionPostingDate = transactionPostingDate;
    }

    @Column(name="OBJ_VER_NBR", nullable=true)
    public String getObjectVerNumber() {
        return this.objectVerNumber;
    }

    public void setObjectVerNumber(String objectVerNumber) {
        this.objectVerNumber = objectVerNumber;
    }

    @Column(name="CREATION_TS", nullable=true)
    public Timestamp getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(Timestamp creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @Column(name="PROCESSING_TS", nullable=true)
    public Timestamp getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public void setProcessingTimestamp(Timestamp processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    @Column(name="MV_TO_HISTORY", length=1, nullable=true)
    public boolean getMoveToHistoryIndicator() {
        return this.moveToHistoryIndicator;
    }

    public void setMoveToHistoryIndicator(boolean moveToHistoryIndicator) {
        this.moveToHistoryIndicator = moveToHistoryIndicator;
    }

    public TemConstants.ExpenseTypeMetaCategory getExpenseTypeCategory() {
        TemConstants.ExpenseTypeMetaCategory expenseTypeCategory = null;
        if (StringUtils.isNotEmpty((String)this.getAirTicketNumber())) {
            expenseTypeCategory = TemConstants.ExpenseTypeMetaCategory.AIRFARE;
        } else if (StringUtils.isNotEmpty((String)this.getLodgingItineraryNumber())) {
            expenseTypeCategory = TemConstants.ExpenseTypeMetaCategory.LODGING;
        } else if (StringUtils.isNotEmpty((String)this.getRentalCarItineraryNumber())) {
            expenseTypeCategory = TemConstants.ExpenseTypeMetaCategory.RENTAL_CAR;
        }
        return expenseTypeCategory;
    }

    public TemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(TemProfile profile) {
        this.profile = profile;
    }

    public String getImportBy() {
        return this.importBy;
    }

    public TemConstants.ExpenseImport getExpenseImport() {
        return TemConstants.ExpenseImport.getExpenseImportByCode(this.importBy);
    }

    public void setImportBy(String importBy) {
        this.importBy = importBy;
    }

    public CreditCardAgency getCreditCardAgency() {
        return this.creditCardAgency;
    }

    public void setCreditCardAgency(CreditCardAgency creditCardAgency) {
        this.creditCardAgency = creditCardAgency;
        if (creditCardAgency != null) {
            this.setCreditCardOrAgencyCode(creditCardAgency.getCreditCardOrAgencyCode());
            this.setAgency(creditCardAgency.getCreditCardOrAgencyName());
        }
    }

    public String getSearchChartOfAccountsCode() {
        return this.searchChartOfAccountsCode;
    }

    public void setSearchChartOfAccountsCode(String searchChartOfAccountsCode) {
        this.searchChartOfAccountsCode = searchChartOfAccountsCode;
    }

    public String getSearchAccountNumber() {
        return this.searchAccountNumber;
    }

    public void setSearchAccountNumber(String searchAccountNumber) {
        this.searchAccountNumber = searchAccountNumber;
    }

    public String getSearchSubAccountNumber() {
        return this.searchSubAccountNumber;
    }

    public void setSearchSubAccountNumber(String searchSubAccountNumber) {
        this.searchSubAccountNumber = searchSubAccountNumber;
    }

    public Chart getSearchChart() {
        return this.searchChart;
    }

    public void setSearchChart(Chart searchChart) {
        this.searchChart = searchChart;
    }

    public Account getSearchAccount() {
        return this.searchAccount;
    }

    public void setSearchAccount(Account searchAccount) {
        this.searchAccount = searchAccount;
    }

    public SubAccount getSearchSubAccount() {
        return this.searchSubAccount;
    }

    public void setSearchSubAccount(SubAccount searchSubAccount) {
        this.searchSubAccount = searchSubAccount;
    }

    public String getStagingFileName() {
        return this.stagingFileName;
    }

    public void setStagingFileName(String stagingFileName) {
        this.stagingFileName = stagingFileName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Boolean getManualCreated() {
        return this.manualCreated;
    }

    public void setManualCreated(Boolean manualCreated) {
        this.manualCreated = manualCreated;
    }

    public Integer getCopiedFromId() {
        return this.copiedFromId;
    }

    public void setCopiedFromId(Integer copiedFromId) {
        this.copiedFromId = copiedFromId;
    }

    public AgencyServiceFee getAgencyServiceFee() {
        return this.agencyServiceFee;
    }

    public void setAgencyServiceFee(AgencyServiceFee agencyServiceFee) {
        this.agencyServiceFee = agencyServiceFee;
    }

    public String getItineraryDataString() {
        String itineraryData = StringUtils.isNotEmpty((String)this.getAirTicketNumber()) ? TemConstants.ExpenseTypeMetaCategory.AIRFARE.getName() + "-" + this.getAirTicketNumber() : (StringUtils.isNotEmpty((String)this.getLodgingItineraryNumber()) ? TemConstants.ExpenseTypeMetaCategory.LODGING.getName() + "-" + this.getLodgingItineraryNumber() : (StringUtils.isNotEmpty((String)this.getRentalCarItineraryNumber()) ? TemConstants.ExpenseTypeMetaCategory.RENTAL_CAR.getName() + "-" + this.getRentalCarItineraryNumber() : ""));
        return itineraryData;
    }
}

