/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.tem.businessobject.CorporateCardPseudoNumber;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.document.CardApplicationDocument;
import org.kuali.kfs.module.tem.document.CardApplicationDocumentBase;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class TemCorporateCardApplicationDocument
extends CardApplicationDocumentBase
implements CardApplicationDocument {
    protected static Logger LOG = Logger.getLogger(TemCorporateCardApplicationDocument.class);
    private String pseudoNumber;
    private boolean departmentHeadAgreement;

    public String getPseudoNumber() {
        return this.pseudoNumber;
    }

    public void setPseudoNumber(String pseudoNumber) {
        this.pseudoNumber = pseudoNumber;
    }

    public boolean isDepartmentHeadAgreement() {
        return this.departmentHeadAgreement;
    }

    public void setDepartmentHeadAgreement(boolean departmentHeadAgreement) {
        this.departmentHeadAgreement = departmentHeadAgreement;
    }

    @Override
    public String getUserAgreementText() {
        return this.getConfigurationService().getPropertyValueAsString("message.tem.corp.card.document.user.agreement");
    }

    public String getDepartmentHeadAgreementText() {
        return this.getConfigurationService().getPropertyValueAsString("message.tem.corp.card.document.departmentHead.agreement");
    }

    @Override
    public void applyToBank() {
        boolean generateNumber = this.getParameterService().getParameterValueAsBoolean(TemCorporateCardApplicationDocument.class, "GENERATE_CREDIT_CARD_NUMBER_IND");
        if (generateNumber) {
            Long number = this.getSequenceAccessorService().getNextAvailableSequenceNumber("TEM_CORP_CARD_PSEUDO_NUM_SEQ");
            String pseudoNumberStr = this.zeroBuffer(number);
            CorporateCardPseudoNumber pseudoNumber = new CorporateCardPseudoNumber();
            this.getBusinessObjectService().save((PersistableBusinessObject)pseudoNumber);
            this.setPseudoNumber(pseudoNumberStr);
            this.getDocumentDao().save((Document)this);
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        DocumentStatus status = this.getDocumentHeader().getWorkflowDocument().getStatus();
        if (status.equals((Object)DocumentStatus.FINAL) || status.equals((Object)DocumentStatus.PROCESSED)) {
            TemProfileAccount profileAccount = new TemProfileAccount();
            profileAccount.setAccountNumber(this.getPseudoNumber());
            Date now = new Date();
            profileAccount.setEffectiveDate(new java.sql.Date(now.getTime()));
            String code = this.getParameterService().getParameterValueAsString(TemCorporateCardApplicationDocument.class, "CORPORATE_CARD_CODE");
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("creditCardOrAgencyCode", code);
            List creditCardAgencyList = (List)this.getBusinessObjectService().findMatching(CreditCardAgency.class, fieldValues);
            CreditCardAgency creditCardAgency = (CreditCardAgency)((Object)creditCardAgencyList.get(0));
            profileAccount.setCreditCardAgency(creditCardAgency);
            profileAccount.setCreditCardOrAgencyCode(creditCardAgency.getCreditCardOrAgencyCode());
            profileAccount.setName(creditCardAgency.getCreditCardOrAgencyName());
            profileAccount.setActive(true);
            String text = this.getConfigurationService().getPropertyValueAsString("message.tem.card.note.text");
            DateFormatter formatter = new DateFormatter();
            String note = MessageFormat.format(text, formatter.format((Object)now), this.getDocumentHeader().getDocumentNumber());
            profileAccount.setNote(note);
            this.getTemProfile().getAccounts().add(profileAccount);
            this.getBusinessObjectService().save((PersistableBusinessObject)this.temProfile);
        }
    }
}

