/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelPaymentsHelperService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.pdp.PdpConstants;
import org.kuali.kfs.pdp.businessobject.PaymentAccountDetail;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.businessobject.PaymentGroup;
import org.kuali.kfs.pdp.businessobject.PaymentNoteText;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelPaymentsHelperServiceImpl
implements TravelPaymentsHelperService {
    Logger LOG = Logger.getLogger(TravelPaymentsHelperServiceImpl.class);
    protected PersonService personService;
    protected WorkflowDocumentService workflowDocumentService;
    protected PaymentSourceHelperService paymentSourceHelperService;
    protected TravelerService travelerService;

    @Override
    public String findCampusForDocument(TravelDocument document, Map<String, String> initiatorCampuses) {
        try {
            WorkflowDocument workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            return this.findCampusForInitiator(workflowDocument.getInitiatorPrincipalId(), initiatorCampuses);
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Could not load document: " + document.getDocumentNumber(), we);
        }
    }

    protected String findCampusForInitiator(String initiatorPrincipalId, Map<String, String> initiatorCampuses) {
        if (!StringUtils.isBlank((String)initiatorCampuses.get(initiatorPrincipalId))) {
            return initiatorCampuses.get(initiatorPrincipalId);
        }
        Person initiatorPerson = this.getPersonService().getPerson(initiatorPrincipalId);
        String campusCode = initiatorPerson.getCampusCode();
        if (!StringUtils.isBlank((String)campusCode)) {
            initiatorCampuses.put(initiatorPrincipalId, campusCode);
        }
        return campusCode;
    }

    @Override
    public Person getInitiator(TravelDocument document) {
        try {
            WorkflowDocument workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            return this.getPersonService().getPerson(workflowDocument.getInitiatorPrincipalId());
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Could not load document: " + document.getDocumentNumber(), we);
        }
    }

    @Override
    public PaymentGroup buildGenericPaymentGroup(TravelerDetail traveler, TemProfile travelerProfile, TravelPayment payment, String bankCode) {
        PaymentGroup pg = new PaymentGroup();
        pg.setCombineGroups(Boolean.TRUE);
        pg.setCampusAddress(Boolean.FALSE);
        pg.setCity(traveler.getCityName());
        pg.setCountry(traveler.getCountryCode());
        pg.setLine1Address(traveler.getStreetAddressLine1());
        pg.setLine2Address(traveler.getStreetAddressLine2());
        pg.setPayeeName(traveler.getFirstName() + " " + traveler.getLastName());
        pg.setState(traveler.getStateCode());
        pg.setZipCd(traveler.getZipCode());
        pg.setPaymentDate(payment.getDueDate());
        pg.setProcessImmediate(Boolean.valueOf(payment.isImmediatePaymentIndicator()));
        pg.setPymtAttachment(Boolean.valueOf(payment.isAttachmentCode()));
        pg.setPymtSpecialHandling(Boolean.valueOf(payment.isSpecialHandlingCode()));
        pg.setNraPayment(Boolean.valueOf(payment.isAlienPaymentCode()));
        pg.setBankCode(bankCode);
        pg.setPaymentStatusCode(PdpConstants.PaymentStatusCodes.OPEN);
        pg.setTaxablePayment(Boolean.FALSE);
        if (this.getTravelerService().isEmployee(traveler)) {
            pg.setPayeeId(travelerProfile.getEmployeeId());
            pg.setPayeeIdTypeCd(PdpConstants.PayeeIdTypeCodes.EMPLOYEE);
            pg.setEmployeeIndicator(Boolean.TRUE);
            pg.setTaxablePayment(Boolean.FALSE);
        } else {
            pg.setPayeeId(traveler.getCustomerNumber());
            pg.setPayeeIdTypeCd(PdpConstants.PayeeIdTypeCodes.CUSTOMER);
        }
        return pg;
    }

    @Override
    public PaymentDetail buildGenericPaymentDetail(DocumentHeader documentHeader, Date processDate, TravelPayment travelPayment, Person initiator, String achCheckDocumentType) {
        String text;
        PaymentDetail pd = new PaymentDetail();
        if (StringUtils.isNotEmpty((String)documentHeader.getOrganizationDocumentNumber())) {
            pd.setOrganizationDocNbr(documentHeader.getOrganizationDocumentNumber());
        }
        pd.setCustPaymentDocNbr(documentHeader.getDocumentNumber());
        pd.setInvoiceDate(new Date(processDate.getTime()));
        pd.setOrigInvoiceAmount(travelPayment.getCheckTotalAmount());
        pd.setInvTotDiscountAmount(KualiDecimal.ZERO);
        pd.setInvTotOtherCreditAmount(KualiDecimal.ZERO);
        pd.setInvTotOtherDebitAmount(KualiDecimal.ZERO);
        pd.setInvTotShipAmount(KualiDecimal.ZERO);
        pd.setNetPaymentAmount(travelPayment.getCheckTotalAmount());
        pd.setPrimaryCancelledPayment(Boolean.FALSE);
        pd.setFinancialDocumentTypeCode(achCheckDocumentType);
        pd.setFinancialSystemOriginCode("01");
        int line = 0;
        PaymentNoteText pnt = new PaymentNoteText();
        pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
        pnt.setCustomerNoteText("Info: " + initiator.getPrincipalName() + " " + initiator.getPhoneNumber());
        pd.addNote(pnt);
        if (StringUtils.isNotEmpty((String)travelPayment.getSpecialHandlingPersonName())) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
            pnt.setCustomerNoteText("Send Check To: " + travelPayment.getSpecialHandlingPersonName());
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Creating special handling person name note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        if (StringUtils.isNotEmpty((String)travelPayment.getSpecialHandlingLine1Addr())) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
            pnt.setCustomerNoteText(travelPayment.getSpecialHandlingLine1Addr());
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Creating special handling address 1 note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        if (StringUtils.isNotEmpty((String)travelPayment.getSpecialHandlingLine2Addr())) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
            pnt.setCustomerNoteText(travelPayment.getSpecialHandlingLine2Addr());
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Creating special handling address 2 note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        if (StringUtils.isNotEmpty((String)travelPayment.getSpecialHandlingCityName())) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
            pnt.setCustomerNoteText(travelPayment.getSpecialHandlingCityName() + ", " + travelPayment.getSpecialHandlingStateCode() + " " + travelPayment.getSpecialHandlingZipCode());
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Creating special handling city note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        if (travelPayment.isAttachmentCode()) {
            pnt = new PaymentNoteText();
            pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
            pnt.setCustomerNoteText("Attachment Included");
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("create attachment note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        if (!StringUtils.isBlank((String)(text = travelPayment.getCheckStubText()))) {
            pnt = this.getPaymentSourceHelperService().buildNoteForCheckStubText(text, line);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Creating check stub text note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        return pd;
    }

    @Override
    public List<PaymentAccountDetail> buildGenericPaymentAccountDetails(List<? extends AccountingLine> accountingLines) {
        ArrayList<PaymentAccountDetail> details = new ArrayList<PaymentAccountDetail>();
        for (AccountingLine accountingLine : accountingLines) {
            PaymentAccountDetail pad = new PaymentAccountDetail();
            pad.setFinChartCode(accountingLine.getChartOfAccountsCode());
            pad.setAccountNbr(accountingLine.getAccountNumber());
            if (!StringUtils.isBlank((String)accountingLine.getSubAccountNumber())) {
                pad.setSubAccountNbr(accountingLine.getSubAccountNumber());
            } else {
                pad.setSubAccountNbr(KFSConstants.getDashSubAccountNumber());
            }
            pad.setFinObjectCode(accountingLine.getFinancialObjectCode());
            if (!StringUtils.isBlank((String)accountingLine.getFinancialSubObjectCode())) {
                pad.setFinSubObjectCode(accountingLine.getFinancialSubObjectCode());
            } else {
                pad.setFinSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            }
            if (!StringUtils.isBlank((String)accountingLine.getOrganizationReferenceId())) {
                pad.setOrgReferenceId(accountingLine.getOrganizationReferenceId());
            }
            if (!StringUtils.isBlank((String)accountingLine.getProjectCode())) {
                pad.setProjectCode(accountingLine.getProjectCode());
            } else {
                pad.setProjectCode(KFSConstants.getDashProjectCode());
            }
            pad.setAccountNetAmount(accountingLine.getAmount());
            details.add(pad);
        }
        return details;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public PaymentSourceHelperService getPaymentSourceHelperService() {
        return this.paymentSourceHelperService;
    }

    public void setPaymentSourceHelperService(PaymentSourceHelperService paymentSourceHelperService) {
        this.paymentSourceHelperService = paymentSourceHelperService;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }
}

