/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;

public class CreditCardAgencyRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        super.processCustomSaveDocumentBusinessRules(document);
        CreditCardAgency creditCardAgency = (CreditCardAgency)document.getNewMaintainableObject().getBusinessObject();
        this.checkOnlyCorpCardsCanMakePayments(creditCardAgency);
        this.checkCorporateCardAgencyGotBank(creditCardAgency);
        this.checkCorporateCardAgencyHasVendor(creditCardAgency);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        CreditCardAgency creditCardAgency = (CreditCardAgency)document.getNewMaintainableObject().getBusinessObject();
        result &= this.checkOnlyCorpCardsCanMakePayments(creditCardAgency);
        result &= this.checkCorporateCardAgencyGotBank(creditCardAgency);
        return result &= this.checkCorporateCardAgencyHasVendor(creditCardAgency);
    }

    protected boolean isCorporateCardAgency(CreditCardAgency creditCardAgency) {
        return !StringUtils.isBlank((String)creditCardAgency.getTravelCardTypeCode()) && creditCardAgency.getTravelCardTypeCode().equals("CORP");
    }

    protected boolean checkOnlyCorpCardsCanMakePayments(CreditCardAgency creditCardAgency) {
        if (!this.isCorporateCardAgency(creditCardAgency) && creditCardAgency.isPaymentIndicator().booleanValue()) {
            this.putFieldError("paymentIndicator", "error.creditCardAgency.payment.indicator.not.allowed");
            return false;
        }
        return true;
    }

    protected boolean checkCorporateCardAgencyGotBank(CreditCardAgency creditCardAgency) {
        String bankCodeLabel = this.getDataDictionaryService().getAttributeErrorLabel(CreditCardAgency.class, "bankCode");
        if (this.isCorporateCardAgency(creditCardAgency) && creditCardAgency.isPaymentIndicator().booleanValue() && StringUtils.isBlank((String)creditCardAgency.getBankCode())) {
            this.putFieldError("bankCode", "error.creditCardAgency.corporate.card.agency.bank.code.required", new String[]{bankCodeLabel});
            return false;
        }
        if (!StringUtils.isBlank((String)creditCardAgency.getBankCode())) {
            if (ObjectUtils.isNull((Object)creditCardAgency.getBank()) || !StringUtils.equals((String)creditCardAgency.getBankCode(), (String)creditCardAgency.getBank().getBankCode())) {
                creditCardAgency.refreshReferenceObject("bank");
            }
            if (ObjectUtils.isNull((Object)creditCardAgency.getBank()) || !creditCardAgency.getBank().isActive()) {
                this.putFieldError("bankCode", "error.existence", new String[]{bankCodeLabel});
                return false;
            }
        }
        return true;
    }

    protected boolean checkCorporateCardAgencyHasVendor(CreditCardAgency creditCardAgency) {
        String vendorNumberLabel = this.getDataDictionaryService().getAttributeErrorLabel(CreditCardAgency.class, "vendorNumber");
        if (this.isCorporateCardAgency(creditCardAgency) && creditCardAgency.isPaymentIndicator().booleanValue() && (creditCardAgency.getVendorHeaderGeneratedIdentifier() == null || creditCardAgency.getVendorDetailAssignedIdentifier() == null)) {
            this.putFieldError("vendorNumber", "error.creditCardAgency.corporate.card.agency.vendor.number.required", new String[]{vendorNumberLabel});
            return false;
        }
        if (creditCardAgency.getVendorHeaderGeneratedIdentifier() != null && creditCardAgency.getVendorDetailAssignedIdentifier() != null) {
            if (ObjectUtils.isNull((Object)creditCardAgency.getVendorDetail()) || creditCardAgency.getVendorDetail().getVendorHeaderGeneratedIdentifier() != creditCardAgency.getVendorHeaderGeneratedIdentifier() || creditCardAgency.getVendorDetail().getVendorDetailAssignedIdentifier() != creditCardAgency.getVendorDetailAssignedIdentifier()) {
                creditCardAgency.refreshReferenceObject("vendorDetail");
            }
            if (ObjectUtils.isNull((Object)creditCardAgency.getVendorDetail()) || !creditCardAgency.getVendorDetail().isActiveIndicator()) {
                this.putFieldError("vendorNumber", "error.existence", new String[]{vendorNumberLabel});
                return false;
            }
        }
        return true;
    }
}

