/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAmountSummation;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ExpenseTypeObjectCodeRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        ExpenseTypeObjectCode bo = (ExpenseTypeObjectCode)document.getNewMaintainableObject().getBusinessObject();
        result &= this.checkValidValues(bo);
        result &= this.validMaximumAmount(bo);
        result &= this.validSummationCode(bo);
        result &= this.validTripTypeByDocumentType(bo);
        result &= this.canExpenseTypeObjectCodeBeChosen(bo);
        if (document.isNew()) {
            result &= this.checkRecordIsUnique(bo);
        }
        return result;
    }

    protected boolean checkValidValues(ExpenseTypeObjectCode expenseTypeObjectCode) {
        String label;
        boolean success = true;
        if (!this.validDocumentType(expenseTypeObjectCode.getDocumentTypeName())) {
            success = false;
            label = this.getDataDictionaryService().getAttributeLabel(ExpenseTypeObjectCode.class, "documentTypeName");
            GlobalVariables.getMessageMap().putError("documentTypeName", "error.existence", new String[]{label});
        }
        if (!this.validTripType(expenseTypeObjectCode.getTripTypeCode())) {
            success = false;
            label = this.getDataDictionaryService().getAttributeLabel(ExpenseTypeObjectCode.class, "tripTypeCode");
            GlobalVariables.getMessageMap().putError("tripTypeCode", "error.existence", new String[]{label});
        }
        if (!this.validTravelerType(expenseTypeObjectCode.getTravelerTypeCode())) {
            success = false;
            label = this.getDataDictionaryService().getAttributeLabel(ExpenseTypeObjectCode.class, "travelerTypeCode");
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.existence", new String[]{label});
        }
        return success;
    }

    protected boolean validDocumentType(String documentTypeName) {
        if ("TT".equals(documentTypeName)) {
            return true;
        }
        if ("TRV".equals(documentTypeName)) {
            return true;
        }
        if ("RELO".equals(documentTypeName)) {
            return true;
        }
        if ("ENT".equals(documentTypeName)) {
            return true;
        }
        if ("TA".equals(documentTypeName)) {
            return true;
        }
        return "TR".equals(documentTypeName);
    }

    protected boolean validTripType(String tripTypeCode) {
        if (StringUtils.isBlank((String)tripTypeCode)) {
            return false;
        }
        if ("All".equals(tripTypeCode)) {
            return true;
        }
        TripType tripType = (TripType)this.getBoService().findBySinglePrimaryKey(TripType.class, (Object)tripTypeCode);
        return tripType != null;
    }

    protected boolean validTravelerType(String travelerTypeCode) {
        if (StringUtils.isBlank((String)travelerTypeCode)) {
            return false;
        }
        if ("All".equals(travelerTypeCode)) {
            return true;
        }
        TravelerType travelerType = (TravelerType)this.getBoService().findBySinglePrimaryKey(TravelerType.class, (Object)travelerTypeCode);
        return travelerType != null;
    }

    protected boolean validMaximumAmount(ExpenseTypeObjectCode expenseTypeObjectCode) {
        boolean success = true;
        if (expenseTypeObjectCode.getMaximumAmount() != null && KualiDecimal.ZERO.isGreaterEqual((AbstractKualiDecimal)expenseTypeObjectCode.getMaximumAmount())) {
            success = false;
            GlobalVariables.getMessageMap().putError("maximumAmount", "error.etoc.invalid.maximum.amount", new String[0]);
        }
        return success;
    }

    protected boolean validSummationCode(ExpenseTypeObjectCode expenseTypeObjectCode) {
        boolean success = true;
        if (!(StringUtils.isBlank((String)expenseTypeObjectCode.getMaximumAmountSummationCode()) || ExpenseTypeAmountSummation.PER_DAILY.getCode().equals(expenseTypeObjectCode.getMaximumAmountSummationCode()) || ExpenseTypeAmountSummation.PER_OCCURRENCE.getCode().equals(expenseTypeObjectCode.getMaximumAmountSummationCode()))) {
            success = false;
            GlobalVariables.getMessageMap().putError("maximumAmountSummationCode", "error.etoc.invalid.summation.code", new String[]{expenseTypeObjectCode.getMaximumAmountSummationCode()});
        }
        return success;
    }

    protected boolean validTripTypeByDocumentType(ExpenseTypeObjectCode expenseTypeObjectCode) {
        boolean success = true;
        if (("ENT".equals(expenseTypeObjectCode.getDocumentTypeName()) || "RELO".equals(expenseTypeObjectCode.getDocumentTypeName())) && !"All".equals(expenseTypeObjectCode.getTripTypeCode())) {
            success = false;
            GlobalVariables.getMessageMap().putError("tripTypeCode", "error.etoc.invalid.trip.type.considering.document.type", new String[]{expenseTypeObjectCode.getDocumentTypeName(), "All"});
        }
        return success;
    }

    protected boolean checkRecordIsUnique(ExpenseTypeObjectCode expenseTypeObjectCode) {
        boolean success = true;
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("documentTypeName", expenseTypeObjectCode.getDocumentTypeName());
        fields.put("travelerTypeCode", expenseTypeObjectCode.getTravelerTypeCode());
        fields.put("tripTypeCode", expenseTypeObjectCode.getTripTypeCode());
        fields.put("expenseTypeCode", expenseTypeObjectCode.getExpenseTypeCode());
        int count = this.getBoService().countMatching(ExpenseTypeObjectCode.class, fields);
        if (count > 0) {
            success = false;
            GlobalVariables.getMessageMap().putError("expenseTypeCode", "error.etoc.record.not.unique", new String[]{expenseTypeObjectCode.getExpenseTypeCode(), expenseTypeObjectCode.getDocumentTypeName(), expenseTypeObjectCode.getTravelerTypeCode(), expenseTypeObjectCode.getTripTypeCode()});
        }
        return success;
    }

    protected boolean canExpenseTypeObjectCodeBeChosen(ExpenseTypeObjectCode expenseTypeObjectCode) {
        return true;
    }
}

