/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class TravelAuthorizationDocumentPreRules
extends PromptBeforeValidationBase {
    public boolean doPrompts(Document document) {
        boolean foundMatchingTrips = false;
        TravelAuthorizationDocument authorizationDocument = (TravelAuthorizationDocument)document;
        List<String> documentIds = ((TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class)).findMatchingTrips(authorizationDocument);
        if (ObjectUtils.isNotNull(documentIds) && !documentIds.isEmpty()) {
            foundMatchingTrips = true;
        }
        boolean shouldAskQuestion = false;
        String proceed = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("trvl.document.proceed.text");
        String question = "";
        if (foundMatchingTrips) {
            question = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("trvl.duplicate.trip.question.text");
            shouldAskQuestion = true;
        }
        if (shouldAskQuestion) {
            boolean userClickedYes = super.askOrAnalyzeYesNoQuestion("AUTHORIZATION_WARNING", question + " " + documentIds.toString() + " " + proceed);
            if (!userClickedYes) {
                this.event.setActionForwardName("basic");
            }
            return userClickedYes;
        }
        return true;
    }
}

