/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class TravelPaymentSpecialHandlingStateCodeValidation
extends GenericValidation {
    protected TravelPayment travelPaymentForValidation;
    protected StateService stateService;
    protected DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        State state;
        boolean isValid = true;
        MessageMap errors = GlobalVariables.getMessageMap();
        errors.addToErrorPath("document.travelPayment");
        String countryCode = this.getTravelPaymentForValidation().getSpecialHandlingCountryCode();
        String stateCode = this.getTravelPaymentForValidation().getSpecialHandlingStateCode();
        if (this.getTravelPaymentForValidation().isSpecialHandlingCode() && StringUtils.isNotBlank((String)stateCode) && StringUtils.isNotBlank((String)countryCode) && (state = this.getStateService().getState(countryCode, stateCode)) == null) {
            String label = this.getDataDictionaryService().getAttributeLabel(TravelPayment.class, "specialHandlingStateCode");
            String propertyPath = ".specialHandlingStateCode";
            errors.putError(".specialHandlingStateCode", "error.existence", new String[]{label});
            isValid = false;
        }
        errors.removeFromErrorPath("document.travelPayment");
        return isValid;
    }

    public TravelPayment getTravelPaymentForValidation() {
        return this.travelPaymentForValidation;
    }

    public void setTravelPaymentForValidation(TravelPayment travelPaymentForValidation) {
        this.travelPaymentForValidation = travelPaymentForValidation;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

