/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadValidationService;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PerDiemLoadValidationServiceImpl
implements PerDiemLoadValidationService {
    private static Logger LOG = Logger.getLogger(PerDiemLoadValidationServiceImpl.class);
    private DictionaryValidationService dictionaryValidationService;
    private PerDiemService perDiemService;

    @Override
    public <T extends PerDiem> boolean validate(List<T> perDiemList) {
        MessageMap messageMap = GlobalVariables.getMessageMap();
        for (PerDiem perDiem : perDiemList) {
            List<Message> errorMessages = this.validate(perDiem);
            this.populateMessageMap(messageMap, errorMessages);
            if (!ObjectUtils.isNotNull((Object)messageMap) || !messageMap.hasErrors()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends PerDiem> List<Message> validate(T perDiem) {
        Message message;
        ArrayList<Message> meesageList = new ArrayList<Message>();
        this.getDictionaryValidationService().isBusinessObjectValid(perDiem);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        if (messageMap.hasErrors()) {
            message = this.translateErrorsFromErrorMap(messageMap);
            meesageList.addAll((Collection<Message>)message);
            messageMap.clearErrorMessages();
        }
        if (!this.isValidMealsAndIncidentals(perDiem)) {
            message = MessageBuilder.buildMessageWithPlaceHolder((String)"error.batch.mealIncidental.nonPositiveAmount", (Object[])new Object[]{perDiem.getPrimaryDestination().getRegion().getRegionName(), perDiem.getPrimaryDestination(), perDiem.getLineNumber(), perDiem.getMealsAndIncidentals()});
            meesageList.add(message);
        }
        return meesageList;
    }

    protected boolean isValidMealsAndIncidentals(PerDiem perDiem) {
        KualiDecimal mealsAndIncidentals = perDiem.getMealsAndIncidentals();
        return ObjectUtils.isNotNull((Object)mealsAndIncidentals) && mealsAndIncidentals.isPositive();
    }

    protected void populateMessageMap(MessageMap messageMap, List<Message> errorMessages) {
        for (Message message : errorMessages) {
            messageMap.putError("GLOBAL_ERRORS", "error.custom", new String[]{message.getMessage()});
        }
    }

    protected List<Message> translateErrorsFromErrorMap(MessageMap errorMap) {
        ArrayList<Message> errors = new ArrayList<Message>();
        for (String errorKey : errorMap.getPropertiesWithErrors()) {
            for (Object message : errorMap.getMessages(errorKey)) {
                ErrorMessage errorMessage = (ErrorMessage)message;
                Message messageWithPlaceHolder = MessageBuilder.buildMessageWithPlaceHolder((String)errorMessage.getErrorKey(), (Object[])errorMessage.getMessageParameters());
                errors.add(messageWithPlaceHolder);
            }
        }
        return errors;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public PerDiemService getPerDiemService() {
        return this.perDiemService;
    }

    public void setPerDiemService(PerDiemService perDiemService) {
        this.perDiemService = perDiemService;
    }
}

