/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.TemProfileExportStep;
import org.kuali.kfs.module.tem.batch.service.TemProfileExportService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TemProfileExportServiceImpl
implements TemProfileExportService {
    private static Logger LOG = Logger.getLogger(TemProfileExportServiceImpl.class);
    protected TemProfileService temProfileService;
    protected PersonService personService;
    protected ParameterService parameterService;
    protected DateTimeService dateTimeService;
    private String fileDirectoryName;
    private String fileName;

    @Override
    public void exportProfile() {
        List<TemProfile> profiles = this.temProfileService.getAllActiveTemProfile();
        LOG.info((Object)"Accessing EXPORT_FILE_FORMAT system parameter for file extension");
        String extension = this.parameterService.getParameterValueAsString(TemProfileExportStep.class, "EXPORT_FILE_FORMAT");
        String exportFile = this.fileDirectoryName + File.separator + this.fileName + "." + extension;
        PrintStream OUTPUT_GLE_FILE_ps = null;
        try {
            OUTPUT_GLE_FILE_ps = new PrintStream(exportFile);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
        if (extension.equalsIgnoreCase("xml")) {
            try {
                OUTPUT_GLE_FILE_ps.printf("%s\n", this.generateXMLDoc(profiles));
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex.toString(), ex);
            }
            catch (TransformerException ex) {
                throw new RuntimeException(ex.toString(), ex);
            }
        } else {
            OUTPUT_GLE_FILE_ps.printf("%s\n", this.dateTimeService.toDateTimeString(this.dateTimeService.getCurrentDate()) + "," + this.parameterService.getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME"));
            for (TemProfile profile : profiles) {
                try {
                    OUTPUT_GLE_FILE_ps.printf("%s\n", this.generateCSVEntry(profile));
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString(), e);
                }
            }
        }
        OUTPUT_GLE_FILE_ps.close();
    }

    protected String generateXMLDoc(List<TemProfile> profiles) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element profileHeader = doc.createElement("profileHeader");
        profileHeader.appendChild(this.createElement(doc, "dateOfExport", this.dateTimeService.toDateTimeString(this.dateTimeService.getCurrentDate())));
        profileHeader.appendChild(this.createElement(doc, "universityName", this.parameterService.getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME")));
        Element profileDetailList = doc.createElement("profiles");
        for (TemProfile profile : profiles) {
            profileDetailList.appendChild(this.generateProfileDetailElement(doc, profile));
        }
        Element rootElement = doc.createElement("temProfileExport");
        rootElement.appendChild(profileHeader);
        rootElement.appendChild(profileDetailList);
        doc.appendChild(rootElement);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        return sw.toString();
    }

    protected Element generateProfileDetailElement(Document doc, TemProfile profile) {
        Element profileDetail = doc.createElement("profileDetail");
        profileDetail.appendChild(this.createElement(doc, "travelerProfileID", profile.getProfileId().toString()));
        profileDetail.appendChild(this.createElement(doc, "travelerType", StringUtils.defaultIfEmpty((String)profile.getTravelerTypeCode(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "travelerEmployeeID", StringUtils.defaultIfEmpty((String)profile.getEmployeeId(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "principalName", this.getPrincipalName(profile.getPrincipalId())));
        profileDetail.appendChild(this.createElement(doc, "firstName", StringUtils.defaultIfEmpty((String)profile.getFirstName(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "middleName", StringUtils.defaultIfEmpty((String)profile.getMiddleName(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "lastName", StringUtils.defaultIfEmpty((String)profile.getLastName(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "fullName", StringUtils.defaultIfEmpty((String)profile.getName(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "dateOfBirth", ObjectUtils.isNotNull((Object)profile.getDateOfBirth()) ? this.dateTimeService.toDateString((Date)profile.getDateOfBirth()) : ""));
        profileDetail.appendChild(this.createElement(doc, "gender", StringUtils.defaultIfEmpty((String)profile.getGender(), (String)"")));
        if (ObjectUtils.isNotNull((Object)((Object)profile.getTemProfileAddress()))) {
            profileDetail.appendChild(this.createElement(doc, "streetAddress1", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStreetAddressLine1(), (String)"")));
            profileDetail.appendChild(this.createElement(doc, "streetAddress2", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStreetAddressLine2(), (String)"")));
            profileDetail.appendChild(this.createElement(doc, "city", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getCityName(), (String)"")));
            profileDetail.appendChild(this.createElement(doc, "state", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStateCode(), (String)"")));
            profileDetail.appendChild(this.createElement(doc, "zipCode", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getZipCode(), (String)"")));
            profileDetail.appendChild(this.createElement(doc, "country", StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getCountryCode(), (String)"")));
        } else {
            profileDetail.appendChild(this.createElement(doc, "streetAddress1", ""));
            profileDetail.appendChild(this.createElement(doc, "streetAddress2", ""));
            profileDetail.appendChild(this.createElement(doc, "city", ""));
            profileDetail.appendChild(this.createElement(doc, "state", ""));
            profileDetail.appendChild(this.createElement(doc, "zipCode", ""));
            profileDetail.appendChild(this.createElement(doc, "country", ""));
        }
        profileDetail.appendChild(this.createElement(doc, "phoneNumber", StringUtils.defaultIfEmpty((String)profile.getPhoneNumber(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "emailAddress", StringUtils.defaultIfEmpty((String)profile.getEmailAddress(), (String)"")));
        profileDetail.appendChild(this.createElement(doc, "primaryDepartment", StringUtils.defaultIfEmpty((String)profile.getHomeDepartment(), (String)"")));
        return profileDetail;
    }

    protected Element createElement(Document doc, String elementName, String elementValue) {
        Element element = doc.createElement(elementName);
        Text text = doc.createTextNode(elementValue);
        element.appendChild(text);
        return element;
    }

    protected String generateCSVEntry(TemProfile profile) {
        StringBuffer line = new StringBuffer();
        line.append(profile.getProfileId().toString()).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getTravelerTypeCode(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getEmployeeId(), (String)"")).append(",");
        line.append(this.getPrincipalName(profile.getPrincipalId())).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getFirstName(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getMiddleName(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getLastName(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getName(), (String)"")).append(",");
        line.append(ObjectUtils.isNotNull((Object)profile.getDateOfBirth()) ? this.dateTimeService.toDateString((Date)profile.getDateOfBirth()) : "").append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getGender(), (String)"")).append(",");
        if (ObjectUtils.isNotNull((Object)((Object)profile.getTemProfileAddress()))) {
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStreetAddressLine1(), (String)"")).append(",");
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStreetAddressLine2(), (String)"")).append(",");
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getCityName(), (String)"")).append(",");
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getStateCode(), (String)"")).append(",");
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getZipCode(), (String)"")).append(",");
            line.append(StringUtils.defaultIfEmpty((String)profile.getTemProfileAddress().getCountryCode(), (String)"")).append(",");
        } else {
            line.append("").append(",");
            line.append("").append(",");
            line.append("").append(",");
            line.append("").append(",");
            line.append("").append(",");
            line.append("").append(",");
        }
        line.append(StringUtils.defaultIfEmpty((String)profile.getPhoneNumber(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getEmailAddress(), (String)"")).append(",");
        line.append(StringUtils.defaultIfEmpty((String)profile.getHomeDepartment(), (String)""));
        return line.toString();
    }

    protected String getPrincipalName(String principalId) {
        String principalName = "";
        if (StringUtils.isNotEmpty((String)principalId)) {
            Person person = this.personService.getPerson(principalId);
            principalName = person != null ? person.getPrincipalName() : "";
        }
        return principalName;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public String getFileDirectoryName() {
        return this.fileDirectoryName;
    }

    public void setFileDirectoryName(String fileDirectoryName) {
        this.fileDirectoryName = fileDirectoryName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

