/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

@Entity
@Table(name="TEM_CREDIT_CARD_STAGING_T")
public class CreditCardStagingData
extends PersistableBusinessObjectBase {
    private Integer id;
    private String creditCardKey;
    private Integer travelerId;
    private String airNumber;
    private Date billingCycleDate;
    private String creditCardOrAgencyCode;
    private Date creationDate;
    private Timestamp creationTimestamp;
    private Date departureDate;
    private String identifier;
    private Date reconciliationDate;
    private String referenceNumber;
    private String sequenceNumber;
    private String ticketNumber;
    private KualiDecimal transactionAmount;
    private String transactionCode;
    private Date transactionDate;
    private String travelerName;
    private String typeCode;
    private String expenseTypeCode;
    private KualiInteger paymentGroupId;
    private String merchantName;
    private Date bankPostDate;
    private String creditCardNumber;
    private Timestamp processingTimestamp;
    private boolean moveToHistoryIndicator;
    private String location;
    private String errorCode;
    private String serviceFeeNumber;
    private String itineraryNumber;
    private String importBy;
    private Integer temProfileId;
    private String stagingFileName;
    private TemProfile profile;
    private CreditCardAgency creditCardAgency;

    @Id
    @GeneratedValue(generator="TEM_CREDIT_CARD_STAGING_ID_SEQ")
    @SequenceGenerator(name="TEM_CREDIT_CARD_STAGING_ID_SEQ", sequenceName="TEM_CREDIT_CARD_STAGING_ID_SEQ", allocationSize=5)
    @Column(name="ID", nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="AIR_NUMBER", length=3, nullable=true)
    public String getAirNumber() {
        return this.airNumber;
    }

    public void setAirNumber(String airNumber) {
        this.airNumber = airNumber;
    }

    @Column(name="BILLING_CYCLE_DT", nullable=true)
    public Date getBillingCycleDate() {
        return this.billingCycleDate;
    }

    public void setBillingCycleDate(Date billingCycleDate) {
        this.billingCycleDate = billingCycleDate;
    }

    @Column(name="CREDIT_AGENCY_CD", length=4, nullable=true)
    public String getCreditCardOrAgencyCode() {
        return this.creditCardOrAgencyCode;
    }

    public void setCreditCardOrAgencyCode(String creditCardOrAgencyCode) {
        this.creditCardOrAgencyCode = creditCardOrAgencyCode;
    }

    @Column(name="CREATION_DT", nullable=true)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(name="CREATION_TIMESTAMP", nullable=true)
    public Timestamp getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(String creationTimestamp) {
        if (creationTimestamp != null) {
            creationTimestamp = creationTimestamp.replace('T', ' ');
        }
        this.creationTimestamp = Timestamp.valueOf(creationTimestamp);
    }

    @Column(name="PROCESSING_TS", nullable=true)
    public Timestamp getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public void setProcessingTimestamp(Timestamp processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    @Column(name="DEPARTURE_DT", nullable=true)
    public Date getDepartureDate() {
        return this.departureDate;
    }

    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    @Column(name="CREDIT_CARD_KEY", length=22, nullable=false)
    public String getCreditCardKey() {
        return this.creditCardKey;
    }

    public void setCreditCardKey(String creditCardKey) {
        this.creditCardKey = creditCardKey;
    }

    @Column(name="TRAVELER_ID", length=16, nullable=false)
    public Integer getTravelerId() {
        return this.travelerId;
    }

    public void setTravelerId(Integer travelerId) {
        this.travelerId = travelerId;
    }

    @Column(name="IDENTIFIER", length=1, nullable=true)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Column(name="RECONCILIATION_DT", nullable=true)
    public Date getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    @Column(name="REFERENCE_NBR", length=23, nullable=true)
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Column(name="SEQUENCE_NBR", length=3, nullable=true)
    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Column(name="TICKET_NBR", length=16, nullable=true)
    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    @Column(name="TRANSACTION_AMOUNT", precision=15, scale=4, nullable=true)
    public KualiDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(KualiDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = StringUtils.isNotBlank((String)transactionAmount) ? new KualiDecimal(transactionAmount) : KualiDecimal.ZERO;
    }

    @Column(name="TRANSACTION_CD", length=1, nullable=true)
    public String getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }

    @Column(name="TRANSACTION_DT", nullable=true)
    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    @Column(name="TRAVELER_NM", length=40, nullable=true)
    public String getTravelerName() {
        return this.travelerName;
    }

    public void setTravelerName(String travelerName) {
        this.travelerName = travelerName;
    }

    @Column(name="TYPE_CD", length=1, nullable=true)
    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    @Column(name="DV_EXP_CD", length=2, nullable=true)
    public String getExpenseTypeCode() {
        return this.expenseTypeCode;
    }

    public void setExpenseTypeCode(String expenseTypeCode) {
        this.expenseTypeCode = expenseTypeCode;
    }

    public KualiInteger getPaymentGroupId() {
        return this.paymentGroupId;
    }

    public void setPaymentGroupId(KualiInteger paymentGroupId) {
        this.paymentGroupId = paymentGroupId;
    }

    @Column(name="MERCHANT_NM", length=40, nullable=true)
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    @Column(name="BANK_POST_DT", nullable=true)
    public Date getBankPostDate() {
        return this.bankPostDate;
    }

    public void setBankPostDate(Date bankPostDate) {
        this.bankPostDate = bankPostDate;
    }

    public String getCreditCardNumber() {
        return this.creditCardNumber;
    }

    public void setCreditCardNumber(String creditCardNumber) {
        this.creditCardNumber = creditCardNumber;
    }

    @Column(name="MV_TO_HISTORY", length=1, nullable=true)
    public boolean getMoveToHistoryIndicator() {
        return this.moveToHistoryIndicator;
    }

    public void setMoveToHistoryIndicator(boolean moveToHistoryIndicator) {
        this.moveToHistoryIndicator = moveToHistoryIndicator;
    }

    @Column(name="LOC", length=20, nullable=true)
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name="ERROR_CD", length=40, nullable=true)
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    @Column(name="SRVC_FEE_NBR", length=20, nullable=true)
    public String getServiceFeeNumber() {
        return this.serviceFeeNumber;
    }

    public void setServiceFeeNumber(String serviceFeeNumber) {
        this.serviceFeeNumber = serviceFeeNumber;
    }

    @Column(name="ITN_NBR", length=20, nullable=true)
    public String getItineraryNumber() {
        return this.itineraryNumber;
    }

    public void setItineraryNumber(String itineraryNumber) {
        this.itineraryNumber = itineraryNumber;
    }

    @Column(name="IMPORT_BY", length=3, nullable=true)
    public String getImportBy() {
        return this.importBy;
    }

    public TemConstants.ExpenseImport getExpenseImport() {
        return TemConstants.ExpenseImport.getExpenseImportByCode(this.importBy);
    }

    public void setImportBy(String importBy) {
        this.importBy = importBy;
    }

    public Integer getTemProfileId() {
        return this.temProfileId;
    }

    public void setTemProfileId(Integer temProfileId) {
        this.temProfileId = temProfileId;
    }

    public TemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(TemProfile profile) {
        this.profile = profile;
    }

    public CreditCardAgency getCreditCardAgency() {
        return this.creditCardAgency;
    }

    public void setCreditCardAgency(CreditCardAgency creditCardAgency) {
        this.creditCardAgency = creditCardAgency;
    }

    public String getStagingFileName() {
        return this.stagingFileName;
    }

    public void setStagingFileName(String stagingFileName) {
        this.stagingFileName = stagingFileName;
    }
}

