/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class TravelAuthorizationCloseDocument
extends TravelAuthorizationDocument {
    protected String travelReimbursementDocumentNumber;

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    @Override
    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        if (this.isTripGenerateEncumbrance()) {
            List reimbursementPendingEntries = null;
            if (!StringUtils.isBlank((String)this.getTravelReimbursementDocumentNumber())) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("documentNumber", this.getTravelReimbursementDocumentNumber());
                reimbursementPendingEntries = (List)this.getBusinessObjectService().findMatching(GeneralLedgerPendingEntry.class, fieldValues);
            }
            this.getTravelEncumbranceService().disencumberTravelAuthorizationClose(this, sequenceHelper, reimbursementPendingEntries);
        }
        return true;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            this.retirePreviousAuthorizations();
            DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
            try {
                this.updateAndSaveAppDocStatus("Closed");
                documentAttributeIndexingQueue.indexDocument(this.getDocumentNumber());
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Workflow document exception while updating related documents", we);
            }
        }
    }

    @Override
    protected void initiateAdvancePaymentAndLines() {
    }

    @Override
    public boolean shouldRevertToOriginalAuthorizationOnCopy() {
        return true;
    }

    public String getTravelReimbursementDocumentNumber() {
        return this.travelReimbursementDocumentNumber;
    }

    public void setTravelReimbursementDocumentNumber(String travelReimbursementDocumentNumber) {
        this.travelReimbursementDocumentNumber = travelReimbursementDocumentNumber;
    }

    @Override
    public boolean isTripProgenitor() {
        return false;
    }

    @Override
    public void setTripProgenitor(boolean tripProgenitor) {
    }

    @Override
    public boolean maskTravelDocumentIdentifierAndOrganizationDocNumber() {
        return false;
    }
}

