/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.businessobject.TemProfileEmergencyContact;
import org.kuali.kfs.sys.document.FinancialSystemMaintenanceDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.Person;

public class TemProfileAuthorizerAssistant
extends FinancialSystemMaintenanceDocumentAuthorizerBase {
    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof FinancialSystemMaintenanceDocument) {
            FinancialSystemMaintenanceDocument maintDoc = (FinancialSystemMaintenanceDocument)dataObject;
            if (maintDoc.getNewMaintainableObject().getBusinessObject() instanceof TemProfile) {
                TemProfile profile = (TemProfile)maintDoc.getNewMaintainableObject().getBusinessObject();
                this.addRoleQualificationsFromProfile(profile, attributes);
                if (!StringUtils.isBlank((String)maintDoc.getNewMaintainableObject().getMaintenanceAction())) {
                    attributes.put("maintenanceAction", maintDoc.getNewMaintainableObject().getMaintenanceAction());
                }
            }
        } else if (dataObject instanceof TemProfile) {
            TemProfile profile = (TemProfile)((Object)dataObject);
            this.addRoleQualificationsFromProfile(profile, attributes);
        } else if (dataObject instanceof TemProfileEmergencyContact) {
            TemProfileEmergencyContact emergencyContact = (TemProfileEmergencyContact)((Object)dataObject);
            if (ObjectUtils.isNull((Object)((Object)emergencyContact.getProfile()))) {
                emergencyContact.refreshReferenceObject("profile");
            }
            if (!ObjectUtils.isNull((Object)((Object)emergencyContact.getProfile()))) {
                this.addRoleQualificationsFromProfile(emergencyContact.getProfile(), attributes);
            }
        } else if (dataObject instanceof TemProfileArranger) {
            TemProfileArranger arranger = (TemProfileArranger)((Object)dataObject);
            if (ObjectUtils.isNull((Object)((Object)arranger.getProfile()))) {
                arranger.refreshReferenceObject("profile");
            }
            if (!ObjectUtils.isNull((Object)((Object)arranger.getProfile()))) {
                this.addRoleQualificationsFromProfile(arranger.getProfile(), attributes);
            }
        } else if (dataObject instanceof TemProfileAccount) {
            TemProfileAccount profileAccount = (TemProfileAccount)((Object)dataObject);
            if (ObjectUtils.isNull((Object)((Object)profileAccount.getProfile()))) {
                profileAccount.refreshReferenceObject("profile");
            }
            if (!ObjectUtils.isNull((Object)((Object)profileAccount.getProfile()))) {
                this.addRoleQualificationsFromProfile(profileAccount.getProfile(), attributes);
            }
        }
    }

    protected void addRoleQualificationsFromProfile(TemProfile profile, Map<String, String> attributes) {
        if (!StringUtils.isBlank((String)profile.getPrincipalId())) {
            attributes.put("profilePrincipalId", profile.getPrincipalId());
        }
        if (!StringUtils.isBlank((String)profile.getHomeDeptOrgCode())) {
            attributes.put("organizationCode", profile.getHomeDeptOrgCode());
        }
        if (!StringUtils.isBlank((String)profile.getHomeDeptChartOfAccountsCode())) {
            attributes.put("chartOfAccountsCode", profile.getHomeDeptChartOfAccountsCode());
        }
        if (ObjectUtils.isNotNull((Object)profile.getProfileId())) {
            attributes.put("profileId", profile.getProfileId().toString());
        }
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    public Set<String> getSecurePotentiallyReadOnlySectionIds() {
        Set readOnlySections = super.getSecurePotentiallyReadOnlySectionIds();
        readOnlySections.add("TemProfileAdministrator");
        return readOnlySections;
    }
}

