/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelArrangeableAuthorizer;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kim.api.identity.Person;

public class TravelDocumentPresentationController
extends FinancialSystemTransactionalDocumentPresentationControllerBase {
    protected volatile TravelDocumentService travelDocumentService;

    public Set<String> getEditModes(Document document) {
        Set editModes = super.getEditModes(document);
        ParameterService paramService = (ParameterService)SpringContext.getBean(ParameterService.class);
        if (paramService.getParameterValueAsBoolean(TravelAuthorizationDocument.class, "DISPLAY_EMERGENCY_CONTACT_IND").booleanValue()) {
            editModes.add("displayEmergencyContactTab");
        }
        editModes.add("immediateDisbursementEntryMode");
        editModes.add("checkAmountEntry");
        if (document.getDocumentHeader().getWorkflowDocument().getNodeNames().contains("PaymentMethod")) {
            editModes.add("wireEntry");
            editModes.add("frnEntry");
        }
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || this.isActionRequestedOfCurrentUser(document)) {
            editModes.add("conversionRateEntry");
        }
        return editModes;
    }

    protected boolean isActionRequestedOfCurrentUser(Document document) {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        for (ActionRequest request : document.getDocumentHeader().getWorkflowDocument().getRootActionRequests()) {
            if (request.getActionTaken() != null) continue;
            if (StringUtils.equals((String)currentUser.getPrincipalId(), (String)request.getPrincipalId())) {
                return true;
            }
            if (request.getChildRequests() == null || request.getChildRequests().isEmpty()) continue;
            for (ActionRequest childRequest : request.getChildRequests()) {
                if (!StringUtils.equals((String)currentUser.getPrincipalId(), (String)childRequest.getPrincipalId())) continue;
                return true;
            }
        }
        return false;
    }

    protected void addFullEntryEditMode(Document document, Set<String> editModes) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        DocumentAuthorizer authorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        TravelArrangeableAuthorizer travelAuthorizer = (TravelArrangeableAuthorizer)authorizer;
        if (workflowDocument.isInitiated() || workflowDocument.isSaved()) {
            if (travelAuthorizer.canEditDocument(document, currentUser)) {
                editModes.add("fullEntry");
            }
        } else if (this.isAtNode(workflowDocument, this.getDocumentManagerApprovalNode()) && travelAuthorizer.canEditDocument(document, currentUser)) {
            editModes.add("fullEntry");
        }
    }

    public boolean isAtNode(WorkflowDocument workflowDocument, String nodeName) {
        Set nodeNames = workflowDocument.getNodeNames();
        for (String nodeNamesNode : nodeNames) {
            if (!nodeName.equals(nodeNamesNode)) continue;
            return true;
        }
        return false;
    }

    public String getDocumentManagerApprovalNode() {
        return "Travel";
    }

    public boolean isInitiator(WorkflowDocument workflowDocument) {
        String docInitiator = workflowDocument.getInitiatorPrincipalId();
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        return docInitiator.equals(currentUser.getPrincipalId());
    }

    protected boolean isRootTravelDocument(TravelDocument travelDoc) {
        if (StringUtils.isBlank((String)travelDoc.getTravelDocumentIdentifier())) {
            return true;
        }
        TravelDocument baseTravelDocument = this.getTravelDocumentService().getParentTravelDocument(travelDoc.getTravelDocumentIdentifier());
        return baseTravelDocument == null || StringUtils.equals((String)baseTravelDocument.getDocumentNumber(), (String)travelDoc.getDocumentNumber());
    }

    public ParameterService getParamService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected TemRoleService getTemRoleService() {
        return (TemRoleService)SpringContext.getBean(TemRoleService.class);
    }

    protected TemProfileService getTemProfileService() {
        return (TemProfileService)SpringContext.getBean(TemProfileService.class);
    }

    protected DocumentHelperService getDocumentHelperService() {
        return (DocumentHelperService)SpringContext.getBean(DocumentHelperService.class);
    }

    protected ConfigurationService getConfigurationService() {
        return (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }

    protected TravelDocumentService getTravelDocumentService() {
        if (this.travelDocumentService == null) {
            this.travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        }
        return this.travelDocumentService;
    }
}

