/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Set;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelDocumentPresentationController;

public class TravelEntertainmentDocumentPresentationController
extends TravelDocumentPresentationController {
    @Override
    public Set<String> getEditModes(Document document) {
        Set<String> editModes = super.getEditModes(document);
        this.addFullEntryEditMode(document, editModes);
        editModes.remove("checkAmountEntry");
        Set nodeNames = document.getDocumentHeader().getWorkflowDocument().getNodeNames();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && (nodeNames.contains("Tax") || nodeNames.contains("EntertainmentManager"))) {
            editModes.add("expenseTaxableEntry");
        }
        if (this.isRootTravelDocument((TravelDocument)document)) {
            editModes.add("requesterLooupMode");
        }
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && nodeNames.contains("EntertainmentManager")) {
            editModes.add("expenseLimitEntry");
        }
        return editModes;
    }

    public Set<String> getDocumentActions(Document document) {
        TravelEntertainmentDocument travelEntertainmentDocument = (TravelEntertainmentDocument)document;
        Set actions = super.getDocumentActions(document);
        if (this.canNewEntertainment(travelEntertainmentDocument)) {
            actions.add("canNewEntertainment");
        }
        return actions;
    }

    public boolean canNewEntertainment(TravelEntertainmentDocument document) {
        return document.isTripProgenitor() && !document.getDocumentHeader().getWorkflowDocument().isInitiated();
    }

    @Override
    public String getDocumentManagerApprovalNode() {
        return "EntertainmentManager";
    }
}

