/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelRelocationService;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelRelocationServiceImpl
implements TravelRelocationService {
    protected static Logger LOG = Logger.getLogger(TravelRelocationServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private ConfigurationService ConfigurationService;
    private PersonService personService;
    private TravelDocumentService travelDocumentService;
    private ParameterService parameterService;
    private List<PropertyChangeListener> propertyChangeListeners;

    @Override
    public Collection<TravelRelocationDocument> findByIdentifier(String travelDocumentIdentifier) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("travelDocumentIdentifier", travelDocumentIdentifier);
        return this.getBusinessObjectService().findMatching(TravelRelocationDocument.class, criteria);
    }

    @Override
    public TravelRelocationDocument find(String documentNumber) throws WorkflowException {
        TravelRelocationDocument retval = (TravelRelocationDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        this.addListenersTo(retval);
        return retval;
    }

    @Override
    public void addListenersTo(TravelRelocationDocument relocation) {
        if (relocation != null) {
            relocation.setPropertyChangeListeners(this.getPropertyChangeListeners());
        }
    }

    @Override
    public Coversheet generateCoversheetFor(TravelRelocationDocument document) throws Exception {
        String docNumber = document.getDocumentNumber();
        String initiatorId = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String instructions = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "TRAVEL_COVERSHEET_INSTRUCTIONS");
        String mailTo = this.travelDocumentService.retrieveAddressFromLocationCode(document.getTravelPayment().getDocumentationLocationCode());
        String destination = document.getToCity();
        String directory = this.getConfigurationService().getPropertyValueAsString("externalizable.help.url");
        Person initiator = this.getPersonService().getPerson(initiatorId);
        TravelerDetail traveler = document.getTraveler();
        traveler.refreshReferenceObject("customer");
        Coversheet cover = new Coversheet();
        cover.setInstructions(instructions);
        cover.setMailTo(mailTo);
        cover.setTripId(document.getTravelDocumentIdentifier() + "");
        cover.setDate(new SimpleDateFormat("MM/dd/yyyy").format(document.getTripBegin()));
        cover.setInitiatorName(initiator.getFirstName() + " " + initiator.getLastName());
        cover.setInitiatorPrincipalName(initiator.getPrincipalName());
        cover.setInitiatorPhone(initiator.getPhoneNumber());
        cover.setInitiatorEmail(initiator.getEmailAddress());
        cover.setTravelerName(traveler.getCustomer().getCustomerName());
        Person person = this.getPersonService().getPerson(traveler.getPrincipalId());
        cover.setTravelerPrincipalName(StringUtils.defaultString((String)person.getPrincipalName()));
        cover.setTravelerPhone(traveler.getPhoneNumber());
        cover.setTravelerEmail(traveler.getEmailAddress());
        cover.setDestination(destination);
        cover.setDocumentNumber(docNumber);
        ArrayList<Map<String, String>> expenses = new ArrayList<Map<String, String>>();
        if (document.getActualExpenses() != null) {
            for (ActualExpense expense : document.getActualExpenses()) {
                HashMap<String, String> expenseMap = new HashMap<String, String>();
                expense.refreshReferenceObject("expenseTypeObjectCode");
                expenseMap.put("expenseType", expense.getExpenseTypeObjectCode().getExpenseType().getName());
                BigDecimal rate = expense.getCurrencyRate();
                KualiDecimal amount = expense.getExpenseAmount();
                expenseMap.put("amount", new KualiDecimal(amount.bigDecimalValue().multiply(rate)).toString());
                expenseMap.put("receipt", "");
                expenses.add(expenseMap);
            }
        }
        cover.setExpenses(expenses);
        return cover;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    protected ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setPropertyChangeListeners(List<PropertyChangeListener> propertyChangeListeners) {
        this.propertyChangeListeners = propertyChangeListeners;
    }

    public List<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }
}

