/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.batch.businessobject.PerDiemForLoad;
import org.kuali.kfs.module.tem.batch.service.PerDiemFileParsingService;
import org.kuali.kfs.sys.ObjectUtil;

public class PerDiemFileParsingServiceImpl
implements PerDiemFileParsingService {
    private static Logger LOG = Logger.getLogger(PerDiemFileParsingServiceImpl.class);

    @Override
    public List<PerDiemForLoad> buildPerDiemsFromFlatFile(String fileName, String deliminator, List<String> fieldsToPopulate) {
        try {
            FileReader fileReader = new FileReader(fileName);
            return this.buildPerDiemsFromFlatFile(fileReader, deliminator, fieldsToPopulate);
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("Failed to process data file: " + fileName));
            throw new RuntimeException("Failed to process data file: " + fileName, ex);
        }
    }

    @Override
    public List<PerDiemForLoad> buildPerDiemsFromFlatFile(Reader reader, String deliminator, List<String> fieldsToPopulate) {
        ArrayList<PerDiemForLoad> perDiemList = new ArrayList<PerDiemForLoad>();
        CSVReader csvReader = null;
        try {
            char charDeliminator = deliminator.charAt(0);
            csvReader = new CSVReader(reader, charDeliminator);
            Object[] perDiemInString = null;
            while ((perDiemInString = csvReader.readNext()) != null) {
                if (ArrayUtils.contains((Object[])perDiemInString, (Object)"FOOTNOTES: ")) {
                    break;
                }
                PerDiemForLoad perDiem = new PerDiemForLoad();
                ObjectUtil.buildObject((Object)((Object)perDiem), (Object[])perDiemInString, fieldsToPopulate);
                perDiemList.add(perDiem);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to process data file. ");
            throw new RuntimeException("Failed to process data file. ", ex);
        }
        finally {
            if (csvReader != null) {
                try {
                    csvReader.close();
                }
                catch (IOException ex) {
                    LOG.info((Object)ex);
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return perDiemList;
    }
}

