/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.document.service.CachingMileageRateService;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class MileageRateServiceImpl
implements MileageRateService {
    private CachingMileageRateService cachingMileageRateService;
    private BusinessObjectService businessObjectService;

    @Override
    public MileageRate getMileageRateByExpenseTypeCode(MileageRate mileageRate) {
        java.sql.Date fromDate = mileageRate.getActiveFromDate();
        java.sql.Date toDate = mileageRate.getActiveToDate();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("expenseTypeCode", mileageRate.getExpenseTypeCode());
        List mileageRates = (List)this.businessObjectService.findMatching(MileageRate.class, criteria);
        for (MileageRate rate : mileageRates) {
            if (rate.getId().equals(mileageRate.getId()) || DateUtils.truncatedCompareTo((Date)fromDate, (Date)rate.getActiveToDate(), (int)5) > 0 || DateUtils.truncatedCompareTo((Date)toDate, (Date)rate.getActiveFromDate(), (int)5) < 0) continue;
            return rate;
        }
        return null;
    }

    @Override
    public MileageRate findMileageRateByExpenseTypeCodeAndDate(String expenseTypeCode, java.sql.Date effectiveDate) {
        for (MileageRate mileageRate : this.cachingMileageRateService.findAllMileageRates()) {
            if (!KfsDateUtils.isSameDay((Date)effectiveDate, (Date)mileageRate.getActiveFromDate()) && !effectiveDate.after(mileageRate.getActiveFromDate()) || !KfsDateUtils.isSameDay((Date)effectiveDate, (Date)mileageRate.getActiveToDate()) && !effectiveDate.before(mileageRate.getActiveToDate()) || !mileageRate.getExpenseTypeCode().equals(expenseTypeCode)) continue;
            return mileageRate;
        }
        return null;
    }

    public void setCachingMileageRateService(CachingMileageRateService cachingMileageRateService) {
        this.cachingMileageRateService = cachingMileageRateService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

