/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.Attendee;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelEntertainmentDocumentService;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelEntertainmentDocumentServiceImpl
implements TravelEntertainmentDocumentService {
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private PersonService personService;
    private ConfigurationService ConfigurationService;
    private List<PropertyChangeListener> propertyChangeListeners;
    private TravelDocumentService travelDocumentService;

    @Override
    public Collection<TravelEntertainmentDocument> findByTravelId(String travelDocumentIdentifier) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("travelDocumentIdentifier", travelDocumentIdentifier);
        return this.getBusinessObjectService().findMatching(TravelEntertainmentDocument.class, criteria);
    }

    @Override
    public TravelEntertainmentDocument find(String documentNumber) throws WorkflowException {
        TravelEntertainmentDocument retval = (TravelEntertainmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        this.addListenersTo(retval);
        return retval;
    }

    @Override
    public void addListenersTo(TravelEntertainmentDocument entertainment) {
        if (entertainment != null) {
            entertainment.setPropertyChangeListeners(this.getPropertyChangeListeners());
        }
    }

    public List<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    @Override
    public Coversheet generateCoversheetFor(TravelEntertainmentDocument document) throws Exception {
        Person person;
        String docNumber = document.getDocumentNumber();
        String initiatorId = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String instructions = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "TRAVEL_COVERSHEET_INSTRUCTIONS");
        String mailTo = this.travelDocumentService.retrieveAddressFromLocationCode(document.getTravelPayment().getDocumentationLocationCode());
        String destination = document.getEventTitle();
        String directory = this.getConfigurationService().getPropertyValueAsString("externalizable.help.url");
        Person initiator = this.getPersonService().getPerson(initiatorId);
        TravelerDetail traveler = document.getTraveler();
        traveler.refreshReferenceObject("customer");
        Coversheet cover = new Coversheet();
        cover.setInstructions(instructions);
        cover.setMailTo(mailTo);
        cover.setTripId(document.getTravelDocumentIdentifier());
        cover.setDate(new SimpleDateFormat("MM/dd/yyyy").format(document.getTripBegin()));
        cover.setInitiatorName(initiator.getFirstName() + " " + initiator.getLastName());
        cover.setInitiatorPrincipalName(initiator.getPrincipalName());
        cover.setInitiatorPhone(initiator.getPhoneNumber());
        cover.setInitiatorEmail(initiator.getEmailAddress());
        if (traveler.getCustomer() != null) {
            cover.setTravelerName(traveler.getCustomer().getCustomerName());
        }
        cover.setTravelerPrincipalName((person = this.getPersonService().getPerson(traveler.getPrincipalId())) != null ? person.getPrincipalName() : "");
        cover.setTravelerPhone(traveler.getPhoneNumber());
        cover.setTravelerEmail(traveler.getEmailAddress());
        cover.setDestination(destination);
        cover.setDocumentNumber(docNumber);
        ArrayList<Map<String, String>> expenses = new ArrayList<Map<String, String>>();
        if (document.getActualExpenses() != null) {
            for (ActualExpense expense : document.getActualExpenses()) {
                HashMap<String, String> expenseMap = new HashMap<String, String>();
                expense.refreshReferenceObject("expenseTypeObjectCode");
                expenseMap.put("expenseType", expense.getExpenseTypeObjectCode().getExpenseType().getName());
                BigDecimal rate = expense.getCurrencyRate();
                KualiDecimal amount = expense.getExpenseAmount();
                expenseMap.put("amount", new KualiDecimal(amount.bigDecimalValue().multiply(rate)).toString());
                expenseMap.put("receipt", this.getReceiptRequired(expense.getExpenseTypeObjectCode()));
                expenses.add(expenseMap);
            }
        }
        cover.setExpenses(expenses);
        return cover;
    }

    protected String getReceiptRequired(String expenseType, TravelDocument document) {
        String expenseTypeCode = this.getParameterService().getParameterValueAsString("KFS-TEM", "Document", expenseType);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("code", expenseTypeCode);
        primaryKeys.put("tripType", document.getTripTypeCode());
        primaryKeys.put("travelerType", document.getTraveler().getTravelerTypeCode());
        primaryKeys.put("documentType", document.getDocumentTypeName());
        return this.getReceiptRequired((ExpenseTypeObjectCode)this.businessObjectService.findByPrimaryKey(ExpenseTypeObjectCode.class, primaryKeys));
    }

    protected String getReceiptRequired(ExpenseTypeObjectCode expenseTypeCode) {
        String receipt = "-";
        if (ObjectUtils.isNotNull((Object)((Object)expenseTypeCode)) && ObjectUtils.isNotNull((Object)expenseTypeCode.isReceiptRequired())) {
            receipt = expenseTypeCode.isReceiptRequired() ? "Yes" : "No";
        }
        return receipt;
    }

    @Override
    public void handleNewAttendee(Attendee newAttendeeLine) {
        this.getDictionaryValidationService().validate((Object)newAttendeeLine);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPropertyChangeListeners(List<PropertyChangeListener> propertyChangeListeners) {
        this.propertyChangeListeners = propertyChangeListeners;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return (DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class);
    }
}

