/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.service.AgencyStagingDataRuleHelper;

public class AgencyStagingDataRuleByTrip
implements AgencyStagingDataRuleHelper {
    public static final String MAINTAINABLE_ERROR_PREFIX = "document.newMaintainableObject.";
    public static final String ADD_LINE_ERROR_PREFIX = "add.";
    protected ExpenseImportByTripService expenseImportByTripService;

    @Override
    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = this.processCustomDocumentBusinessRules(document);
        return true;
    }

    @Override
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.processCustomDocumentBusinessRules(document);
    }

    @Override
    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    @Override
    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        boolean result = true;
        if (collectionName.equals("tripAccountingInformation")) {
            TripAccountingInformation accountingLine = (TripAccountingInformation)line;
            Map<String, ErrorMessage> errors = this.getExpenseImportByTripService().validateAccountingInfoLine(accountingLine);
            if (!errors.isEmpty()) {
                for (String errorProperty : errors.keySet()) {
                    ErrorMessage error = errors.get(errorProperty);
                    if (!ObjectUtils.isNotNull((Object)error)) continue;
                    this.putFieldError("add.tripAccountingInformation." + errorProperty, error.getErrorKey(), error.getMessageParameters());
                }
                result &= false;
            }
        }
        return result;
    }

    public ExpenseImportByTripService getExpenseImportByTripService() {
        return this.expenseImportByTripService;
    }

    public void setExpenseImportByTripService(ExpenseImportByTripService expenseImportByTripService) {
        this.expenseImportByTripService = expenseImportByTripService;
    }

    protected void putFieldError(String propertyName, String errorConstant, String ... errorParameters) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, errorParameters);
        }
    }

    protected boolean errorAlreadyExists(String propertyName, String errorConstant) {
        return GlobalVariables.getMessageMap().fieldHasMessage(propertyName, errorConstant);
    }

    protected boolean processCustomDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = true;
        AgencyStagingData data = (AgencyStagingData)document.getNewMaintainableObject().getBusinessObject();
        if (data.isActive()) {
            List<ErrorMessage> errors = this.getExpenseImportByTripService().validateMissingAccountingInfo(data);
            if (!errors.isEmpty()) {
                for (ErrorMessage error : errors) {
                    this.putFieldError("tripAccountingInformation", error.getErrorKey(), error.getMessageParameters());
                }
                result &= false;
            } else {
                int i = 0;
                for (TripAccountingInformation account : data.getTripAccountingInformation()) {
                    Map<String, ErrorMessage> errorMap = this.getExpenseImportByTripService().validateAccountingInfoLine(account);
                    if (!errorMap.isEmpty()) {
                        for (String errorProperty : errorMap.keySet()) {
                            ErrorMessage error = errorMap.get(errorProperty);
                            if (!ObjectUtils.isNotNull((Object)error)) continue;
                            this.putFieldError("tripAccountingInformation[" + i + "]." + errorProperty, error.getErrorKey(), error.getMessageParameters());
                            result &= false;
                        }
                    }
                    ++i;
                }
            }
            if (!this.getExpenseImportByTripService().validateTripId(data).isEmpty()) {
                this.putFieldError("tripId", "message.batch.tem.agencyDataInvalidTripId", new String[0]);
                result &= false;
            }
            if (this.getExpenseImportByTripService().isTripDataMissing(data)) {
                this.putFieldError("lodgingItineraryNumber", "message.batch.tem.agencyDataMissingTripData", new String[0]);
                result &= false;
            }
            if (result && !(errors = this.getExpenseImportByTripService().validateDuplicateData(data)).isEmpty()) {
                if (this.isErrorListContainsErrorKey(errors, "message.batch.tem.agencyDataMandatoryFields") || this.isErrorListContainsErrorKey(errors, "message.batch.tem.agencyDataAirLodgingRentalMissing")) {
                    result &= false;
                } else {
                    this.putFieldError("tripId", "message.batch.tem.agencyData.trip.DuplicateRecord", data.getTripId(), data.getAgency(), data.getTransactionPostingDate().toString(), data.getTripExpenseAmount().toString(), data.getItineraryDataString());
                    result &= false;
                }
            }
            if (!this.getExpenseImportByTripService().validateDistributionCode(data).isEmpty()) {
                this.putFieldError("distributionCode", "message.batch.tem.agencyDataInvalidDistributionCode", data.getDistributionCode());
                result &= false;
            }
        }
        return result;
    }

    protected boolean isErrorListContainsErrorKey(List<ErrorMessage> errors, String errorKey) {
        for (ErrorMessage error : errors) {
            if (!error.getErrorKey().equals(errorKey)) continue;
            return true;
        }
        return false;
    }
}

