/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;

public class ExpenseTypeRule
extends MaintenanceDocumentRuleBase {
    protected volatile TravelExpenseService travelExpenseService;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = super.processCustomSaveDocumentBusinessRules(document);
        ExpenseType newExpenseType = (ExpenseType)document.getNewMaintainableObject().getBusinessObject();
        ExpenseType oldExpenseType = null;
        if (document.getOldMaintainableObject() != null && document.getOldMaintainableObject().getBusinessObject() != null) {
            oldExpenseType = (ExpenseType)document.getOldMaintainableObject().getBusinessObject();
        }
        this.validateCategory(newExpenseType);
        this.validateCategoryDefault(newExpenseType, oldExpenseType);
        return success;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = super.processCustomRouteDocumentBusinessRules(document);
        ExpenseType newExpenseType = (ExpenseType)document.getNewMaintainableObject().getBusinessObject();
        ExpenseType oldExpenseType = null;
        if (document.getOldMaintainableObject() != null && document.getOldMaintainableObject().getBusinessObject() != null) {
            oldExpenseType = (ExpenseType)document.getOldMaintainableObject().getBusinessObject();
        }
        if (success &= this.validateCategory(newExpenseType)) {
            success &= this.validateCategoryDefault(newExpenseType, oldExpenseType);
        }
        return success;
    }

    protected boolean validateCategory(ExpenseType newExpenseType) {
        TemConstants.ExpenseTypeMetaCategory category;
        if (!StringUtils.isBlank((String)newExpenseType.getExpenseTypeMetaCategoryCode()) && (category = TemConstants.ExpenseTypeMetaCategory.forCode(newExpenseType.getExpenseTypeMetaCategoryCode())) == null) {
            this.putFieldError("expenseTypeMetaCategoryCode", "error.etc.category.does.not.exist", newExpenseType.getExpenseTypeMetaCategoryCode());
            return false;
        }
        return true;
    }

    protected boolean validateCategoryDefault(ExpenseType newExpenseType, ExpenseType oldExpenseType) {
        TemConstants.ExpenseTypeMetaCategory metaCategory;
        if (!StringUtils.isBlank((String)newExpenseType.getExpenseTypeMetaCategoryCode()) && (metaCategory = TemConstants.ExpenseTypeMetaCategory.forCode(newExpenseType.getExpenseTypeMetaCategoryCode())) != null) {
            if (newExpenseType.isCategoryDefault()) {
                ExpenseType expenseType = this.getTravelExpenseService().getDefaultExpenseTypeForCategory(metaCategory);
                if (expenseType != null && !StringUtils.equals((String)expenseType.getCode(), (String)newExpenseType.getCode())) {
                    this.putFieldError("expenseTypeMetaCategoryCode", "error.etc.cannot.be.default.there.can.only.be.one", new String[]{metaCategory.getName(), expenseType.getCode()});
                    return false;
                }
            } else if (oldExpenseType != null && oldExpenseType.isCategoryDefault() && StringUtils.equals((String)newExpenseType.getExpenseTypeMetaCategoryCode(), (String)oldExpenseType.getExpenseTypeMetaCategoryCode())) {
                GlobalVariables.getMessageMap().putWarning("document.newMaintainableObject.categoryDefault", "warning.etc.wont.be.category.default", new String[]{metaCategory.getName()});
            } else {
                ExpenseType expenseType = this.getTravelExpenseService().getDefaultExpenseTypeForCategory(TemConstants.ExpenseTypeMetaCategory.forCode(newExpenseType.getExpenseTypeMetaCategoryCode()));
                if (expenseType == null) {
                    GlobalVariables.getMessageMap().putWarning("document.newMaintainableObject.categoryDefault", "warning.etc.no.category.default", new String[]{metaCategory.getName()});
                }
            }
        }
        return true;
    }

    public TravelExpenseService getTravelExpenseService() {
        if (this.travelExpenseService == null) {
            this.travelExpenseService = (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
        }
        return this.travelExpenseService;
    }
}

