/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.validation.event.AddImportedExpenseDetailLineEvent;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelDocumentImportedExpenseDetailLineValidation
extends GenericValidation {
    protected DictionaryValidationService dictionaryValidationService;

    public boolean validate(AttributedDocumentEvent event) {
        AddImportedExpenseDetailLineEvent addImportedExpenseDetailEvent = (AddImportedExpenseDetailLineEvent)event;
        TravelDocument travelDocument = (TravelDocument)addImportedExpenseDetailEvent.getDocument();
        String[] tempStr = addImportedExpenseDetailEvent.getErrorPathPrefix().split("\\[");
        String temp = tempStr[1];
        temp = tempStr[1].split("\\]")[0];
        int index = Integer.parseInt(temp);
        ImportedExpense importedExpense = travelDocument.getImportedExpenses().get(index);
        ImportedExpense importedExpenseDetail = (ImportedExpense)addImportedExpenseDetailEvent.getExpenseLine();
        importedExpenseDetail.setTravelCompanyCodeName(importedExpense.getTravelCompanyCodeName());
        boolean success = true;
        success = this.getDictionaryValidationService().isBusinessObjectValid((BusinessObject)importedExpenseDetail, "");
        if (success) {
            if (importedExpenseDetail.getExpenseAmount().isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.detail.less.than.zero", new String[0]);
                return false;
            }
            if (importedExpenseDetail.getCurrencyRate().equals(new KualiDecimal(1))) {
                KualiDecimal total = importedExpense.getTotalDetailExpenseAmount();
                KualiDecimal remainder = (KualiDecimal)importedExpense.getConvertedAmount().subtract((AbstractKualiDecimal)total);
                if (importedExpenseDetail.getConvertedAmount().isGreaterThan((AbstractKualiDecimal)remainder)) {
                    GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.detail.greater.than.expense", new String[0]);
                    return false;
                }
            }
        }
        if (success && !importedExpenseDetail.getCurrencyRate().equals(BigDecimal.ONE)) {
            GlobalVariables.getMessageMap().putInfo("expenseAmount", "info.document.tem.travel.import.currency.conversion", new String[0]);
        }
        return success;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }
}

