/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelDocumentRequiredInfoValidation
extends GenericValidation {
    protected TravelExpenseService travelExpenseService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        TravelDocument document = (TravelDocument)event.getDocument();
        if (this.isReceiptRequired(document)) {
            if (this.isMissingReceiptSelected(document)) {
                if (!this.isNotesEnteredForTheMissingReceipts(document)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("notes", "error.document.tem.actualexpense.receipt.notes", new String[0]);
                }
            } else if (!this.isReceiptAttached(document)) {
                valid = false;
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("attachmentFile", "error.tem.attachment.required", new String[0]);
            }
        }
        return valid;
    }

    private boolean isReceiptRequired(TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            ExpenseTypeObjectCode expenseTypeCode = actualExpense.getExpenseTypeObjectCode();
            if (expenseTypeCode == null || !expenseTypeCode.isReceiptRequired() || !this.getTravelExpenseService().isTravelExpenseExceedReceiptRequirementThreshold(actualExpense)) continue;
            return true;
        }
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            if (importedExpense.getReceiptRequired() == null || !importedExpense.getReceiptRequired().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isReceiptAttached(TravelDocument document) {
        for (Note note : document.getNotes()) {
            if (note.getAttachment() == null || !StringUtils.equalsIgnoreCase((String)note.getAttachment().getAttachmentTypeCode(), (String)"Receipt")) continue;
            return true;
        }
        return false;
    }

    private boolean isMissingReceiptSelected(TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            ExpenseTypeObjectCode expenseTypeCode = actualExpense.getExpenseTypeObjectCode();
            if (!expenseTypeCode.isReceiptRequired() || !this.getTravelExpenseService().isTravelExpenseExceedReceiptRequirementThreshold(actualExpense) || actualExpense.getMissingReceipt() == null || !actualExpense.getMissingReceipt().booleanValue()) continue;
            return true;
        }
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            if (importedExpense.getReceiptRequired() == null || !importedExpense.getReceiptRequired().booleanValue() || importedExpense.getMissingReceipt() == null || !importedExpense.getMissingReceipt().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isNotesEnteredForTheMissingReceipts(TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            if (actualExpense.getMissingReceipt() == null || !actualExpense.getMissingReceipt().booleanValue() || actualExpense.getNotes() != null && actualExpense.getNotes().length() != 0) continue;
            return false;
        }
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            if (importedExpense.getMissingReceipt() == null || !importedExpense.getMissingReceipt().booleanValue() || importedExpense.getNotes() != null && importedExpense.getNotes().length() != 0) continue;
            return false;
        }
        return true;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }
}

