/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import org.kuali.kfs.kns.datadictionary.validation.fieldlevel.PhoneNumberValidationPattern;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext
public class TravelServiceTest
extends KualiTestBase {
    private TravelService travelService;
    private DateTimeService dateTimeService;
    private static final int ONE_DAY = 86400;
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sas;

    protected void setUp() throws Exception {
        super.setUp();
        TravelService travelServiceTemp = (TravelService)SpringContext.getBean(TravelService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        this.travelService = (TravelService)SpringContext.getBean(TravelService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    @Test
    public void testValidatePhoneNumber_byPhoneNumber() {
        TravelServiceTest.assertTrue((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber(null, "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("123-555-1234", "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("123-555-1234 x1234", "error.document.tem.phoneNumber")));
    }

    @Test
    public void testValidatePhoneNumber_byCountryCodeAndPhoneNumber() {
        TravelServiceTest.assertTrue((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber(null, null, "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("UK", "555-1234", "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("UK", "555-1234 x1234", "error.document.tem.phoneNumber")));
        PhoneNumberValidationPattern pattern = new PhoneNumberValidationPattern();
        TravelServiceTest.assertTrue((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("US", "1", "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("US", "123-555-1234", "error.document.tem.phoneNumber")));
        TravelServiceTest.assertFalse((boolean)"error.document.tem.phoneNumber".equals(this.travelService.validatePhoneNumber("US", "123-555-1234 x1234", "error.document.tem.phoneNumber")));
    }

    @Test
    public void testFindTemProfileByPrincipalId() {
        TemProfile profile = new TemProfile();
        Integer newProfileId = this.sas.getNextAvailableSequenceNumber("TEM_PROFILE_ID_SEQ").intValue();
        profile.setProfileId(newProfileId);
        profile.getTemProfileAddress().setProfileId(newProfileId);
        profile.setCustomerNumber("555555555");
        profile.setPrincipalId("66666666");
        profile.setDateOfBirth(new Date(Date.parse("03/03/1975")));
        profile.setCitizenship("United States");
        profile.setDriversLicenseExpDate(new Date(Date.parse("03/03/2014")));
        profile.setDriversLicenseNumber("B43212345");
        profile.setUpdatedBy("jamey");
        profile.setLastUpdate(new Date(Date.parse("03/03/2011")));
        profile.setGender("M");
        profile.setNonResidentAlien(Boolean.valueOf(false));
        profile.setHomeDeptChartOfAccountsCode("UA");
        profile.setHomeDeptOrgCode("VPIT");
        List travelerTypes = (List)this.businessObjectService.findMatching(TravelerType.class, new HashMap());
        profile.setTravelerType((TravelerType)travelerTypes.get(0));
        profile.setTravelerTypeCode(profile.getTravelerType().getCode());
        profile.setProfileId(Integer.valueOf(-1));
        this.businessObjectService.save((PersistableBusinessObject)profile);
        profile = this.travelService.findTemProfileByPrincipalId("-1");
        TravelServiceTest.assertNull((Object)profile);
        profile = this.travelService.findTemProfileByPrincipalId("66666666");
        TravelServiceTest.assertNotNull((Object)profile);
    }
}

