/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.businessobject;

import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.businessobject.DefaultMealBreakDownStrategy;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemMealIncidentalBreakDown;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class MealBreakDownStrategyForContinental
extends DefaultMealBreakDownStrategy {
    private BusinessObjectService businessObjectService;

    @Override
    public void breakDown(PerDiem perDiem, KualiDecimal mealsAndIncidentals) {
        if (ObjectUtils.isNull((Object)mealsAndIncidentals) || mealsAndIncidentals.isNegative()) {
            throw new RuntimeException("The given mealsAndIncidentals cannot be null or negative.");
        }
        PerDiemMealIncidentalBreakDown breakDown = (PerDiemMealIncidentalBreakDown)this.getBusinessObjectService().findBySinglePrimaryKey(PerDiemMealIncidentalBreakDown.class, (Object)Float.valueOf(mealsAndIncidentals.floatValue()));
        if (ObjectUtils.isNull((Object)((Object)breakDown))) {
            super.breakDown(perDiem, mealsAndIncidentals);
        } else {
            this.breakDown(perDiem, breakDown);
        }
    }

    protected void breakDown(PerDiem perDiem, PerDiemMealIncidentalBreakDown breakDown) {
        KualiDecimal breakfast = breakDown.getBreakfast();
        perDiem.setBreakfast(breakfast);
        KualiDecimal lunch = breakDown.getLunch();
        perDiem.setLunch(lunch);
        KualiDecimal dinner = breakDown.getDinner();
        perDiem.setDinner(dinner);
        KualiDecimal incidentals = breakDown.getIncidentals();
        perDiem.setIncidentals(incidentals);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

