/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.CardApplicationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public abstract class CardApplicationDocumentBase
extends FinancialSystemTransactionalDocumentBase
implements CardApplicationDocument {
    protected static Logger LOG = Logger.getLogger(CardApplicationDocumentBase.class);
    protected TemProfile temProfile;
    protected Integer temProfileId;
    protected boolean userAgreement;
    private String dummyAppDocStatus;

    @Override
    public TemProfile getTemProfile() {
        return this.temProfile;
    }

    @Override
    public void setTemProfile(TemProfile temProfile) {
        this.temProfile = temProfile;
    }

    @Override
    public Integer getTemProfileId() {
        return this.temProfileId;
    }

    @Override
    public void setTemProfileId(Integer temProfileId) {
        this.temProfileId = temProfileId;
    }

    @Override
    public boolean isUserAgreement() {
        return this.userAgreement;
    }

    @Override
    public void setUserAgreement(boolean userAgreement) {
        this.userAgreement = userAgreement;
    }

    @Override
    public String getUserAgreementText() {
        return null;
    }

    public String getDummyAppDocStatus() {
        return this.dummyAppDocStatus;
    }

    public void setDummyAppDocStatus(String dummyAppDocStatus) {
        this.dummyAppDocStatus = dummyAppDocStatus;
    }

    protected String zeroBuffer(Long number) {
        String numberStr = number.toString();
        while (numberStr.length() < 16) {
            numberStr = "0" + numberStr;
        }
        return numberStr;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        return (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return (WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class);
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected ConfigurationService getConfigurationService() {
        return (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    public DocumentDao getDocumentDao() {
        return (DocumentDao)SpringContext.getBean(DocumentDao.class);
    }

    public String getApplicationDocumentStatus() {
        String status = this.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
        return StringUtils.defaultIfEmpty((String)status, (String)"Application");
    }

    @Override
    public void sendAcknowledgement() {
        this.getTravelDocumentService().addAdHocRecipient((Document)this, this.getTemProfile().getPrincipalId(), "K");
        try {
            ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).acknowledge(this.getDocumentHeader().getWorkflowDocument(), null, new ArrayList(this.getAdHocRoutePersons()));
        }
        catch (WorkflowException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void approvedByBank() {
    }

    @Override
    public boolean saveAppDocStatus() {
        boolean saved = false;
        try {
            this.getWorkflowDocumentService().save(this.getDocumentHeader().getWorkflowDocument(), null);
            saved = true;
        }
        catch (WorkflowException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return saved;
    }
}

