/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.dataaccess.AccountingDocumentRelationshipDao;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountingDocumentRelationshipServiceImpl
implements AccountingDocumentRelationshipService {
    protected AccountingDocumentRelationshipDao accountingDocumentRelationshipDao;
    protected BusinessObjectService businessObjectService;
    protected IdentityService identityService;
    private static final Logger LOG = Logger.getLogger(AccountingDocumentRelationshipServiceImpl.class);

    @Override
    public Set<String> getRelatedDocumentNumbers(String documentNumber) {
        List<AccountingDocumentRelationship> adrList = this.accountingDocumentRelationshipDao.findAccountingDocumentRelationshipByDocumentNumber(documentNumber);
        HashSet<String> allRelatedDocumentNumbers = new HashSet<String>();
        if (adrList != null) {
            for (AccountingDocumentRelationship adr : adrList) {
                this.addRelationship(adr, allRelatedDocumentNumbers, documentNumber);
            }
        }
        return allRelatedDocumentNumbers;
    }

    protected void addRelationship(AccountingDocumentRelationship adr, Set<String> relatedDocumentNumbers, String documentNumber) {
        if (adr.getDocumentNumber().equals(documentNumber)) {
            relatedDocumentNumbers.add(adr.getRelDocumentNumber());
        } else {
            relatedDocumentNumbers.add(adr.getDocumentNumber());
        }
    }

    @Override
    public Set<String> getAllRelatedDocumentNumbers(String documentNumber) {
        Set<String> allRelatedDocumentNumbers = new HashSet<String>();
        String rootDocumentNumber = this.getRootDocumentNumber(documentNumber);
        String string = rootDocumentNumber = rootDocumentNumber != null ? rootDocumentNumber : documentNumber;
        if (rootDocumentNumber != null) {
            allRelatedDocumentNumbers.add(rootDocumentNumber);
            allRelatedDocumentNumbers = this.getAllRelatedChildrenDocumentNumbers(allRelatedDocumentNumbers);
            if (!rootDocumentNumber.equals(documentNumber)) {
                allRelatedDocumentNumbers.add(rootDocumentNumber);
            }
            allRelatedDocumentNumbers.remove(documentNumber);
            return allRelatedDocumentNumbers;
        }
        return allRelatedDocumentNumbers;
    }

    @Override
    public String getRootDocumentNumber(String documentNumber) {
        List<AccountingDocumentRelationship> adrList = this.accountingDocumentRelationshipDao.findAccountingDocumentRelationship(new AccountingDocumentRelationship(null, documentNumber));
        if (!adrList.isEmpty() && adrList.size() > 1) {
            LOG.warn((Object)"Document has 2 parents. This should not happen.");
        }
        return adrList.isEmpty() ? documentNumber : this.getRootDocumentNumber(adrList.get(0).getDocumentNumber());
    }

    private Set<String> getAllRelatedChildrenDocumentNumbers(Set<String> documentNumbers) {
        HashSet<String> allRelatedDocumentNumbers = new HashSet<String>();
        for (String documentNumber : documentNumbers) {
            List<AccountingDocumentRelationship> adrList = this.accountingDocumentRelationshipDao.findAccountingDocumentRelationship(new AccountingDocumentRelationship(documentNumber, null));
            for (AccountingDocumentRelationship adr : adrList) {
                allRelatedDocumentNumbers.add(adr.getRelDocumentNumber());
            }
            allRelatedDocumentNumbers.addAll(this.getAllRelatedChildrenDocumentNumbers(allRelatedDocumentNumbers));
        }
        return allRelatedDocumentNumbers.isEmpty() ? documentNumbers : allRelatedDocumentNumbers;
    }

    @Override
    public void save(List<AccountingDocumentRelationship> accountingDocumentRelationships) {
        for (AccountingDocumentRelationship adr : accountingDocumentRelationships) {
            this.save(adr);
        }
    }

    @Override
    public void save(AccountingDocumentRelationship accountingDocumentRelationship) {
        if (accountingDocumentRelationship.getPrincipalId() == null) {
            Principal person = this.identityService.getPrincipalByPrincipalName("kfs");
            accountingDocumentRelationship.setPrincipalId(person.getPrincipalId());
        }
        this.accountingDocumentRelationshipDao.save(accountingDocumentRelationship);
    }

    @Override
    public void delete(List<AccountingDocumentRelationship> accountingDocumentRelationships) {
        for (AccountingDocumentRelationship adr : accountingDocumentRelationships) {
            this.delete(adr);
        }
    }

    @Override
    public Set<String> huntForRelatedDocumentNumbersWithDocumentType(String documentNumber, String documentType) {
        List<AccountingDocumentRelationship> adrList = this.accountingDocumentRelationshipDao.findAccountingDocumentRelationshipByDocumentNumber(documentNumber);
        HashSet<String> docNumbers = new HashSet<String>();
        if (adrList != null && adrList != null) {
            for (AccountingDocumentRelationship adr : adrList) {
                if (StringUtils.isBlank((String)adr.getDescription()) || !adr.getDescription().matches(".*" + documentType + ".*")) continue;
                this.addRelationship(adr, docNumbers, documentNumber);
            }
        }
        return docNumbers;
    }

    @Override
    public void delete(AccountingDocumentRelationship accountingDocumentRelationship) {
        this.accountingDocumentRelationshipDao.delete(accountingDocumentRelationship);
    }

    @Override
    public boolean isDocumentSomebodysChild(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("relDocumentNumber", documentNumber);
        int count = this.getBusinessObjectService().countMatching(AccountingDocumentRelationship.class, fieldValues);
        return count > 0;
    }

    @Override
    public List<AccountingDocumentRelationship> find(AccountingDocumentRelationship adr) {
        return this.accountingDocumentRelationshipDao.findAccountingDocumentRelationship(adr);
    }

    public AccountingDocumentRelationshipDao getAccountingDocumentRelationshipDao() {
        return this.accountingDocumentRelationshipDao;
    }

    public void setAccountingDocumentRelationshipDao(AccountingDocumentRelationshipDao accountingDocumentRelationshipDao) {
        this.accountingDocumentRelationshipDao = accountingDocumentRelationshipDao;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

