/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.datadictionary.validation.charlevel.RegexValidationPattern;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelCardType;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.service.impl.TemProfileServiceImpl;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelServiceImpl
implements TravelService {
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private AccountsReceivableModuleService accountsReceivableModuleService;
    private TemRoleService temRoleService;
    private TravelDocumentDao travelDocumentDao;

    @Override
    public String validatePhoneNumber(String phoneNumber, String error) {
        return this.validatePhoneNumber("", phoneNumber, error);
    }

    @Override
    public String validatePhoneNumber(String countryCode, String phoneNumber, String error) {
        if (StringUtils.isBlank((String)countryCode) || !countryCode.equals("US")) {
            RegexValidationPattern pattern = new RegexValidationPattern();
            pattern.setPattern("\\+?[0-9]{1}([0-9.]*|\\-|\\s)*[0-9]((\\s[x][0-9]+)*)");
            if (phoneNumber != null && pattern.matches(phoneNumber)) {
                return "";
            }
            return error;
        }
        RegexValidationPattern pattern = new RegexValidationPattern();
        pattern.setPattern("[0-9]{3}\\-[0-9]{3}\\-[0-9]{4}((\\s[x][0-9]+)*)");
        if (pattern.matches(phoneNumber)) {
            return "";
        }
        return error;
    }

    @Override
    public TemProfile findTemProfileByPrincipalId(String principalId) {
        return ((TemProfileServiceImpl)SpringContext.getBean(TemProfileServiceImpl.class)).findTemProfileByPrincipalId(principalId);
    }

    @Override
    public boolean isUserInitiatorOrArranger(TravelDocument document, Person user) {
        boolean isUser = false;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        String initiator = workflowDocument.getInitiatorPrincipalId();
        String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        if (initiator.equals(user.getPrincipalId()) || this.temRoleService.isTravelDocumentArrangerForProfile(docType, user.getPrincipalId(), document.getProfileId())) {
            isUser = true;
        }
        return isUser;
    }

    @Override
    public List<String> getTravelCardTypes() {
        ArrayList<String> travelCardTypes = new ArrayList<String>();
        for (TravelCardType cardType : (List)this.businessObjectService.findAll(TravelCardType.class)) {
            travelCardTypes.add(cardType.getCode());
        }
        return travelCardTypes;
    }

    @Override
    public Set<String> getParentDocumentTypeNames(String documentTypeName) {
        HashSet<String> docTypes = new HashSet<String>();
        docTypes.add("TT");
        if (TemConstants.TravelDocTypes.getAuthorizationDocTypes().contains(documentTypeName)) {
            docTypes.add("TRV");
            docTypes.add("TA");
        } else if ("TR".equals(documentTypeName)) {
            docTypes.add("TRV");
            docTypes.add("TR");
        } else {
            docTypes.add(documentTypeName);
        }
        return docTypes;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    public void setTemRoleService(TemRoleService temRoleService) {
        this.temRoleService = temRoleService;
    }
}

