/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.tem.businessobject.AdvancePaymentReason;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Entity
@Table(name="TEM_TRVL_ADV_T")
public class TravelAdvance
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private String travelDocumentIdentifier;
    private KualiDecimal travelAdvanceRequested = KualiDecimal.ZERO;
    private KualiDecimal amountDue;
    private String arCustomerId;
    private String arInvoiceDocNumber;
    private Date dueDate;
    private Date taxRamificationNotificationDate;
    private String advancePaymentReasonCode;
    private Boolean travelAdvancePolicy = Boolean.FALSE;
    private String additionalJustification;
    private AdvancePaymentReason advancePaymentReason;

    @Column(name="FDOC_NBR")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Column(name="TRVL_ID")
    public String getTravelDocumentIdentifier() {
        return this.travelDocumentIdentifier;
    }

    public void setTravelDocumentIdentifier(String travelDocumentIdentifier) {
        this.travelDocumentIdentifier = travelDocumentIdentifier;
    }

    @Column(name="TVL_ADV_REQ", precision=19, scale=2)
    public KualiDecimal getTravelAdvanceRequested() {
        return this.travelAdvanceRequested;
    }

    public void setTravelAdvanceRequested(KualiDecimal travelAdvanceRequested) {
        this.travelAdvanceRequested = travelAdvanceRequested;
    }

    public KualiDecimal getAmountDue() {
        this.amountDue = this.arInvoiceDocNumber != null ? this.getTravelDocumentService().getAmountDueFromInvoice(this.arInvoiceDocNumber, this.getTravelAdvanceRequested()) : this.getTravelAdvanceRequested();
        return this.amountDue;
    }

    public void setAmountDue(KualiDecimal amountDue) {
        this.amountDue = amountDue;
    }

    @Column(name="AR_CUST_ID")
    public String getArCustomerId() {
        return this.arCustomerId;
    }

    public void setArCustomerId(String arCustomerId) {
        this.arCustomerId = arCustomerId;
    }

    @Column(name="AR_INV_DOC_NBR")
    public String getArInvoiceDocNumber() {
        return this.arInvoiceDocNumber;
    }

    public void setArInvoiceDocNumber(String arInvoiceDocNumber) {
        this.arInvoiceDocNumber = arInvoiceDocNumber;
    }

    @Column(name="DUE_DT")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getAdvancePaymentReasonCode() {
        return this.advancePaymentReasonCode;
    }

    public void setAdvancePaymentReasonCode(String advancePaymentReasonCode) {
        this.advancePaymentReasonCode = advancePaymentReasonCode;
    }

    public AdvancePaymentReason getAdvancePaymentReason() {
        return this.advancePaymentReason;
    }

    public void setAdvancePaymentReason(AdvancePaymentReason advancePaymentReason) {
        this.advancePaymentReason = advancePaymentReason;
    }

    public boolean getTravelAdvancePolicy() {
        return this.travelAdvancePolicy;
    }

    public void setTravelAdvancePolicy(boolean travelAdvancePolicy) {
        this.travelAdvancePolicy = travelAdvancePolicy;
    }

    public String getAdditionalJustification() {
        return this.additionalJustification;
    }

    public void setAdditionalJustification(String additionalJustification) {
        this.additionalJustification = additionalJustification;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    @Column(name="TAX_RAM_NTF_DT")
    public Date getTaxRamificationNotificationDate() {
        return this.taxRamificationNotificationDate;
    }

    public void setTaxRamificationNotificationDate(Date taxRamificationNotificationDate) {
        this.taxRamificationNotificationDate = taxRamificationNotificationDate;
    }

    public boolean isAtLeastPartiallyFilledIn() {
        return this.getTravelAdvanceRequested() != null && !this.getTravelAdvanceRequested().equals((Object)KualiDecimal.ZERO) || this.getDueDate() != null || this.getTravelAdvancePolicy() || !StringUtils.isBlank((String)this.getAdditionalJustification());
    }

    public void clear() {
        this.setTravelAdvanceRequested(null);
        this.setDueDate(null);
        this.setTravelAdvancePolicy(false);
        this.setAdditionalJustification(null);
    }
}

