/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Map;
import java.util.Set;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelArrangeableAuthorizer;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelAuthorizationAuthorizer
extends TravelArrangeableAuthorizer {
    protected volatile RoleService roleService;

    public boolean canClose(TravelDocument taDoc, Person user) {
        return this.getActionPermission(taDoc, user, "Close TA");
    }

    public boolean canAmend(TravelDocument taDoc, Person user) {
        return this.getActionPermission(taDoc, user, "Amend TA");
    }

    public boolean canHold(TravelAuthorizationDocument travelDocument, Person user) {
        return this.getActionPermission(travelDocument, user, "Hold TA");
    }

    public boolean canRemoveHold(TravelAuthorizationDocument travelDocument, Person user) {
        return this.getActionPermission(travelDocument, user, "Remove Hold TA");
    }

    public boolean canCancel(TravelAuthorizationDocument travelDocument, Person user) {
        return this.getActionPermission(travelDocument, user, "Cancel TA");
    }

    public boolean hideButtons(TravelAuthorizationDocument travelDocument, Person user) {
        return this.getActionPermission(travelDocument, user, "Hide Buttons TA");
    }

    @Override
    protected void addRoleQualification(Object dataObject, Map<String, String> qualification) {
        if (dataObject instanceof TravelAuthorizationDocument) {
            this.addAccountQualification((TravelAuthorizationDocument)dataObject, qualification);
            this.addTemProfileQualification((TravelAuthorizationDocument)dataObject, qualification);
        }
        super.addRoleQualification(dataObject, qualification);
    }

    protected void addTemProfileQualification(TravelAuthorizationDocument document, Map<String, String> attributes) {
        if (ObjectUtils.isNotNull((Object)document.getTemProfileId()) && !ObjectUtils.isNull((Object)((Object)document.getTraveler()))) {
            attributes.put("principalId", document.getTraveler().getPrincipalId());
        }
    }

    protected void addAccountQualification(TravelAuthorizationDocument authorizationDoc, Map<String, String> attributes) {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        boolean foundQualification = false;
        for (int count = 0; !foundQualification && !ObjectUtils.isNull((Object)authorizationDoc.getSourceAccountingLines()) && count < authorizationDoc.getSourceAccountingLines().size(); ++count) {
            TemSourceAccountingLine accountingLine = (TemSourceAccountingLine)authorizationDoc.getSourceAccountingLines().get(count);
            foundQualification = this.addAccountQualificationForLine(accountingLine, attributes, currentUser);
        }
    }

    protected boolean addAccountQualificationForLine(TemSourceAccountingLine line, Map<String, String> attributes, Person currentUser) {
        if (ObjectUtils.isNull((Object)line.getAccount())) {
            line.refreshReferenceObject("account");
        }
        if (!ObjectUtils.isNull((Object)line.getAccount()) && currentUser.getPrincipalId().equalsIgnoreCase(line.getAccount().getAccountFiscalOfficerSystemIdentifier())) {
            attributes.put("chartOfAccountsCode", line.getChartOfAccountsCode());
            attributes.put("accountNumber", line.getAccountNumber());
            return true;
        }
        return false;
    }

    protected boolean getActionPermission(TravelDocument travelDocument, Person user, String permission) {
        String nameSpaceCode = "KFS-TEM";
        return this.isAuthorized((BusinessObject)travelDocument, "KFS-TEM", permission, user.getPrincipalId());
    }

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActionsFromPresentationController) {
        Set actions = super.getDocumentActions(document, user, documentActionsFromPresentationController);
        TravelAuthorizationDocument travelAuth = (TravelAuthorizationDocument)document;
        if (actions.contains("canAmend") && !this.canAmend(travelAuth, user)) {
            actions.remove("canAmend");
        }
        if (actions.contains("canHold") && !this.canHold(travelAuth, user)) {
            actions.remove("canHold");
        }
        if (actions.contains("canRemoveHold") && !this.canRemoveHold(travelAuth, user)) {
            actions.remove("canRemoveHold");
        }
        if (actions.contains("canCloseTA") && !this.canClose(travelAuth, user)) {
            actions.remove("canCloseTA");
        }
        if (actions.contains("canCancelTA") && !this.canCancel(travelAuth, user)) {
            actions.remove("canCancelTA");
        }
        return actions;
    }

    @Override
    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = (RoleService)SpringContext.getBean(RoleService.class);
        }
        return this.roleService;
    }
}

