/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class ActualExpenseNotesValidation
extends GenericValidation {
    protected ActualExpense actualExpenseForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        ExpenseTypeObjectCode expenseTypeCode = this.getActualExpenseForValidation().getExpenseTypeObjectCode();
        if (ObjectUtils.isNotNull((Object)((Object)expenseTypeCode)) && expenseTypeCode.isNoteRequired() && !this.expenseOrDetailHasNotes(this.getActualExpenseForValidation())) {
            success = false;
            GlobalVariables.getMessageMap().putError("description", "error.required", new String[]{"Notes for expense type " + this.getActualExpenseForValidation().getExpenseTypeCode()});
        }
        return success;
    }

    protected boolean expenseOrDetailHasNotes(ActualExpense expense) {
        if (expense.getExpenseParentId() != null) {
            return true;
        }
        if (!StringUtils.isBlank((String)expense.getDescription())) {
            return true;
        }
        if (!ObjectUtils.isNull(expense.getExpenseDetails()) && !expense.getExpenseDetails().isEmpty()) {
            return this.allDetailsHaveNotes(expense.getExpenseDetails());
        }
        return false;
    }

    protected boolean allDetailsHaveNotes(List<? extends TemExpense> expenseDetails) {
        for (TemExpense temExpense : expenseDetails) {
            if (!StringUtils.isBlank((String)temExpense.getDescription())) continue;
            return false;
        }
        return true;
    }

    public ActualExpense getActualExpenseForValidation() {
        return this.actualExpenseForValidation;
    }

    public void setActualExpenseForValidation(ActualExpense actualExpenseForValidation) {
        this.actualExpenseForValidation = actualExpenseForValidation;
    }
}

