/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class MileageRateRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        super.processCustomSaveDocumentBusinessRules(document);
        MileageRate mileageRate = (MileageRate)document.getNewMaintainableObject().getBusinessObject();
        this.checkRate(mileageRate);
        this.checkDuplicateMileageRate(mileageRate);
        this.checkExpenseType(mileageRate);
        this.checkActiveToDate(mileageRate);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        MileageRate mileageRate = (MileageRate)document.getNewMaintainableObject().getBusinessObject();
        result &= this.checkRate(mileageRate);
        this.checkDuplicateMileageRate(mileageRate);
        result &= this.checkExpenseType(mileageRate);
        return result &= this.checkActiveToDate(mileageRate);
    }

    protected boolean checkRate(MileageRate mileageRate) {
        boolean success = true;
        if (mileageRate.getRate() != null && mileageRate.getRate().compareTo(BigDecimal.ZERO) < 0) {
            this.putFieldError("rate", "error.document.mileage.rate.invalid.rate");
            success = false;
        }
        return success;
    }

    protected boolean checkExpenseType(MileageRate mileageRate) {
        boolean success = true;
        if (!StringUtils.isBlank((String)mileageRate.getExpenseTypeCode())) {
            mileageRate.refreshReferenceObject("expenseType");
            if (!ObjectUtils.isNull((Object)((Object)mileageRate.getExpenseType())) && !TemConstants.ExpenseTypeMetaCategory.MILEAGE.getCode().equals(mileageRate.getExpenseType().getExpenseTypeMetaCategoryCode())) {
                this.putFieldError("expenseTypeCode", "error.document.mileage.rate.invalid.expense.type", new String[]{mileageRate.getExpenseTypeCode()});
                success = false;
            }
        }
        return success;
    }

    protected boolean checkDuplicateMileageRate(MileageRate mileageRate) {
        mileageRate.getActiveFromDate();
        mileageRate.getActiveToDate();
        MileageRate matchedRecord = ((MileageRateService)SpringContext.getBean(MileageRateService.class)).getMileageRateByExpenseTypeCode(mileageRate);
        if (ObjectUtils.isNotNull((Object)((Object)matchedRecord))) {
            String fromDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).toDateString((Date)matchedRecord.getActiveFromDate());
            String toDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).toDateString((Date)matchedRecord.getActiveToDate());
            this.putFieldError("activeFromDate", "error.document.mileage.rate.invalid.effective.date", new String[]{mileageRate.getExpenseTypeCode(), fromDate, toDate});
            return false;
        }
        return true;
    }

    protected boolean checkActiveToDate(MileageRate mileageRate) {
        if (mileageRate.getActiveToDate() == null) {
            return true;
        }
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        Calendar today = dateTimeService.getCurrentCalendar();
        Calendar activeToDate = Calendar.getInstance();
        activeToDate.setTimeInMillis(mileageRate.getActiveToDate().getTime());
        if (!KfsDateUtils.isSameDay((Calendar)today, (Calendar)activeToDate) && activeToDate.compareTo(today) < 0) {
            this.putFieldError("activeToDate", "error.document.mileage.rate.invalid.active.to.date", new String[]{dateTimeService.toDateString((Date)mileageRate.getActiveToDate())});
            return false;
        }
        return true;
    }
}

