/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class ReturnToFiscalOfficerQuestionHandler
implements QuestionHandler<TravelDocument> {
    private ConfigurationService ConfigurationService;
    private DataDictionaryService dataDictionaryService;
    private TravelDocumentService travelDocumentService;

    @Override
    public <T> T handleResponse(Inquisitive<TravelDocument, ?> asker) throws Exception {
        if (asker.denied("ReturnToFiscalOfficer")) {
            return (T)asker.back();
        }
        if (asker.confirmed("ConfirmAmendment")) {
            return (T)asker.end();
        }
        String noteStr = this.getReturnToFiscalOfficerNote("Note entered while returning Travel Reimbursement to fiscal officer : ", asker.getReason());
        String message = this.getReturnToFiscalOfficerQuestion("Return");
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        String question = StringUtils.replace((String)message, (String)"{0}", (String)"Return");
        if (StringUtils.isBlank((String)asker.getReason())) {
            return (T)asker.confirm("ReturnToFiscalOfficer", question, true, "error.travelAuthorization.reasonRequired", "reason", "Return");
        }
        if (noteStr.length() > noteTextMaxLength) {
            return (T)asker.confirm("ReturnToFiscalOfficer", question, true, "error.travelAuthorization.reason.pastLimit", "reason", new Integer(noteStr.length() - noteTextMaxLength).toString());
        }
        TravelDocument document = asker.getDocument();
        this.getTravelDocumentService().routeToFiscalOfficer(document, noteStr);
        return (T)asker.finish();
    }

    @Override
    public <T> T askQuestion(Inquisitive<TravelDocument, ?> asker) throws Exception {
        String message = this.getReturnToFiscalOfficerQuestion("Return");
        Object retval = asker.confirm("ReturnToFiscalOfficer", message, true, new String[0]);
        return (T)retval;
    }

    public String getReturnToFiscalOfficerQuestion(String operation) {
        String message = "";
        String key = this.getConfigurationService().getPropertyValueAsString("travelAuthorization.question.text");
        message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
        return message;
    }

    public String getMessageFrom(String messageType) {
        return this.getConfigurationService().getPropertyValueAsString(messageType);
    }

    public String getReturnToFiscalOfficerNote(String notePrefix, String reason) {
        String noteText = "";
        String introNoteMessage = notePrefix + " ";
        noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (ObjectUtils.isNull((Object)reason)) {
                reason = "";
            }
        }
        return noteText;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    protected ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }
}

